/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.MimeTypeUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.NativeMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AzCopyOperation
extends NativeMimeTypeVolumesUtilizationOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AzCopyOperation.class);
    private transient long totalFilescCopied;
    private transient long totalFilesFailed;
    private transient Map<String, MimeTypeVolume> mimeTypeVolumes;
    private transient String stageName;
    private transient Process azCopyProcess;
    private transient boolean copyStarted;
    private transient double azCopyPercentageComplete;
    private transient double throughputMbps;
    private transient Thread readStandardOutputThread;
    private transient Thread readStandardErrorThread;
    private transient Thread readLogFileThread;
    protected transient Exception inferredException;
    private transient Pattern logFilePattern = Pattern.compile("Log file is located at: (.*)");
    private transient Pattern detailedPattern = Pattern.compile("^([\\d\\.]+) %, ([\\d]+) Done, ([\\d\\.]+) Failed, [\\d\\.]+ Pending, [\\d\\.]+ Skipped, [\\d\\.]+ Total, 2-sec Throughput \\(Mb\\/s\\): ([\\d\\.]+).*");
    private transient Pattern simplePattern = Pattern.compile("^([\\d\\.]+) %, ([\\d]+) Done, ([\\d\\.]+) Failed.*");
    private transient Pattern downloadSuccessfull = Pattern.compile(".*DOWNLOADSUCCESSFUL: (.*)");
    private transient Pattern downloadFailed = Pattern.compile(".*FAILED: ([^:]*).*");
    private transient List<String> azCopyLocations = new ArrayList<String>(Arrays.asList(SystemUtils.getProgramFilesDir() + "\\Nuix\\Automate\\bin\\azcopy\\azcopy.exe", "/usr/bin/azcopy", "/usr/local/bin/azcopy"));

    public void runExternalApplication(List<String> commandLineArguments) throws IOException, InterruptedException {
        this.mimeTypeVolumes = new HashMap<String, MimeTypeVolume>();
        this.totalFilescCopied = 0L;
        this.totalFilesFailed = 0L;
        this.azCopyPercentageComplete = 0.0;
        Path applicationPath = null;
        for (String location : this.azCopyLocations) {
            Path locationPath = Paths.get(location, new String[0]);
            if (!Files.exists(locationPath, new LinkOption[0])) continue;
            applicationPath = locationPath;
            break;
        }
        if (applicationPath == null) {
            throw new IOException(this.iu.getString("AzCopy.Error.CannotFindAzCopy"));
        }
        this.addExecutionLog(this.iu.getString("AzCopy.Log.StartingApplication"));
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(applicationPath.toString());
        commandLine.addAll(commandLineArguments);
        ProcessBuilder builder = new ProcessBuilder(commandLine);
        builder.environment().put("AZCOPY_PARALLEL_STAT_FILES", "true");
        NetworkConfiguration networkConfiguration = NetworkConfiguration.fromSystemProperties();
        if (networkConfiguration.isProxyConfigured()) {
            LOGGER.info("Setting azcopy proxy settings");
            builder.environment().put("HTTPS_PROXY", networkConfiguration.getProxyHost() + ":" + networkConfiguration.getProxyPort());
            Set nonProxyHosts = networkConfiguration.getNonProxyHosts();
            if (!nonProxyHosts.isEmpty()) {
                builder.environment().put("NO_PROXY", String.join((CharSequence)",", nonProxyHosts));
            }
        }
        this.azCopyProcess = builder.start();
        LOGGER.info("Application Running");
        BufferedReader standardInputReader = new BufferedReader(new InputStreamReader(this.azCopyProcess.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.azCopyProcess.getErrorStream()));
        this.readStandardOutputThread = new Thread(() -> {
            try {
                this.readOutputStream(standardInputReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard output stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    standardInputReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardOutputThread.setName("azcopy stdout");
        this.readStandardOutputThread.start();
        this.readStandardErrorThread = new Thread(() -> {
            try {
                this.readErrorStream(errorReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard error stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardErrorThread.setName("azcopy stderr");
        this.readStandardErrorThread.start();
    }

    public void readLogFileStream(BufferedReader logFileReader) throws IOException {
        String line;
        LOGGER.info("Starting log reader");
        long lines = 0L;
        while ((line = logFileReader.readLine()) != null || this.azCopyProcess != null && this.azCopyProcess.isAlive()) {
            if (Thread.interrupted()) {
                return;
            }
            if (line != null) {
                ++lines;
                try {
                    Matcher m = this.downloadSuccessfull.matcher(line);
                    if (m.matches()) {
                        this.itemProcessed(Paths.get(m.group(1).replace("\\\\?\\", ""), new String[0]), false);
                    }
                    if (!(m = this.downloadFailed.matcher(line)).matches()) continue;
                    LOGGER.warn("Cannot download file, " + line);
                    this.itemProcessed(Paths.get(m.group(1).replace("\\\\?\\", "").trim(), new String[0]), true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot handle log line", (Throwable)e);
                }
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        LOGGER.info("Finished reading " + lines + " lines from log");
    }

    public void readOutputStream(BufferedReader standardInputReader) throws IOException {
        LOGGER.info("Starting stdout reader");
        String line = "";
        while ((line = standardInputReader.readLine()) != null) {
            Matcher m;
            if (Thread.interrupted()) {
                return;
            }
            boolean match = false;
            if (line.toLowerCase().startsWith("failed to")) {
                this.inferredException = new IOException(line);
            }
            try {
                m = this.logFilePattern.matcher(line);
                if (m.matches()) {
                    String logFile = m.group(1);
                    LOGGER.info("Detected log file: " + logFile);
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{azcopy_log_file}", logFile)));
                    this.addExecutionLog(this.iu.getFormattedString("AzureContainerDownloadOperation.Log.AzCopyLog", (Object)logFile));
                    if (this.readLogFileThread == null) {
                        this.readLogFileThread = new Thread(() -> {
                            BufferedReader logFileReader = null;
                            try {
                                logFileReader = Files.newBufferedReader(Paths.get(logFile, new String[0]));
                                this.readLogFileStream(logFileReader);
                            }
                            catch (IOException e) {
                                LOGGER.error("Cannot read standard output stream", (Throwable)e);
                                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
                            }
                            finally {
                                try {
                                    if (logFileReader != null) {
                                        logFileReader.close();
                                    }
                                }
                                catch (IOException e) {
                                    LOGGER.error("Cannot close stream", (Throwable)e);
                                }
                            }
                        });
                        this.readLogFileThread.start();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot parse azcopy");
            }
            try {
                m = this.detailedPattern.matcher(line);
                if (m.matches()) {
                    this.azCopyPercentageComplete = Double.parseDouble(m.group(1)) / 100.0;
                    this.totalFilescCopied = Long.parseLong(m.group(2));
                    this.totalFilesFailed = Long.parseLong(m.group(3));
                    this.throughputMbps = Double.parseDouble(m.group(4));
                    match = true;
                    this.copyStarted = true;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot parse azcopy");
            }
            if (!match) {
                try {
                    m = this.simplePattern.matcher(line);
                    if (m.matches()) {
                        this.azCopyPercentageComplete = Double.parseDouble(m.group(1)) / 100.0;
                        this.totalFilescCopied = Long.parseLong(m.group(2));
                        this.totalFilesFailed = Long.parseLong(m.group(3));
                        this.throughputMbps = 0.0;
                        this.copyStarted = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse azcopy");
                }
            }
            LOGGER.info("azcopy: " + line);
        }
        LOGGER.info("Finished reading stdout");
    }

    public void readErrorStream(BufferedReader errorReader) throws IOException {
        String line;
        LOGGER.info("Starting stderr reader");
        while ((line = errorReader.readLine()) != null) {
            if (Thread.interrupted()) {
                return;
            }
            if (line.trim().length() > 0 && !line.startsWith(" ")) {
                this.addWarning(line);
            }
            LOGGER.warn(line);
        }
        LOGGER.info("Finished reading stderr");
    }

    protected void waitForIo() {
        try {
            this.azCopyProcess.waitFor();
            this.readStandardOutputThread.join();
            this.readStandardErrorThread.join();
            if (this.readLogFileThread != null) {
                this.readLogFileThread.join();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted");
        }
    }

    @Override
    public void stopTriggered() {
        this.stopRequested = true;
        if (this.azCopyProcess != null) {
            try {
                this.azCopyProcess.destroy();
            }
            catch (Exception e) {
                LOGGER.warn("Cannot stop process", (Throwable)e);
            }
        }
        if (this.readLogFileThread != null) {
            try {
                this.readLogFileThread.interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("Cannot interrupt thread");
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        return this.azCopyPercentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        this.stageName = this.copyStarted ? this.iu.getString("AzCopy.Stage.Copying") : this.iu.getString("AzCopy.Stage.Scanning");
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.totalFilescCopied > 0L) {
            result = (String)result + " ";
            result = (String)result + this.iu.getNumeralString("AzCopy.Progress.FilesProcessed", this.totalFilescCopied);
        }
        if (this.totalFilesFailed > 0L) {
            result = (String)result + " / ";
            result = (String)result + this.iu.getNumeralString("AzCopy.Progress.FilesFailed", this.totalFilesFailed);
        }
        if (this.throughputMbps > 0.0) {
            result = (String)result + " / ";
            result = (String)result + " " + this.iu.getFormattedString("AzCopy.Progress.Throughput", (Object)String.format("%.2f", this.throughputMbps));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemProcessed(Path destinationPath, boolean failed) {
        String fileExtension = FileUtils.getFileExtension((String)destinationPath.getFileName().toString()).toLowerCase();
        String mimeType = MimeTypeUtils.getInstance().getMimeType(fileExtension);
        String translatedStage = this.iu.getString("MimeType.Stage.download");
        if (!failed) {
            MimeTypeVolume mimeTypeVolume = null;
            Map<String, MimeTypeVolume> map = this.mimeTypeVolumes;
            synchronized (map) {
                mimeTypeVolume = this.mimeTypeVolumes.get(mimeType);
                if (mimeTypeVolume == null) {
                    mimeTypeVolume = new MimeTypeVolume();
                    mimeTypeVolume.setMimeTypeId(mimeType);
                    this.mimeTypeVolumes.put(mimeType, mimeTypeVolume);
                }
            }
            mimeTypeVolume.incrementAuditedCount();
            mimeTypeVolume.incrementPhysicalCount();
            mimeTypeVolume.incrementItemsCount();
            try {
                long size = Files.size(destinationPath);
                mimeTypeVolume.addAuditedSize(size);
                mimeTypeVolume.addDigestSize(size);
                mimeTypeVolume.addPhysicalSize(size);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Copied", (Object)destinationPath));
        this.trackItemProcessedFailed(mimeType, "download", failed);
    }

    @Override
    public List<MimeTypeVolume> getMimeTypeVolumes() {
        return new ArrayList<MimeTypeVolume>(this.mimeTypeVolumes.values());
    }

    @Override
    public long getVolume(WorkflowExecution workflowExecution) {
        long volume = 0L;
        for (MimeTypeVolume mimeTypeVolume : this.getMimeTypeVolumes()) {
            volume += mimeTypeVolume.getAuditedSize();
        }
        return volume;
    }

    protected void logResults() {
        this.addExecutionLog(this.iu.getNumeralString("AzCopy.CopyNBlobs", this.totalFilescCopied));
        if (this.totalFilesFailed > 0L) {
            this.addWarning(this.iu.getNumeralString("AzCopy.FailedCopyNBlobs", this.totalFilesFailed));
        }
    }
}

