/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.azure.AzureStorageClient;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.AzureContainerCopyOperation;
import java.io.IOException;
import java.util.ArrayList;

public class AzureContainerCopyOperationImplementation
extends AzureContainerCopyOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AzureContainerCopyOperation.class);

    @Override
    protected void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.startTriggerThread = new Thread(() -> {
            try {
                AzureStorageClient azureStorageClient = new AzureStorageClient();
                this.sourceContainerSasToken = this.executionContext.evalProtectedParameter(this.sourceContainerSasToken);
                if (!this.sourceContainerSasToken.startsWith("?")) {
                    this.sourceContainerSasToken = "?" + this.sourceContainerSasToken;
                }
                this.sourceContainerUrl = this.executionContext.evalParameters(this.sourceContainerUrl, this);
                if (!this.sourceContainerUrl.toLowerCase().startsWith("http://") && !this.sourceContainerUrl.toLowerCase().startsWith("https://")) {
                    throw new IOException("Invalid source storage container URL");
                }
                String invalidSourceToken = azureStorageClient.validateStorageAccountSasToken(this.sourceContainerSasToken, "Source");
                if (invalidSourceToken != null) {
                    LOGGER.error(invalidSourceToken);
                    this.setErrorMessage(invalidSourceToken);
                    this.exception = new Exception(invalidSourceToken);
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.destinationContainerSasToken = this.executionContext.evalProtectedParameter(this.destinationContainerSasToken);
                if (!this.destinationContainerSasToken.startsWith("?")) {
                    this.destinationContainerSasToken = "?" + this.destinationContainerSasToken;
                }
                this.destinationContainerUrl = this.executionContext.evalParameters(this.destinationContainerUrl, this);
                if (!this.destinationContainerUrl.toLowerCase().startsWith("http://") && !this.destinationContainerUrl.toLowerCase().startsWith("https://")) {
                    throw new IOException("Invalid destination storage container URL");
                }
                String invalidDestinationToken = azureStorageClient.validateStorageAccountSasToken(this.destinationContainerSasToken, "Destination");
                if (invalidDestinationToken != null) {
                    LOGGER.error(invalidDestinationToken);
                    this.setErrorMessage(invalidDestinationToken);
                    this.exception = new Exception(invalidDestinationToken);
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.addExecutionLog(this.iu.getFormattedString("AzureContainerCopyOperation.Log.SourceStorageContainerUrl", (Object)this.sourceContainerUrl));
                this.addExecutionLog(this.iu.getFormattedString("AzureContainerCopyOperation.Log.DestinationStorageContainerUrl", (Object)this.destinationContainerUrl));
                ArrayList<String> commandLine = new ArrayList<String>();
                commandLine.add("copy");
                commandLine.add(this.sourceContainerUrl + this.sourceContainerSasToken);
                commandLine.add(this.destinationContainerUrl + this.destinationContainerSasToken);
                commandLine.add("--recursive");
                commandLine.add("--log-level=INFO");
                if (this.flags != null && this.flags.trim().length() > 0) {
                    commandLine.add(this.flags.trim());
                    this.addExecutionLog(this.iu.getFormattedString("AzureContainerCopyOperation.Log.Flags", (Object)this.flags));
                }
                this.runExternalApplication(commandLine);
                this.waitForIo();
                this.logResults();
                if (this.inferredException != null) {
                    throw this.inferredException;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }
}

