/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.azure.AzureStorageClient;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.AzureContainerDownloadOperation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

public class AzureContainerDownloadOperationImplementation
extends AzureContainerDownloadOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AzureContainerDownloadOperation.class);

    @Override
    protected void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.startTriggerThread = new Thread(() -> {
            try {
                String invalidToken;
                AzureStorageClient azureStorageClient = new AzureStorageClient();
                this.storageAccountSasToken = this.executionContext.evalProtectedParameter(this.storageAccountSasToken);
                if (!this.storageAccountSasToken.startsWith("?")) {
                    this.storageAccountSasToken = "?" + this.storageAccountSasToken;
                }
                this.storageContainerUrl = this.executionContext.evalParameters(this.storageContainerUrl, this);
                this.downloadLocation = this.executionContext.evalParameters(this.downloadLocation, this);
                Path downloadLocationPath = Paths.get(this.downloadLocation, new String[0]);
                if (Files.exists(downloadLocationPath, new LinkOption[0])) {
                    if (!Files.isDirectory(downloadLocationPath, new LinkOption[0])) {
                        LOGGER.error("Download location is not a directory");
                        String errorMessage = this.iu.getString("AzureContainerDownloadOperation.Exception.DownloadLocationNotADirectory");
                        this.setErrorMessage(errorMessage);
                        this.exception = new Exception(errorMessage);
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    if (!FileUtils.isDirectoryEmpty((Path)downloadLocationPath)) {
                        LOGGER.error("Download location must be empty");
                        String errorMessage = this.iu.getString("AzureContainerDownloadOperation.Exception.DownloadLocationNotEmpty");
                        this.setErrorMessage(errorMessage);
                        this.exception = new Exception(errorMessage);
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                }
                if (!Files.exists(downloadLocationPath, new LinkOption[0])) {
                    Files.createDirectories(downloadLocationPath, new FileAttribute[0]);
                }
                if ((invalidToken = azureStorageClient.validateStorageAccountSasToken(this.storageAccountSasToken, "Source")) != null) {
                    LOGGER.error(invalidToken);
                    this.setErrorMessage(invalidToken);
                    this.exception = new Exception(invalidToken);
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.addExecutionLog(this.iu.getFormattedString("AzureContainerDownloadOperation.Log.StorageContainerUrl", (Object)this.storageContainerUrl));
                this.addExecutionLog(this.iu.getFormattedString("AzureContainerDownloadOperation.Log.DownloadLocation", (Object)this.downloadLocation));
                if (!this.storageContainerUrl.toLowerCase().startsWith("http://") && !this.storageContainerUrl.toLowerCase().startsWith("https://")) {
                    throw new IOException("Invalid storage container URL");
                }
                ArrayList<String> commandLine = new ArrayList<String>();
                commandLine.add("copy");
                commandLine.add(this.storageContainerUrl + this.storageAccountSasToken);
                commandLine.add(this.downloadLocation);
                commandLine.add("--from-to=BlobLocal");
                commandLine.add("--recursive");
                commandLine.add("--log-level=INFO");
                this.runExternalApplication(commandLine);
                this.waitForIo();
                this.logResults();
                if (this.inferredException != null) {
                    throw this.inferredException;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }
}

