/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.utils.azure.AzureStorageAccountOperationException;
import com.nuix.automate.workflow.core.utils.azure.AzureStorageAccountRestClient;
import com.nuix.automate.workflow.core.utils.general.OperationRunnable;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AzureStorageAccountOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AzureStorageAccountOperation.class);
    protected transient AzureStorageAccountRestClient storageAccountRestClient;
    protected transient String stageName;
    protected transient double percentageComplete;
    protected transient String storageAccountUrl;
    protected transient String storageAccountName;

    public AzureStorageAccountOperation() {
        this.requiresCase = false;
    }

    protected void initializeRestClient() throws ParameterException, GeneralSecurityException, UnsupportedEncodingException {
        this.storageAccountUrl = this.executionContext.evalParameters("{azure_storage_account_url}", this);
        this.storageAccountName = this.executionContext.evalParameters("{azure_storage_account_name}", this);
        String storageAccountKey = this.executionContext.evalProtectedParameter("{azure_storage_account_key_protected}");
        this.storageAccountRestClient = new AzureStorageAccountRestClient(this.storageAccountUrl, this.storageAccountName, storageAccountKey);
    }

    @Override
    protected void runStartTriggeredThread(OperationRunnable operationRunnable) {
        this.startTriggerThread = new Thread(() -> {
            try {
                operationRunnable.run();
                this.trackFinished();
            }
            catch (AzureStorageAccountOperationException e) {
                LOGGER.error("Error during " + this.getOperationName(), (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected List<String> getMissingRequiredOperations(Class<?> ... requiredOperations) {
        ArrayList requiredClasses = new ArrayList(Arrays.asList(requiredOperations));
        for (Operation operation : this.executionContext.workflowExecution.getWorkflow().getOperations()) {
            requiredClasses.removeIf(clazz -> clazz.isAssignableFrom(operation.getClass()) && !operation.disabled);
            if (operation != this && !requiredClasses.isEmpty()) continue;
            break;
        }
        return requiredClasses.stream().map(clazz -> this.iu.getString("AzureStorageAccountOperation.Prerequisites.Missing" + clazz.getSimpleName())).collect(Collectors.toList());
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        return new HashSet<Feature>();
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && !this.stageName.isEmpty()) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }
}

