/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.common.base.CaseFormat;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.BrainspaceManageBuildOperation;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceRestClient;
import java.io.IOException;

public class BrainspaceManageBuildOperationImplementation
extends BrainspaceManageBuildOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BrainspaceManageBuildOperation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                double waitPercentageComplete;
                long minutesRemaining;
                long timeoutTime;
                String printableState;
                String state;
                long startTime;
                long duration;
                this.stageName = "";
                String apiUrl = this.executionContext.evalParameters("{wfn_brainspace_api_url}", this);
                String apiKey = this.executionContext.evalProtectedParameter("{wfn_brainspace_api_key_protected}");
                String certificateFingerprint = this.executionContext.evalParameters("{wfn_brainspace_api_certificate_fingerprint}", this);
                Integer datasetId = this.executionContext.evalIntParameter("{brainspace_dataset_id}", this);
                BrainspaceRestClient brainspaceRestClient = new BrainspaceRestClient(apiUrl, apiKey, certificateFingerprint);
                this.percentageComplete = 0.1;
                if (this.waitForPreviousBuild) {
                    duration = this.waitForPreviousBuildTimeout * 60 * 1000;
                    startTime = System.currentTimeMillis();
                    state = "UNKNOWN";
                    printableState = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, state);
                    timeoutTime = startTime + duration;
                    minutesRemaining = Math.max(0L, timeoutTime - System.currentTimeMillis()) / 1000L / 60L;
                    state = brainspaceRestClient.getDatasetBuildState(datasetId.intValue());
                    if (state.equals("COMPLETED") || state.equals("CREATED") || state.equals("FAILED") || state.equals("INGESTION_COMPLETED") || state.equals("INGESTION_FAILED") || state.equals("BUILD_CANCELED")) {
                        this.addExecutionLog(this.iu.getString("BuildBrainspaceDatasetOperation.Log.NoPreviousBuildRunning"));
                    } else {
                        this.addExecutionLog(this.iu.getString("BuildBrainspaceDatasetOperation.Log.WaitingForPreviousBuildToComplete"));
                        this.stageName = this.iu.getFormattedString("BuildBrainspaceDatasetOperation.Log.WaitingForPreviousBuildToCompleteStatus", (Object)printableState);
                        while (true) {
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            try {
                                state = brainspaceRestClient.getDatasetBuildState(datasetId.intValue());
                                LOGGER.info("Dataset state: " + state);
                                if (state.equals("COMPLETED")) break;
                                if (state.equalsIgnoreCase("FAILED") || state.equalsIgnoreCase("BUILD_CANCELED")) {
                                    this.addWarning(this.iu.getFormattedString("BuildBrainspaceDatasetOperation.Log.PreviousBuildNotComplete", (Object)printableState));
                                    break;
                                }
                            }
                            catch (IOException ex) {
                                LOGGER.warn("Brainspace API error", (Throwable)ex);
                            }
                            printableState = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, state);
                            minutesRemaining = Math.max(0L, timeoutTime - System.currentTimeMillis()) / 1000L / 60L;
                            this.stageName = this.iu.getFormattedString("BuildBrainspaceDatasetOperation.Log.WaitingForPreviousBuildToCompleteStatus", (Object)printableState);
                            waitPercentageComplete = Math.max(0.0, (double)(System.currentTimeMillis() - startTime) / (double)duration);
                            this.percentageComplete = 0.1 + waitPercentageComplete * 0.4;
                            if (System.currentTimeMillis() >= timeoutTime) {
                                throw new IOException(this.iu.getFormattedString("BuildBrainspaceDatasetOperation.Log.PreviousBuildNotComplete", (Object)printableState));
                            }
                            Thread.sleep(1000L);
                        }
                    }
                }
                this.percentageComplete = 0.5;
                if (this.buildDataset) {
                    this.stageName = this.iu.getString("UseBrainspaceDataset.Stage.SubmittingDataset");
                    this.addExecutionLog(this.iu.getString("UseBrainspaceDataset.Stage.SubmittingDataset"));
                    brainspaceRestClient.submitDataset(datasetId.intValue());
                }
                this.percentageComplete = 0.6;
                if (this.waitForBuildToComplete) {
                    duration = this.waitForBuildToCompleteTimeout * 60 * 1000;
                    startTime = System.currentTimeMillis();
                    state = "UNKNOWN";
                    printableState = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, state);
                    timeoutTime = startTime + duration;
                    minutesRemaining = Math.max(0L, timeoutTime - System.currentTimeMillis()) / 1000L / 60L;
                    this.stageName = this.iu.getFormattedString("BuildBrainspaceDatasetOperation.Log.WaitingForBuildToCompleteStatus", (Object)printableState);
                    this.addExecutionLog(this.iu.getString("BuildBrainspaceDatasetOperation.Log.WaitingForBuildToComplete"));
                    while (true) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        try {
                            state = brainspaceRestClient.getDatasetBuildState(datasetId.intValue());
                            LOGGER.info("Dataset state: " + state);
                            if (state.equalsIgnoreCase("COMPLETED")) break;
                            if (state.equalsIgnoreCase("FAILED") || state.equalsIgnoreCase("BUILD_CANCELED")) {
                                throw new IllegalStateException(this.iu.getFormattedString("BuildBrainspaceDatasetOperation.Log.BuildNotComplete", (Object)printableState));
                            }
                        }
                        catch (IOException ex) {
                            LOGGER.warn("Brainspace API error", (Throwable)ex);
                        }
                        printableState = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, state);
                        minutesRemaining = Math.max(0L, timeoutTime - System.currentTimeMillis()) / 1000L / 60L;
                        this.stageName = this.iu.getFormattedString("BuildBrainspaceDatasetOperation.Log.WaitingForBuildToCompleteStatus", (Object)printableState);
                        waitPercentageComplete = Math.max(0.0, (double)(System.currentTimeMillis() - startTime) / (double)duration);
                        this.percentageComplete = 0.6 + waitPercentageComplete * 0.4;
                        if (System.currentTimeMillis() >= timeoutTime) {
                            throw new IOException(this.iu.getFormattedString("BuildBrainspaceDatasetOperation.Log.BuildNotComplete", (Object)printableState));
                        }
                        Thread.sleep(1000L);
                    }
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

