/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.BrainspacePropagateTagsOperation;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceRestClient;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceTagChoice;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceTagDefinition;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class BrainspacePropagateTagsOperationImplementation
extends BrainspacePropagateTagsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BrainspacePropagateTagsOperation.class);
    private transient String stageName;
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;
    private transient int stageCount;
    private transient int stageId;
    private transient Set<String> classifierFieldNames;
    private transient Set<String> numericFieldNames;
    private transient String brainspaceRootTag;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                String[] splits;
                AtomicLong brainspaceItemsWithoutNuixGuidCount = new AtomicLong(0L);
                AtomicLong brainspaceItemsWithNoMatchingNuixGuidCount = new AtomicLong(0L);
                AtomicLong brainspaceItemsWithMatchingNuixGuidCount = new AtomicLong(0L);
                AtomicLong nuixItemsWithNestedTags = new AtomicLong(0L);
                AtomicLong nuixItemsWithMultipleChoices = new AtomicLong(0L);
                AtomicLong nuixItemsWithRootTag = new AtomicLong(0L);
                AtomicLong nuixItemsWithoutTagChoices = new AtomicLong(0L);
                AtomicLong failedNuixItems = new AtomicLong(0L);
                AtomicLong matchedItemsCount = new AtomicLong(0L);
                ConcurrentHashMap.KeySetView matchedFields = ConcurrentHashMap.newKeySet();
                ConcurrentHashMap taggedItemsCounts = new ConcurrentHashMap();
                this.classifierFieldNames = new HashSet<String>();
                this.numericFieldNames = new HashSet<String>();
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.nuixRootTag = this.executionContext.evalParameters(this.nuixRootTag, this).trim();
                if (!this.nuixRootTag.endsWith("|")) {
                    this.nuixRootTag = this.nuixRootTag + "|";
                }
                String nuixRootTagExplicit = this.nuixRootTag.substring(0, this.nuixRootTag.length() - 1);
                for (String split : splits = this.nuixRootTag.split("\\|")) {
                    if (split.trim().length() <= 0) continue;
                    this.brainspaceRootTag = split;
                }
                if (this.brainspaceRootTag == null || this.brainspaceRootTag.length() == 0) {
                    throw new IllegalArgumentException("Invalid Nuix root tag");
                }
                String apiUrl = this.executionContext.evalParameters("{wfn_brainspace_api_url}", this);
                String apiKey = this.executionContext.evalProtectedParameter("{wfn_brainspace_api_key_protected}");
                String certificateFingerprint = this.executionContext.evalParameters("{wfn_brainspace_api_certificate_fingerprint}", this);
                Integer datasetId = this.executionContext.evalIntParameter("{brainspace_dataset_id}", this);
                BrainspaceRestClient brainspaceRestClient = new BrainspaceRestClient(apiUrl, apiKey, certificateFingerprint);
                this.stageCount = 2;
                this.stageId = 0;
                this.countItemsProcessed = new AtomicLong(0L);
                this.stageName = this.iu.getString("BrainspaceRetrieveMetadataOperation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getFormattedString("BrainspaceRetrieveMetadataOperation.Log.Scope", (Object)this.scope));
                LOGGER.info("Searching for items to update: " + this.scope);
                Set itemsToUpdate = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.countItemsToProcess = itemsToUpdate.size();
                LOGGER.info("Got " + this.countItemsToProcess + " items");
                this.addExecutionLog(this.iu.getNumeralString("BrainspaceRetrieveMetadataOperation.Log.ScopeCount", this.countItemsToProcess));
                HashMap<String, String> guidToTag = new HashMap<String, String>();
                TreeMap<String, AtomicLong> choiceCounts = new TreeMap<String, AtomicLong>();
                HashMap nuixItems = new HashMap();
                for (Item item : itemsToUpdate) {
                    boolean itemHasNestedTags = false;
                    boolean itemHasMultipleChoices = false;
                    boolean itemHasRootTag = false;
                    boolean itemHasTagChoices = false;
                    String itemTagValue = null;
                    for (String itemTag : item.getTags()) {
                        if (itemTag.startsWith(this.nuixRootTag)) {
                            itemHasRootTag = true;
                            String effectiveTag = itemTag.substring(this.nuixRootTag.length());
                            if (effectiveTag.length() <= 0) continue;
                            itemHasTagChoices = true;
                            splits = effectiveTag.split("\\|");
                            if (splits.length > 1) {
                                itemHasNestedTags = true;
                            }
                            if (itemTagValue != null) {
                                itemHasMultipleChoices = true;
                            }
                            itemTagValue = splits[0];
                            continue;
                        }
                        if (!itemTag.equals(nuixRootTagExplicit)) continue;
                        itemHasRootTag = true;
                    }
                    if (!itemHasMultipleChoices && itemTagValue != null) {
                        guidToTag.put(item.getGuid(), itemTagValue);
                    }
                    if (itemTagValue != null) {
                        AtomicLong count = new AtomicLong(0L);
                        AtomicLong existingCount = choiceCounts.putIfAbsent(itemTagValue, count);
                        if (existingCount != null) {
                            count = existingCount;
                        }
                        count.incrementAndGet();
                    }
                    if (itemHasNestedTags) {
                        nuixItemsWithNestedTags.incrementAndGet();
                    }
                    if (itemHasMultipleChoices) {
                        nuixItemsWithMultipleChoices.incrementAndGet();
                    }
                    if (itemHasRootTag) {
                        nuixItemsWithRootTag.incrementAndGet();
                    }
                    if (!itemHasTagChoices) {
                        nuixItemsWithoutTagChoices.incrementAndGet();
                    }
                    this.countItemsProcessed.incrementAndGet();
                }
                this.addExecutionLog(this.iu.getNumeralString("BrainspacePropagateTagsOperation.Log.MatchedItems", nuixItemsWithRootTag.get()));
                if (nuixItemsWithoutTagChoices.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("BrainspacePropagateTagsOperation.Warning.ItemsWithNoChoice", nuixItemsWithoutTagChoices.get()));
                }
                if (nuixItemsWithMultipleChoices.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("BrainspacePropagateTagsOperation.Warning.ItemsWithMultipleChoices", nuixItemsWithMultipleChoices.get()));
                }
                if (nuixItemsWithNestedTags.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("BrainspacePropagateTagsOperation.Warning.ItemsWithNestedChoices", nuixItemsWithNestedTags.get()));
                }
                for (String tagChoice : choiceCounts.keySet()) {
                    this.addExecutionLog(this.iu.getNumeralFormattedString("BrainspacePropagateTagsOperation.Log.MatchedItemsTag", ((AtomicLong)choiceCounts.get(tagChoice)).get(), (Object)tagChoice));
                }
                this.stageName = this.iu.getString("BrainspacePropagateTagsOperation.Stage.PropagatingTags");
                ++this.stageId;
                this.countItemsProcessed = new AtomicLong(0L);
                this.countItemsToProcess = guidToTag.size();
                if (guidToTag.size() > 0) {
                    long nuixItemsWithoutMatchCount;
                    Set<String> missingChoices;
                    TreeMap<String, Long> tagChoiceIds = new TreeMap<String, Long>();
                    List<BrainspaceTagDefinition> tagChoices = brainspaceRestClient.getAllChoiceTags(datasetId.intValue());
                    BrainspaceTagDefinition tagDefinition = null;
                    for (BrainspaceTagDefinition candidateTagDefinition : tagChoices) {
                        if (!this.brainspaceRootTag.equals(candidateTagDefinition.getName())) continue;
                        tagDefinition = candidateTagDefinition;
                        for (BrainspaceTagChoice tagChoice : candidateTagDefinition.getChoices()) {
                            tagChoiceIds.put(tagChoice.getValue(), tagChoice.getId());
                        }
                    }
                    if (tagDefinition == null) {
                        this.addExecutionLog(this.iu.getFormattedString("BrainspacePropagateTagsOperation.Log.CreatingBrainspaceTag", (Object)this.brainspaceRootTag));
                        tagDefinition = brainspaceRestClient.createSingleChoiceTag(datasetId.intValue(), this.brainspaceRootTag, choiceCounts.keySet());
                        for (BrainspaceTagChoice tagChoice : tagDefinition.getChoices()) {
                            tagChoiceIds.put(tagChoice.getValue(), tagChoice.getId());
                        }
                    } else {
                        missingChoices = choiceCounts.keySet();
                        missingChoices.removeAll(tagChoiceIds.keySet());
                        if (missingChoices.size() > 0) {
                            this.addExecutionLog(this.iu.getFormattedString("BrainspacePropagateTagsOperation.Log.UpdatingBrainspaceTagChoices", new Object[]{this.brainspaceRootTag, String.join((CharSequence)", ", missingChoices)}));
                            tagDefinition = brainspaceRestClient.updateTag(datasetId.intValue(), tagDefinition, missingChoices);
                            for (BrainspaceTagChoice tagChoice : tagDefinition.getChoices()) {
                                tagChoiceIds.put(tagChoice.getValue(), tagChoice.getId());
                            }
                        }
                    }
                    missingChoices = choiceCounts.keySet();
                    missingChoices.removeAll(tagChoiceIds.keySet());
                    if (missingChoices.size() > 0) {
                        throw new IllegalStateException("Missing Brainspace tag " + this.brainspaceRootTag + " choices " + String.join((CharSequence)(", " + String.valueOf(missingChoices)), new CharSequence[0]));
                    }
                    FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(guidToTag.entrySet(), ItemsUtils.getPartitionerChunkSize(10, this));
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        while (iterator.hasNext()) {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            Map.Entry entry = (Map.Entry)iterator.next();
                            String nuixGuid = (String)entry.getKey();
                            String choiceName = (String)entry.getValue();
                            Long choiceId = (Long)tagChoiceIds.get(choiceName);
                            if (choiceId == null) {
                                failedNuixItems.incrementAndGet();
                                LOGGER.error("Cannot find tag choice " + choiceName);
                            } else {
                                try {
                                    brainspaceRestClient.tagItem(datasetId.intValue(), nuixGuid, choiceId);
                                    matchedItemsCount.incrementAndGet();
                                }
                                catch (IOException e) {
                                    failedNuixItems.incrementAndGet();
                                    LOGGER.warn("Cannot tag item " + nuixGuid, (Throwable)e);
                                }
                            }
                            this.countItemsProcessed.incrementAndGet();
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    if (failedNuixItems.get() > 0L) {
                        this.addWarning(this.iu.getNumeralString("BrainspaceRetrieveMetadataOperation.Error.FailedItems", failedNuixItems.get()));
                    }
                    if ((nuixItemsWithoutMatchCount = (long)nuixItems.size() - matchedItemsCount.get()) > 0L) {
                        this.addWarning(this.iu.getNumeralString("BrainspaceRetrieveMetadataOperation.Error.NuixItemsNotMatched", nuixItemsWithoutMatchCount));
                    }
                    this.addExecutionLog(this.iu.getNumeralString("BrainspacePropagateTagsOperation.Log.TaggedItems", matchedItemsCount.get()));
                }
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        double stagePercent = 0.0;
        if (this.countItemsToProcess > 0L) {
            stagePercent = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        if (this.stageCount > 0) {
            percentageComplete = ((double)this.stageId + stagePercent) / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
            if (this.countItemsToProcess > 0L && this.countItemsProcessed != null) {
                result = (String)result + " / ";
                result = (String)result + this.iu.getNumeralString("BrainspaceLoadItems.Progress.ItemsProcessed", this.countItemsProcessed.get());
            }
        }
        return result;
    }
}

