/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldHelper;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.SensitiveField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.usebrainspacedataset.BrainspaceIdentifierType;
import java.util.List;

@FormFieldRows(value={@FormFieldRow(name="datasetIdentifierRow", children={"datasetIdentifierType", "datasetIdentifier"}), @FormFieldRow(name="sourceDatasetIdentifierRow", children={"sourceDatasetIdentifierType", "sourceDatasetIdentifier"}), @FormFieldRow(name="addNewDatasetToGroupRow", children={"addNewDatasetToGroup", "addToGroupIdentifierType", "addToGroupIdentifier"})})
@FormFieldGroup(name="cloneSettingsGroup", children={"sourceDatasetIdentifierRow", "copyGroups", "addNewDatasetToGroupRow"}, visibleOn={@OnField(name="cloneDatasetIfNotExists")})
@OperationMetadata(alias=OperationAlias.USE_BRAINSPACE_DATASET, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"BRAINSPACE"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@OperationParameters(value={@OperationParameter(label="brainspaceDatasetId", parameter="{brainspace_dataset_id}"), @OperationParameter(label="brainspaceDatasetName", parameter="{brainspace_dataset_name}"), @OperationParameter(label="brainspaceVersion", parameter="{brainspace_version}")})
@OperationLicenseModule(module=ModuleType.BRAINSPACE_REVIEW)
public class BrainspaceUseDatasetOperation
extends Operation {
    @FormField(helpers={@FormFieldHelper(location="#_set_brainspace_dataset")})
    public String apiUrl;
    @FormField(required=false)
    @ExcludeFromPrintableOptions
    public String certificateFingerprint;
    @FormField
    @ExcludeFromPrintableOptions
    @SensitiveField
    public String apiKey;
    @FormField
    @ExcludeFromPrintableOptions
    public BrainspaceIdentifierType datasetIdentifierType;
    @FormField
    public String datasetIdentifier;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    public boolean cloneDatasetIfNotExists;
    @FormField
    @ExcludeFromPrintableOptions
    public BrainspaceIdentifierType sourceDatasetIdentifierType;
    @FormField
    @ExcludeFromPrintableOptions
    public String sourceDatasetIdentifier;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean copyGroups;
    @FormField
    public boolean addNewDatasetToGroup;
    @FormField(enableOn={@OnField(name="addNewDatasetToGroup")})
    @ExcludeFromPrintableOptions
    public BrainspaceIdentifierType addToGroupIdentifierType;
    @FormField(enableOn={@OnField(name="addNewDatasetToGroup")})
    @ExcludeFromPrintableOptions
    public String addToGroupIdentifier;

    public boolean getDisplaySourceDatasetIdentifierType() {
        return this.cloneDatasetIfNotExists;
    }

    public boolean getDisplaySourceDatasetIdentifier() {
        return this.cloneDatasetIfNotExists;
    }

    public boolean getDisplayCopyGroups() {
        return this.cloneDatasetIfNotExists;
    }

    public boolean getDisplayAddNewDatasetToGroup() {
        return this.cloneDatasetIfNotExists;
    }

    public boolean getDisplayAddToGroupIdentifierType() {
        return this.cloneDatasetIfNotExists && this.addNewDatasetToGroup;
    }

    public boolean getDisplayAddToGroupIdentifier() {
        return this.cloneDatasetIfNotExists && this.addNewDatasetToGroup;
    }

    public BrainspaceUseDatasetOperation() {
        this.requiresCase = false;
        this.apiUrl = "https://app.brainspace.local";
        this.apiKey = "{brainspace_api_token_protected}";
        this.certificateFingerprint = "";
        this.datasetIdentifier = "Sample Dataset Name";
        this.datasetIdentifierType = BrainspaceIdentifierType.NAME;
        this.cloneDatasetIfNotExists = false;
        this.sourceDatasetIdentifierType = BrainspaceIdentifierType.ID;
        this.sourceDatasetIdentifier = "1";
        this.copyGroups = true;
        this.addNewDatasetToGroup = false;
        this.addToGroupIdentifierType = BrainspaceIdentifierType.NAME;
        this.addToGroupIdentifier = "";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("UseBrainspaceDataset.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.USE_BRAINSPACE_DATASET;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.datasetIdentifier == null || this.datasetIdentifier.trim().length() == 0) {
            prerequisites.add(this.iu.getString("UseBrainspaceDataset.Prerequisites.DatasetIdentifierRequired"));
        }
        if (this.cloneDatasetIfNotExists && (this.sourceDatasetIdentifier == null || this.sourceDatasetIdentifier.trim().length() == 0)) {
            prerequisites.add(this.iu.getString("UseBrainspaceDataset.Prerequisites.SourceDatasetIdentifierRequired"));
        }
        if (this.cloneDatasetIfNotExists && this.addNewDatasetToGroup && (this.addToGroupIdentifier == null || this.addToGroupIdentifier.trim().length() == 0)) {
            prerequisites.add(this.iu.getString("UseBrainspaceDataset.Prerequisites.AddToGroupIdentifierRequired"));
        }
        if (this.cloneDatasetIfNotExists && (activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED)) {
            try {
                this.assertModuleLicensed(ModuleType.BRAINSPACE_ADVANCED);
            }
            catch (LicenceValidationException e) {
                prerequisites.add(e.getMessage());
            }
        }
        return prerequisites;
    }
}

