/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.BrainspaceUseDatasetOperation;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceDatasetDoesNotExistException;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceGroupDoesNotExistException;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceObject;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceRestClient;
import java.io.IOException;

public class BrainspaceUseDatasetOperationImplementation
extends BrainspaceUseDatasetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BrainspaceUseDatasetOperation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = "";
                this.apiUrl = this.executionContext.evalParameters(this.apiUrl, this);
                if (this.apiUrl.endsWith("/")) {
                    this.apiUrl = this.apiUrl.substring(0, this.apiUrl.length() - 1);
                }
                this.apiKey = this.executionContext.evalProtectedParameter(this.apiKey);
                if (this.apiKey.length() == 0) {
                    throw new ParameterException(this.iu.getString("UseBrainspaceDataset.Error.BrainspaceApiKeyIsInvalid"));
                }
                this.certificateFingerprint = this.executionContext.evalParameters(this.certificateFingerprint, this);
                this.datasetIdentifier = this.executionContext.evalParameters(this.datasetIdentifier, this);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_brainspace_api_url}", this.apiUrl)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_brainspace_api_key_protected}", this.apiKey)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_brainspace_api_certificate_fingerprint}", this.certificateFingerprint)));
                BrainspaceRestClient brainspaceRestClient = new BrainspaceRestClient(this.apiUrl, this.apiKey, this.certificateFingerprint);
                try {
                    String brainspaceVersion = brainspaceRestClient.getVersion();
                    this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.BrainspaceVersion", (Object)brainspaceVersion));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{brainspace_version}", brainspaceVersion)));
                }
                catch (IOException e) {
                    if (e.getMessage().contains("SSLHandshakeException") && (this.certificateFingerprint == null || this.certificateFingerprint.trim().length() == 0)) {
                        try {
                            BrainspaceRestClient dummyBrainspaceRestClient = new BrainspaceRestClient(this.apiUrl, this.apiKey, "dummy-fingerprint");
                            dummyBrainspaceRestClient.getVersion();
                        }
                        catch (IOException e2) {
                            throw new IOException(this.iu.getFormattedString("RestClientFactory.CanotConnectToApi", (Object)e2.getMessage()));
                        }
                    }
                    throw new IOException(this.iu.getFormattedString("RestClientFactory.CanotConnectToApi", (Object)e.getMessage()));
                }
                this.percentageComplete = 0.3;
                this.stageName = this.iu.getString("UseBrainspaceDataset.Stage.GettingDataset");
                BrainspaceObject brainspaceDataset = null;
                try {
                    brainspaceDataset = brainspaceRestClient.getDataset(this.datasetIdentifierType, this.datasetIdentifier);
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{brainspace_dataset_id}", String.valueOf(brainspaceDataset.getId()))));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{brainspace_dataset_name}", brainspaceDataset.getName())));
                    this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.DatasetId", (Object)brainspaceDataset.getId()));
                    this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.DatasetName", (Object)brainspaceDataset.getName()));
                }
                catch (BrainspaceDatasetDoesNotExistException e) {
                    if (this.cloneDatasetIfNotExists) {
                        BrainspaceObject sourceDataset;
                        this.addExecutionLog(this.iu.getString("UseBrainspaceDataset.Log.CouldNotFindDatasetCloning"));
                        try {
                            sourceDataset = brainspaceRestClient.getDataset(this.sourceDatasetIdentifierType, this.sourceDatasetIdentifier);
                            this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.SourceDatasetId", (Object)sourceDataset.getId()));
                            this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.SourceDatasetName", (Object)sourceDataset.getName()));
                        }
                        catch (BrainspaceDatasetDoesNotExistException ex) {
                            throw new IOException(this.iu.getFormattedString("UseBrainspaceDataset.Error.CannotFindDataset", new Object[]{LocalizableEnumUtils.getLocalizedString((Enum)this.sourceDatasetIdentifierType), this.sourceDatasetIdentifier}));
                        }
                        if (this.copyGroups) {
                            this.addExecutionLog(this.iu.getString("UseBrainspaceDataset.Log.CopyGroups"));
                        }
                        BrainspaceObject group = null;
                        if (this.addNewDatasetToGroup) {
                            try {
                                group = brainspaceRestClient.getGroup(this.addToGroupIdentifierType, this.addToGroupIdentifier);
                                this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.AddingToGroup", (Object)group.getName()));
                            }
                            catch (BrainspaceGroupDoesNotExistException ex) {
                                throw new IOException(this.iu.getFormattedString("UseBrainspaceDataset.Error.CannotFindGroup", new Object[]{LocalizableEnumUtils.getLocalizedString((Enum)this.addToGroupIdentifierType), this.addToGroupIdentifier}));
                            }
                        }
                        brainspaceDataset = brainspaceRestClient.cloneDataset(this.datasetIdentifier, sourceDataset, this.copyGroups, group);
                        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{brainspace_dataset_id}", String.valueOf(brainspaceDataset.getId()))));
                        this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{brainspace_dataset_name}", brainspaceDataset.getName())));
                        this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.DatasetId", (Object)brainspaceDataset.getId()));
                        this.addExecutionLog(this.iu.getFormattedString("UseBrainspaceDataset.Log.DatasetName", (Object)brainspaceDataset.getName()));
                    }
                    throw new IOException(this.iu.getFormattedString("UseBrainspaceDataset.Error.CannotFindDataset", new Object[]{LocalizableEnumUtils.getLocalizedString((Enum)this.datasetIdentifierType), this.datasetIdentifier}));
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

