/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.gson.Gson;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.MimeTypeUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.CallApiOperation;
import com.nuix.automate.workflow.core.execution.workflow.ExecutionStateDynamicParameter;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CallApiOperationImplementation
extends CallApiOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CallApiOperationImplementation.class);
    private transient Client client;
    private transient Gson gson;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.url = this.executionContext.evalParameters(this.url, this).trim();
                this.certificateFingerprint = this.executionContext.evalParameters(this.certificateFingerprint, this).trim();
                this.authKey = this.executionContext.evalParameters(this.authKey, this);
                this.authSecret = this.executionContext.evalProtectedParameter(this.authSecret);
                this.basicAuthUsername = this.executionContext.evalParameters(this.basicAuthUsername, this);
                this.basicAuthPassword = this.executionContext.evalProtectedParameter(this.basicAuthPassword);
                this.bearerToken = this.executionContext.evalProtectedParameter(this.bearerToken);
                this.apiKeyName = this.executionContext.evalParameters(this.apiKeyName, this);
                this.apiKeyValue = this.executionContext.evalProtectedParameter(this.apiKeyValue);
                this.bodyRaw = this.executionContext.evalParameters(this.bodyRaw, this);
                this.bodyFilelocation = this.executionContext.evalParameters(this.bodyFilelocation, this);
                HashSet<String> fingerprints = new HashSet<String>();
                if (this.certificateFingerprint != null && this.certificateFingerprint.length() > 0) {
                    fingerprints.add(this.certificateFingerprint.trim());
                }
                this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)"call-api", fingerprints, (boolean)true);
                this.gson = new Gson();
                this.addExecutionLog(this.iu.getFormattedString("CallApi.Log.CallingApi", new Object[]{this.verb, this.url}));
                try {
                    this.callApi();
                }
                catch (SSLHandshakeException e) {
                    if (fingerprints.size() == 0) {
                        fingerprints.add("dummy-invalid-fingerprint");
                        this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)"call-api", fingerprints, (boolean)true);
                        try {
                            this.callApi();
                        }
                        catch (SSLHandshakeException ex) {
                            throw new IOException(ex.getMessage());
                        }
                    }
                    throw new IOException(e.getMessage());
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void callApi() throws IOException {
        LOGGER.info(String.valueOf((Object)this.verb) + " " + this.url);
        try (Response response = null;){
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{call_api_response_code}", String.valueOf(0))));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{call_api_response_headers}", "")));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{call_api_response_body}", "")));
            UriBuilder uriBuilder = UriBuilder.fromUri((String)this.url);
            for (Object[] userParameters : this.parameters) {
                if (userParameters[0].toString().trim().length() <= 0) continue;
                uriBuilder = uriBuilder.queryParam(this.executionContext.evalParameters(userParameters[0].toString(), this), new Object[]{this.executionContext.evalParameters(userParameters[1].toString(), this)});
            }
            WebTarget webTarget = this.client.target(uriBuilder);
            Entity entity = null;
            String mediaType = null;
            switch (this.bodyType) {
                case NONE: {
                    break;
                }
                case FORM_DATA: {
                    mediaType = "multipart/form-data";
                    Form form = new Form();
                    for (Object bodyFormField : this.bodyFormData) {
                        if (bodyFormField[0].toString().trim().length() <= 0) continue;
                        form = form.param(this.executionContext.evalParameters(bodyFormField[0].toString(), this), this.executionContext.evalParameters(bodyFormField[1].toString(), this));
                    }
                    entity = Entity.form((Form)form);
                    break;
                }
                case RAW: {
                    switch (this.bodyFormat) {
                        case TEXT: {
                            mediaType = "text/plain";
                            entity = Entity.text((Object)this.bodyRaw);
                            break;
                        }
                        case JSON: {
                            mediaType = "application/json";
                            entity = Entity.entity((Object)this.bodyRaw, (String)"application/json");
                            break;
                        }
                        case HTML: {
                            mediaType = "text/html";
                            entity = Entity.entity((Object)this.bodyRaw, (String)"text/html");
                            break;
                        }
                        case XML: {
                            mediaType = "application/xml";
                            entity = Entity.entity((Object)this.bodyRaw, (String)"application/xml");
                            break;
                        }
                    }
                    break;
                }
                case BINARY: {
                    String extension = com.nuix.automate.utils.general.FileUtils.getFileExtension((String)this.bodyFilelocation);
                    mediaType = MimeTypeUtils.getInstance().getMimeType(extension);
                    entity = Entity.entity((Object)com.nuix.automate.utils.general.FileUtils.readFileWithAutodetectEncoding((File)new File(this.bodyFilelocation)), (String)mediaType);
                    break;
                }
            }
            Invocation.Builder invocationBuilder = mediaType != null ? webTarget.request(new String[]{mediaType}) : webTarget.request();
            LinkedHashMap<String, Object> headerValues = new LinkedHashMap<String, Object>();
            switch (this.authType) {
                case NO_AUTH: {
                    break;
                }
                case API_KEY: {
                    headerValues.put(this.apiKeyName, this.apiKeyValue);
                    break;
                }
                case BEARER_TOKEN: {
                    headerValues.put("Authorization", "Bearer " + this.bearerToken);
                    break;
                }
                case BASIC_AUTH: {
                    headerValues.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.basicAuthUsername + ":" + this.basicAuthPassword).getBytes(StandardCharsets.UTF_8)));
                    break;
                }
            }
            for (Object[] userHeader : this.headers) {
                if (userHeader[0].toString().trim().length() <= 0) continue;
                headerValues.put(this.executionContext.evalParameters(userHeader[0].toString(), this), this.executionContext.evalParameters(userHeader[1].toString(), this));
            }
            for (String headerName : headerValues.keySet()) {
                invocationBuilder = invocationBuilder.header(headerName, headerValues.get(headerName));
            }
            String logFileName = System.getProperty("automate.callapi.log");
            File logFile = null;
            if (logFileName != null) {
                logFile = new File(logFileName);
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(String.valueOf((Object)this.verb) + " " + this.url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    if (entity != null) {
                        try {
                            FileUtils.writeStringToFile((File)logFile, (String)entity.getEntity().toString(), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot write Call API log entity", (Throwable)e);
                        }
                    }
                    FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Call API log", (Throwable)e);
                }
            }
            switch (this.verb) {
                case GET: {
                    response = invocationBuilder.get();
                    break;
                }
                case POST: {
                    response = invocationBuilder.post(entity);
                    break;
                }
                case PUT: {
                    response = invocationBuilder.put(entity);
                    break;
                }
                case DELETE: {
                    response = invocationBuilder.delete();
                    break;
                }
                case HEAD: {
                    response = invocationBuilder.head();
                    break;
                }
                case OPTIONS: {
                    response = invocationBuilder.options();
                    break;
                }
            }
            this.addExecutionLog(this.iu.getFormattedString("CallApi.Log.ApiResponseStatus", (Object)(response.getStatus() + " " + response.getStatusInfo().getReasonPhrase())));
            response.bufferEntity();
            final String stringResponse = (String)response.readEntity(String.class);
            LOGGER.info(this.url + " responded with HTTP/" + response.getStatus() + " " + stringResponse.length());
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(stringResponse + "\n\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Call API log", (Throwable)e);
                }
            }
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Map.Entry header : response.getHeaders().entrySet()) {
                List headerMultivalues = (List)header.getValue();
                StringBuilder headerFlattenValues = new StringBuilder();
                for (Object headerMultivalue : headerMultivalues) {
                    if (headerFlattenValues.length() > 0) {
                        headerFlattenValues.append("\n");
                    }
                    headerFlattenValues.append(headerMultivalue);
                }
                responseHeaders.put((String)header.getKey(), headerFlattenValues.toString());
                if (!((String)header.getKey()).equalsIgnoreCase("content-type")) continue;
                this.addExecutionLog(this.iu.getFormattedString("CallApi.Log.ApiResponseEncoding", (Object)headerFlattenValues.toString()));
            }
            this.addExecutionLog(this.iu.getFormattedString("CallApi.Log.ApiResponseSize", (Object)String.valueOf(stringResponse.length())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{call_api_response_code}", String.valueOf(response.getStatus()))));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{call_api_response_headers}", this.gson.toJson(responseHeaders))));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter(new ExecutionStateDynamicParameter("{call_api_response_body}", "The API response body"){

                @Override
                public String getProtectedValue() {
                    return stringResponse;
                }
            }));
            switch (response.getStatus() / 100) {
                case 1: 
                case 2: 
                case 3: {
                    LOGGER.info("API Response OK");
                    return;
                }
                case 4: 
                case 5: {
                    throw new IOException("API responded with HTTP/" + response.getStatus() + " " + response.getStatusInfo().getReasonPhrase());
                }
            }
            return;
        }
    }
}

