/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.RELATIVITY_CALL_GENERIC_API, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"EXTERNAL_COMMAND"})})
@OperationParameters(value={@OperationParameter(label="queryRetrieveResponseCode", parameter="{relativity_call_api_response_code}"), @OperationParameter(label="queryRetrieveResponseHeaders", parameter="{relativity_call_api_response_headers}"), @OperationParameter(label="queryRetrieveResponseBody", parameter="{relativity_call_api_response_body}")})
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class CallGenericRelativityApiOperation
extends RelativityOperation {
    @FormField
    public Verb verb;
    @FormField
    public String endpoint;
    @FormField(componentType=FieldComponentType.SCRIPT_PANE, scriptLanguage="json", visibleOn={@OnField(name="verb", value={"POST", "PUT"})})
    @ExcludeFromPrintableOptions
    public String bodyRaw;

    public boolean getDisplayBodyRaw() {
        return this.verb.equals((Object)Verb.POST) || this.verb.equals((Object)Verb.PUT);
    }

    public CallGenericRelativityApiOperation() {
        this.requiresCase = false;
        this.verb = Verb.POST;
        this.endpoint = "/Relativity.Rest/api/Relativity.ObjectManager/v1/workspace/-1/object/query";
        this.bodyRaw = "{\n   \"Request\":{\n      \"ObjectType\":{\n         \"ArtifactTypeID\":8\n      },\n      \"fields\":[\n         {\n            \"Name\":\"Name\"\n         },\n         {\n            \"Name\":\"Status\"\n         }\n      ],\n      \"condition\":\"\",\n      \"sorts\":[]\n   },\n   \"start\":1,\n   \"length\":100\n}";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("CallGenericRelativityApiOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureRelativityConnectionOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (this.endpoint == null || this.endpoint.trim().length() == 0) {
            prerequisites.add(this.iu.getString("CallGenericRelativityApiOperation.Error.MissingUrl"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

