/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.CallGenericRelativityApiOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.GenericRelativityApiCallResponse;
import com.nuix.automate.workflow.core.execution.workflow.ExecutionStateDynamicParameter;
import jakarta.ws.rs.core.UriBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CallGenericRelativityApiOperationImplementation
extends CallGenericRelativityApiOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CallGenericRelativityApiOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.endpoint = this.executionContext.evalParameters(this.endpoint, this).trim();
                this.bodyRaw = this.executionContext.evalParameters(this.bodyRaw, this);
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_call_api_response_code}", String.valueOf(0))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_call_api_response_headers}", "")));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_call_api_response_body}", "")));
                UriBuilder uriBuilder = UriBuilder.fromUri((String)this.endpoint);
                this.addExecutionLog(this.iu.getFormattedString("CallGenericRelativityApiOperation.Log.ApiEndpoint", (Object)uriBuilder.toString()));
                GenericRelativityApiCallResponse response = this.relativityRestClient.callGenericApiEncoded(uriBuilder.toString(), this.verb, this.bodyRaw);
                this.addExecutionLog(this.iu.getFormattedString("CallGenericRelativityApiOperation.Log.ApiResponseStatus", (Object)response.getCode()));
                HashMap<String, String> responseHeaders = new HashMap<String, String>();
                for (Map.Entry header : response.getHeaders().entrySet()) {
                    List headerMultivalues = (List)header.getValue();
                    StringBuilder headerFlattenValues = new StringBuilder();
                    for (Object headerMultivalue : headerMultivalues) {
                        if (headerFlattenValues.length() > 0) {
                            headerFlattenValues.append("\n");
                        }
                        headerFlattenValues.append(headerMultivalue);
                    }
                    responseHeaders.put((String)header.getKey(), headerFlattenValues.toString());
                    if (!((String)header.getKey()).equalsIgnoreCase("content-type")) continue;
                    this.addExecutionLog(this.iu.getFormattedString("CallGenericRelativityApiOperation.Log.ApiResponseEncoding", (Object)headerFlattenValues.toString()));
                }
                if (response.getData() != null) {
                    this.addExecutionLog(this.iu.getFormattedString("CallGenericRelativityApiOperation.Log.ApiResponseSize", (Object)String.valueOf(response.getData().length())));
                } else {
                    this.addExecutionLog(this.iu.getFormattedString("CallGenericRelativityApiOperation.Log.ApiResponseSize", (Object)"0"));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_call_api_response_code}", String.valueOf(response.getCode()))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_call_api_response_headers}", SerializationUtils.toJson(responseHeaders))));
                final String responseData = response.getData();
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter(new ExecutionStateDynamicParameter("{relativity_call_api_response_body}", "The Relativity API response body"){

                    @Override
                    public String getProtectedValue() {
                        return responseData;
                    }
                }));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

