/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.casesubsetexport.AnalysisLanguage;
import java.util.List;

@FormFieldGroups(value={@FormFieldGroup(name="exportedCaseSettingsGroup", children={"name", "exportFolder", "investigator", "description", "evidenceStoreCount"}), @FormFieldGroup(name="exportedItemSettingsGroup", children={"includeFamilies", "exportBinary", "maximumBinarySize"}), @FormFieldGroup(name="textProcessingSettingsGroup", children={"analysisLanguage", "stopWords", "stemming", "enableExactQueries"}), @FormFieldGroup(name="annotationSettingsGroup", children={"annotationSettingsRow"})})
@FormFieldRow(name="annotationSettingsRow", numberOfColumns=2, children={"copyTags", "copyComments", "copyCustodians", "copyItemSets", "copyClassifiers", "copyProductionSets", "copyGraphDatabase", "copyClusters", "copyCustomMetadata", "copyMarkupSets"})
@OperationMetadata(alias=OperationAlias.CASE_SUBSET_EXPORT, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"EXPORT", "MANAGEMENT"})})
@OperationParameter(label="queryRetrieveExportFolder", parameter="{last_export_folder}")
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class CaseSubsetExportOperation
extends Operation {
    @FormField(required=false)
    public String scope = "flag:audited";
    @FormField
    public String name = "{case_name} Subset";
    @FormField
    public String exportFolder = "{case_folder}/Export/Case Subset";
    @FormField
    public String investigator;
    @FormField(required=false)
    public String description = "";
    @FormField(min=1.0, positionLabel=@PositionLabel(bottom="evidenceStoreCountMessage"))
    public int evidenceStoreCount = 1;
    @FormField
    public Boolean includeFamilies = false;
    @FormField
    public Boolean exportBinary = false;
    @FormField(divisor=1000000, enableOn={@OnField(name="exportBinary")}, positionLabel=@PositionLabel(right="MB"))
    public long maximumBinarySize = 250000000L;
    @FormField
    public AnalysisLanguage analysisLanguage = AnalysisLanguage.EN;
    @FormField
    public Boolean stopWords = false;
    @FormField
    public Boolean stemming = false;
    @FormField
    public Boolean enableExactQueries = true;
    @FormField
    public Boolean copyTags = true;
    @FormField
    public Boolean copyComments = true;
    @FormField
    public Boolean copyCustodians = true;
    @FormField
    public Boolean copyItemSets = true;
    @FormField
    public Boolean copyClassifiers = true;
    @FormField
    public Boolean copyProductionSets = true;
    @FormField
    public Boolean copyGraphDatabase = true;
    @FormField
    public Boolean copyClusters = true;
    @FormField
    public Boolean copyCustomMetadata = true;
    @FormField
    public Boolean copyMarkupSets = true;

    public boolean getDisplayMaximumBinarySize() {
        return this.exportBinary;
    }

    public CaseSubsetExportOperation() {
        this.investigator = System.getProperty("user.name");
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("CaseSubsetExportOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.CASE_SUBSET_EXPORT;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        Version requiredNuixVersion;
        List<String> prerequisites = super.getPrerequisites(activity);
        if ((activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED) && this.exportBinary.booleanValue() && this.executionContext.nuixVersion.compareTo(requiredNuixVersion = new Version("7.6.0")) < 0) {
            prerequisites.add(this.iu.getFormattedString("CaseSubsetExportOperation.Prerequisites.RequiredVersion", new Object[]{requiredNuixVersion.toString(), this.executionContext.nuixVersion.toString()}));
        }
        return prerequisites;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.OTHER_EXPORT;
    }
}

