/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.CaseSubsetExportOperation;
import com.nuix.automate.workflow.core.utils.nuix.DerbyControlUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import nuix.ItemEventInfo;
import nuix.MultipleItemExporter;

public class CaseSubsetExportOperationImplementation
extends CaseSubsetExportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CaseSubsetExportOperation.class);
    transient Map<String, Integer> stageNameToId;
    private transient String stageName;
    private transient long stageCount;
    private transient long stageTotal;
    private transient AtomicLong failedCount;
    private transient long itemsInOriginalScope;
    private transient DerbyControlUtils derbyControlUtils;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.exportFolder = this.executionContext.evalParameters(this.exportFolder, this);
        this.name = this.executionContext.evalParameters(this.name, this);
        this.description = this.executionContext.evalParameters(this.description, this);
        this.investigator = this.executionContext.evalParameters(this.investigator, this);
        this.failedCount = new AtomicLong(0L);
        File exportFolderFile = new File(this.exportFolder);
        if (!exportFolderFile.exists()) {
            exportFolderFile.mkdirs();
        }
        this.exportFolder = exportFolderFile.getCanonicalPath();
        LOGGER.info("Canonical export folder: " + this.exportFolder);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.derbyControlUtils = new DerbyControlUtils(this.executionContext, this);
                this.derbyControlUtils.prepareExistingCase(this.exportFolder);
                MultipleItemExporter exporter = this.executionContext.nuixUtilities.getCaseSubsetExporter();
                this.addExecutionLog(this.iu.getFormattedString("CaseSubsetExportOperation.Log.ScopeQuery", (Object)this.scope));
                String scopeQuery = this.scope;
                LOGGER.info("Searching for " + scopeQuery);
                Set items = this.executionContext.nuixCase.searchUnsorted(scopeQuery);
                this.itemsInOriginalScope = items.size();
                this.addExecutionLog(this.iu.getNumeralString("CaseSubsetExportOperation.Log.ScopeCount", this.itemsInOriginalScope));
                if (items.size() > 0) {
                    Set effectiveItems;
                    exporter.whenItemEventOccurs(this::itemProcessed);
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("evidenceStoreCount", this.evidenceStoreCount);
                    options.put("includeFamilies", this.includeFamilies);
                    options.put("copyTags", this.copyTags);
                    options.put("copyComments", this.copyComments);
                    options.put("copyCustodians", this.copyCustodians);
                    options.put("copyItemSets", this.copyItemSets);
                    options.put("copyClassifiers", this.copyClassifiers);
                    options.put("copyMarkupSets", this.copyMarkupSets);
                    options.put("copyProductionSets", this.copyProductionSets);
                    options.put("copyClusters", this.copyClusters);
                    options.put("copyCustomMetadata", this.copyCustomMetadata);
                    options.put("copyGraphDatabase", this.copyGraphDatabase);
                    options.put("exportBinary", this.exportBinary);
                    HashMap<String, String> caseMetadata = new HashMap<String, String>();
                    caseMetadata.put("name", this.name);
                    caseMetadata.put("description", this.description);
                    caseMetadata.put("investigator", this.investigator);
                    options.put("caseMetadata", caseMetadata);
                    HashMap<String, Object> processingSettings = new HashMap<String, Object>();
                    processingSettings.put("analysisLanguage", this.analysisLanguage.toNuixString());
                    processingSettings.put("stopWords", this.stopWords);
                    processingSettings.put("stemming", this.stemming);
                    processingSettings.put("enableExactQueries", this.enableExactQueries);
                    options.put("processingSettings", processingSettings);
                    this.addExecutionLog(this.iu.getFormattedString("CaseSubsetExportOperation.Log.CaseName", (Object)this.name));
                    this.addExecutionLog(this.iu.getFormattedString("CaseSubsetExportOperation.Log.ExportFolder", (Object)this.exportFolder));
                    this.addExecutionLog(this.iu.getFormattedString("CaseSubsetExportOperation.Log.Investigator", (Object)this.investigator));
                    this.addExecutionLog(this.iu.getFormattedString("CaseSubsetExportOperation.Log.Description", (Object)this.description));
                    this.addExecutionLog(this.iu.getFormattedString("CaseSubsetExportOperation.Log.Indexes", (Object)this.evidenceStoreCount));
                    if (this.includeFamilies.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.IncludeFamilyMembers"));
                        LOGGER.info("Finding families of " + items.size() + " items");
                        effectiveItems = this.executionContext.nuixUtilities.getItemUtility().findFamilies((Collection)items);
                    } else {
                        effectiveItems = items;
                    }
                    this.stageTotal = effectiveItems.size();
                    if (this.exportBinary.booleanValue()) {
                        this.addExecutionLog(this.iu.getFormattedString("CaseSubsetExportOperation.Log.ExportBinaryMaxSize", (Object)FormattingUtils.sizeToDisplaySize((long)this.maximumBinarySize)));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("CaseSubsetExportOperation.Log.AnalysisLanguage", (Object)this.analysisLanguage));
                    if (this.stopWords.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.UseStopWords"));
                    }
                    if (this.stemming.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.UseStemming"));
                    }
                    if (this.enableExactQueries.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.EnableExactQueries"));
                    }
                    if (this.copyTags.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyTags"));
                    }
                    if (this.copyComments.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyComments"));
                    }
                    if (this.copyCustodians.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyCustodians"));
                    }
                    if (this.copyItemSets.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyItemSets"));
                    }
                    if (this.copyClassifiers.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyAutomaticClassifications"));
                    }
                    if (this.copyProductionSets.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyProductionSets"));
                    }
                    if (this.copyGraphDatabase.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyGraphDatabase"));
                    }
                    if (this.copyClusters.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyClusters"));
                    }
                    if (this.copyCustomMetadata.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyCustomMetadata"));
                    }
                    if (this.copyMarkupSets.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("CaseSubsetExportOperation.Log.CopyMarkupSets"));
                    }
                    LOGGER.info("Exporting case subset with " + effectiveItems.size() + " items");
                    exporter.exportItems((Collection)items, this.exportFolder, options);
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", this.exportFolder)));
                    if (this.failedCount.longValue() != 0L) {
                        this.addWarning(this.iu.getNumeralString("CaseSubsetExportOperation.Warning.EncounteredErrors", this.failedCount.longValue()));
                    }
                    this.addExecutionLog(this.iu.getNumeralString("CaseSubsetExportOperation.Log.EffectiveCount", this.stageCount));
                } else {
                    this.addWarning(this.iu.getString("CaseSubsetExportOperation.Warning.NoItemsMatchedSearchQuery"));
                    LOGGER.warn("No items matched search query");
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double stagePercentageComplete = 0.0;
        if (this.stageTotal > 0L) {
            stagePercentageComplete = (double)this.stageCount / (double)this.stageTotal;
        }
        double percentageComplete = stagePercentageComplete;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.stageCount == 0L) {
            String exportStage = this.iu.getString("CaseSubsetExportOperation.Progress.Initializing");
            result = (String)result + exportStage;
        } else {
            String exportStage = this.iu.getString("CaseSubsetExportOperation.Progress.Exporting");
            result = (String)result + exportStage;
            result = (String)result + this.iu.getNumeralString("CaseSubsetExportOperation.Progress.ItemsProcessed", this.stageCount);
        }
        return result;
    }

    public void itemProcessed(ItemEventInfo itemEventInfo) {
        if (itemEventInfo.getFailure() != null) {
            this.failedCount.incrementAndGet();
        }
        this.stageName = itemEventInfo.getStage();
        this.stageCount = itemEventInfo.getStageCount();
    }
}

