/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.CloseCaseOperation;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class CloseCaseOperationImplementation
extends CloseCaseOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CloseCaseOperation.class);
    private transient double progress;
    private transient String stageName;

    private void handleContainer(Container container) {
        this.handleComponent(container);
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                this.handleContainer((Container)component);
                continue;
            }
            this.handleComponent(component);
        }
    }

    private void handleComponent(Component component) {
        if (component instanceof JMenu && component.getName().equals("File")) {
            LOGGER.info("Detected File menu");
            JMenu fileMenu = (JMenu)component;
            for (int i = 0; i < fileMenu.getItemCount(); ++i) {
                LOGGER.info("Menu item name " + String.valueOf(fileMenu.getItem(i)));
                if (fileMenu.getItem(i) == null) continue;
                JMenuItem menuItem = fileMenu.getItem(i);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(" Menu item " + i + ":" + fileMenu.getItemCount() + " " + menuItem.getName());
                }
                if (menuItem.getName() == null || !menuItem.getName().equals("CloseCase")) continue;
                LOGGER.info("Detected File->Close Case menu item, triggering action");
                try {
                    ActionEvent actionEvent = new ActionEvent(menuItem, 1001, null);
                    menuItem.getAction().actionPerformed(actionEvent);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Cannot trigger Close case action", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                String caseFolder = null;
                this.progress = 0.1;
                this.stageName = this.iu.getString("CloseCaseOperation.Stage.ClosingNuixCase");
                this.addExecutionLog(this.iu.getString("CloseCaseOperation.Log.ClosingNuixCase"));
                if (this.executionContext.nuixCase != null) {
                    caseFolder = this.executionContext.nuixCase.getLocation().getAbsolutePath();
                    boolean closedCaseOpenedByWorkflowCase = this.executionContext.workflowExecution.closeCaseOpenedByWorkflow();
                    try {
                        if (!closedCaseOpenedByWorkflowCase) {
                            this.stageName = this.iu.getString("CloseCaseOperation.Stage.ClosingWorkstationCase");
                            this.addExecutionLog(this.iu.getString("CloseCaseOperation.Log.CaseWasNotOpenedByWorkflow"));
                            this.addWarning(this.iu.getString("CloseCaseOperation.Warning.CaseWasNotOpenedByWorkflowClosedWorkstationCaseInstead"));
                            Window[] windows = Window.getWindows();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Detected " + windows.length + " windows");
                            }
                            for (Window window : windows) {
                                try {
                                    this.handleContainer(window);
                                }
                                catch (RuntimeException runtimeException) {
                                    LOGGER.warn("Cannot handle window", (Throwable)runtimeException);
                                }
                            }
                            this.executionContext.workstationCase = null;
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Cannot close case", t);
                        this.addWarning(ExceptionUtils.getExceptionPrintableMessage((Throwable)t));
                    }
                } else {
                    this.addWarning(this.iu.getString("CloseCaseOperation.Warning.ThereIsNoOpenCaseToClose"));
                }
                this.addExecutionLog(this.iu.getString("CloseCaseOperation.Log.CaseClosed"));
                this.progress = 1.0;
                if (this.closeExecutionLog && caseFolder != null) {
                    this.addExecutionLog(this.iu.getString("CloseCaseOperation.Log.ClosingExecutionLog"));
                    this.executionContext.workflowExecution.removeLogFileInFolder(caseFolder);
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                LOGGER.info("Done processing error");
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        return this.progress;
    }
}

