/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CloseNuixOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CloseNuixOperation.class);
    public boolean closeNuixWorkstation;
    public boolean closeAutomateWorkflow;

    public CloseNuixOperation() {
        this.requiresCase = false;
        this.closeNuixWorkstation = true;
        this.closeAutomateWorkflow = false;
        this.modifiesNuixCase = false;
        this.disabled = true;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("CloseNuixOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.CLOSE_NUIX;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        int operationIndex = -1;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o != this) continue;
            operationIndex = i;
        }
        if (operationIndex != this.executionContext.workflowExecution.getWorkflow().getOperations().size() - 1) {
            LOGGER.warn("Workflow contains other operations after the Close Nuix operation");
            if (this.closeAutomateWorkflow) {
                prerequisites.add("When selecting to close Automate Workflow, the Close Nuix operation must be the last operations in the workflow.");
            }
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        features.add(Feature.NUIX_WORKSTATION);
        return features;
    }
}

