/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.responses.cases.Cases;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.EccService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureEccConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.util.Map;

public class ConfigureEccConnectionOperationImplementation
extends ConfigureEccConnectionOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureEccConnectionOperation.class);
    private transient Map<String, ThirdPartyService> thirdPartyServices;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), EccService.class.getSimpleName(), ParameterType.ECC_SERVICE);
                this.stageName = this.iu.getString("ConfigureEccConnectionOperation.Stage.InitializingRestClient");
                this.eccServiceId = this.executionContext.evalParameters(this.eccServiceId, this);
                EccService eccService = (EccService)this.thirdPartyServices.get(this.eccServiceId);
                if (eccService == null) {
                    throw new IllegalArgumentException(this.iu.getFormattedString("Ecc.Exception.InvalidService", (Object)this.eccServiceId));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_service_id}", this.eccServiceId)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_whitelisted_cert_fingerprints}", SerializationUtils.toJson((Object)eccService.getWhitelistedCertFingerprints()))));
                this.initializeEccClient();
                this.stageName = this.iu.getString("ConfigureEccConnectionOperation.Stage.TestingRestClient");
                this.percentageComplete = 0.3;
                Cases cases = this.eccRestClient.getCases();
                this.addExecutionLog(this.iu.getFormattedString("ConfigureEccConnectionOperation.Log.CaseCount", (Object)cases.getCases().size()));
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

