/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.DummyLogChannel;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.NlpService;
import com.nuix.automate.utils.models.api.thirdparty.NlpUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureNlpConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.utils.nlp.NlpRestClient;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;

public class ConfigureNlpConnectionOperationImplementation
extends ConfigureNlpConnectionOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureNlpConnectionOperation.class);
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient NlpService nlpService;
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), NlpService.class.getSimpleName(), ParameterType.NLP_SERVICE);
                this.stageName = this.iu.getString("ConfigureNlpConnectionOperation.Stage.InitializingRestClient");
                HashSet<String> whitelistedCertificateFingerprints = null;
                this.nlpServiceId = this.executionContext.evalParameters(this.nlpServiceId, this);
                if (this.thirdPartyServices == null || this.thirdPartyServices.get(this.nlpServiceId) == null) {
                    throw new IllegalStateException(this.iu.getFormattedString("ConfigureNlpConnectionOperation.Exception.MissingNlpService", (Object)this.nlpServiceId));
                }
                this.nlpService = (NlpService)this.thirdPartyServices.get(this.nlpServiceId);
                NlpUserCredential userCredential = (NlpUserCredential)this.nlpService.getUserCredential();
                if (userCredential.getToken() == null || userCredential.getToken().trim().isEmpty()) {
                    throw new IllegalStateException(this.iu.getFormattedString("ConfigureNlpConnectionOperation.Exception.MissingApiToken", (Object)this.nlpServiceId));
                }
                this.addExecutionLog(this.iu.getFormattedString("ConfigureNlpConnectionOperation.Log.NlpService", (Object)this.nlpService.getName()));
                String apiUrl = this.nlpService.getUrl();
                String feedsUrl = this.nlpService.getEffectiveFeedsApiUrl();
                String jobsUrl = this.nlpService.getEffectiveJobControlUrl();
                String apiToken = userCredential.getToken();
                whitelistedCertificateFingerprints = this.nlpService.getWhitelistedCertFingerprints();
                if (whitelistedCertificateFingerprints == null) {
                    whitelistedCertificateFingerprints = new HashSet<String>();
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_nlp_service_id}", this.nlpServiceId)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_nlp_url}", apiUrl)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_nlp_feeds_url}", feedsUrl)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_nlp_jobs_url}", jobsUrl)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_nlp_api_token_protected}", apiToken)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_nlp_whitelisted_cert_fingerprints}", SerializationUtils.toJson(whitelistedCertificateFingerprints))));
                NlpRestClient nlpRestClient = new NlpRestClient(UidUtils.getRandom(), apiUrl, feedsUrl, jobsUrl, apiToken, whitelistedCertificateFingerprints, (LogChannel)new DummyLogChannel());
                try {
                    nlpRestClient.retrieveAccessToken();
                    this.addExecutionLog(this.iu.getString("ConfigureNlpConnectionOperation.Log.NlpServiceConnected"));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot connect to NLP", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

