/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureNuixOperation;
import com.nuix.automate.workflow.core.execution.options.configuration.KeystoreFile;
import com.nuix.automate.workflow.core.execution.options.configuration.ParallelProcessingSettingsSource;
import com.nuix.automate.workflow.core.execution.options.configuration.PasswordSettingsType;
import com.nuix.automate.workflow.core.execution.workflow.Engine;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class ConfigureNuixOperationImplementation
extends ConfigureNuixOperation
implements Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureNuixOperation.class);

    @Override
    public void startTriggered() {
        int engineMaxWorkerCount;
        if (this.useConfigurationProfile) {
            try {
                this.profileFilePath = this.executionContext.evalParameters(this.profileFilePath, this);
            }
            catch (ParameterException e) {
                this.addWarning(e.getLocalizedMessage());
            }
            this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.NuixConfigurationProfile", (Object)this.profileFilePath));
        }
        if (this.useProcessingProfile) {
            String profileName = this.processingProfileName;
            try {
                profileName = this.executionContext.evalParameters(this.processingProfileName, this);
            }
            catch (ParameterException e) {
                this.addWarning(e.getLocalizedMessage());
            }
            this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.ProcessingProfile", (Object)profileName));
        } else {
            this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.ProcessingProfileNotUsed", new Object[0]));
        }
        try {
            this.passwordFilePath = this.executionContext.evalParameters(this.passwordFilePath, this);
        }
        catch (ParameterException e) {
            LOGGER.error("Could not evaluate passwords file path");
            this.addWarning(this.iu.getString("ConfigurationOperation.Warning.CouldNotEvaluatePasswordsFilePath"));
        }
        if (this.passwordSettingsType == PasswordSettingsType.PASSWORD_LIST) {
            this.addExecutionLog(this.iu.getNumeralString("ConfigurationOperation.Log.UsingPasswordListWith", (long)this.passwordList.size()));
        } else if (this.passwordSettingsType == PasswordSettingsType.PASSWORDS_FILE) {
            this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.UsingPasswordsFile", (Object)this.passwordFilePath));
        }
        try {
            this.keyStoreFilePath = this.executionContext.evalParameters(this.keyStoreFilePath, this);
        }
        catch (ParameterException e) {
            LOGGER.warn("Could not evaluate keystore tsv file path", (Throwable)e);
            this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.CannotEvaluateKeystore", new Object[]{e.getLocalizedMessage()}));
        }
        if (this.useConfigurationProfile) {
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_use_configuration_profile}", "true")));
            File preferencesFile = new File(this.profileFilePath);
            try {
                Path userDataDirProfilePath;
                String userDataDirPath;
                if (!preferencesFile.exists() && (userDataDirPath = this.executionContext.userDataDirPath) != null && Files.exists(userDataDirProfilePath = FileUtils.safeResolveParent((String)userDataDirPath, (String[])new String[]{"Profiles", this.profileFilePath + ".npf"}), new LinkOption[0]) && Files.isRegularFile(userDataDirProfilePath, new LinkOption[0])) {
                    preferencesFile = userDataDirProfilePath.toFile();
                }
                try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(preferencesFile.toPath(), new OpenOption[0]));){
                    try {
                        Preferences.userRoot().node("com/nuix/investigator/export").removeNode();
                        Preferences.userRoot().node("com/nuix/investigator/wizard").removeNode();
                    }
                    catch (BackingStoreException e) {
                        LOGGER.warn("Cannot remove user preferences");
                    }
                    Preferences.importPreferences(is);
                }
                LOGGER.info("Preferences file " + preferencesFile.getAbsolutePath() + " loaded successfully.");
            }
            catch (IOException | InvalidPreferencesFormatException e) {
                LOGGER.error("Preferences file " + preferencesFile.getAbsolutePath() + " could not be opened.", (Throwable)e);
                this.exception = new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.PreferencesFileCouldNotBeOpened", new Object[]{preferencesFile.getAbsoluteFile(), e.getLocalizedMessage()}));
                this.executionState = ExecutionState.ERROR;
                return;
            }
        }
        if (this.useProcessingProfile) {
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_processing_profile_name}", this.processingProfileName)));
        }
        if (this.passwordSettingsType == PasswordSettingsType.PASSWORDS_FILE) {
            try {
                this.passwordList = FileUtils.loadNoColumnTsv((File)new File(this.passwordFilePath));
            }
            catch (IOException e) {
                this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.CannotLoadPasswordFile", (Object)e.getLocalizedMessage()));
                LOGGER.warn("Cannot load password file", (Throwable)e);
            }
        }
        if (this.executionContext.keystoreList == null) {
            this.executionContext.keystoreList = new ArrayList<KeystoreFile>();
        }
        String keystoreTsvParameter = "{keystore_tsv}";
        try {
            String evaluatedKeystoreTsvParameter = this.executionContext.evalParameters(keystoreTsvParameter, this);
            if (!evaluatedKeystoreTsvParameter.equals(keystoreTsvParameter)) {
                File keystoreTsv = new File(evaluatedKeystoreTsvParameter);
                if (!keystoreTsv.exists()) {
                    this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.KeystoreTsvNotExists", new Object[]{evaluatedKeystoreTsvParameter}));
                } else {
                    this.keyStoreFilePath = evaluatedKeystoreTsvParameter;
                    this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.SettingKeystorePath", new Object[]{"{keystore_tsv}", evaluatedKeystoreTsvParameter}));
                }
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Could not evaluate parameter", (Throwable)e);
            this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.EvaluateParameter", new Object[]{keystoreTsvParameter, e.getLocalizedMessage()}));
        }
        if (!this.keyStoreFilePath.equals("")) {
            File keystoreFile = new File(this.keyStoreFilePath);
            if (keystoreFile.exists()) {
                try {
                    List storeList = FileUtils.loadVariableColumnDetectFormatFile((File)keystoreFile);
                    String[] header = (String[])storeList.get(0);
                    int pathPos = -1;
                    int passwordPos = -1;
                    int aliasPos = -1;
                    int aliasPasswordPos = -1;
                    int targetPos = -1;
                    block45: for (int index = 0; index < header.length; ++index) {
                        switch (header[index].toLowerCase()) {
                            case "path": {
                                if (pathPos != -1) {
                                    throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.DuplicateColumn", new Object[]{"Path"}));
                                }
                                pathPos = index;
                                LOGGER.info("Detected Path column at: " + (index + 1));
                                continue block45;
                            }
                            case "password": {
                                if (passwordPos != -1) {
                                    throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.DuplicateColumn", new Object[]{"Password"}));
                                }
                                passwordPos = index;
                                LOGGER.info("Detected Password column at: " + (index + 1));
                                continue block45;
                            }
                            case "alias": {
                                if (aliasPos != -1) {
                                    throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.DuplicateColumn", new Object[]{"Alias"}));
                                }
                                aliasPos = index;
                                LOGGER.info("Detected Alias column at: " + (index + 1));
                                continue block45;
                            }
                            case "aliaspassword": {
                                if (aliasPasswordPos != -1) {
                                    throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.DuplicateColumn", new Object[]{"AliasPassword"}));
                                }
                                aliasPasswordPos = index;
                                LOGGER.info("Detected Alias Password column at: " + (index + 1));
                                continue block45;
                            }
                            case "target": {
                                if (targetPos != -1) {
                                    throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.DuplicateColumn", new Object[]{"Target"}));
                                }
                                targetPos = index;
                                LOGGER.info("Detected Target column at: " + (index + 1));
                            }
                        }
                    }
                    if (pathPos == -1) {
                        throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.ColumnNotFound", new Object[]{"Path"}));
                    }
                    if (passwordPos == -1) {
                        throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.ColumnNotFound", new Object[]{"Password"}));
                    }
                    if (aliasPos == -1) {
                        throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.ColumnNotFound", new Object[]{"Alias"}));
                    }
                    if (aliasPasswordPos == -1) {
                        throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.ColumnNotFound", new Object[]{"AliasPassword"}));
                    }
                    if (targetPos == -1) {
                        throw new IOException(this.iu.getFormattedString("ConfigurationOperation.Exception.ColumnNotFound", new Object[]{"Target"}));
                    }
                    HashMap<String, Integer> keystoreFilePaths = new HashMap<String, Integer>();
                    for (int i = 1; i < storeList.size(); ++i) {
                        HashMap<String, Object> keyPasswords;
                        String[] values = (String[])storeList.get(i);
                        String path = values[pathPos];
                        if (path == null || path.equals("")) {
                            LOGGER.error("Keystore path at row: " + i + " is not defined.");
                            throw new IllegalArgumentException(this.iu.getString("ConfigurationOperation.Exception.KeystorePathNotDefined"));
                        }
                        String password = values[passwordPos];
                        String alias = values[aliasPos];
                        String aliasPassword = values[aliasPasswordPos];
                        String target = values[targetPos];
                        if (keystoreFilePaths.containsKey(values[pathPos])) {
                            LOGGER.info("Existing keystore: " + path + ", adding aliases");
                            this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.ExistingKeystore", new Object[]{alias, path}));
                            int existingKeystoreIndex = (Integer)keystoreFilePaths.get(path);
                            keyPasswords = new HashMap<String, Object>(((KeystoreFile)this.keystoreList.get(existingKeystoreIndex)).getKeyPasswords());
                            if (alias != null && !alias.equals("")) {
                                keyPasswords.put(alias, aliasPassword);
                            }
                            ((KeystoreFile)this.keystoreList.get(existingKeystoreIndex)).setKeyPasswords(keyPasswords);
                            continue;
                        }
                        LOGGER.info("Adding keystore from: " + path);
                        this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.AddingKeystore", new Object[]{path}));
                        keyPasswords = new HashMap<String, Object>();
                        if (alias != null && !alias.equals("")) {
                            keyPasswords.put(alias, aliasPassword);
                        }
                        this.keystoreList.add(new KeystoreFile(path, password, keyPasswords, target));
                        keystoreFilePaths.put(path, i);
                    }
                }
                catch (IOException e) {
                    this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.CannotLoadKeystore", new Object[]{e.getLocalizedMessage()}));
                    LOGGER.warn("Cannot load password file", (Throwable)e);
                }
            } else {
                this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.KeystoreTsvNotExists", new Object[]{this.keyStoreFilePath}));
                LOGGER.warn("Keystore file does not exist");
            }
        }
        try {
            String keystorePath = "{keystore_file_path}";
            String evaluatedKeystorePath = this.executionContext.evalParameters(keystorePath, this);
            if (!evaluatedKeystorePath.equals(keystorePath)) {
                this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.SettingKeystorePath", new Object[]{"{keystore_file_path}", evaluatedKeystorePath}));
                String evaluatedKeystorePassword = this.executionContext.evalParameters("{keystore_file_password}", this);
                String evaluatedKeystoreAlias = this.executionContext.evalParameters("{keystore_file_alias}", this);
                String evaluatedKeystoreAliasPassword = this.executionContext.evalParameters("{keystore_file_alias_password}", this);
                String evaluatedKeystoreTarget = this.executionContext.evalParameters("{keystore_file_target}", this);
                if (evaluatedKeystorePassword.equals("{keystore_file_password}")) {
                    evaluatedKeystorePassword = null;
                } else {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.SettingKeystorePassword", new Object[]{"{keystore_file_password}", Parameter.MASKED_VALUE}));
                }
                if (evaluatedKeystoreAlias.equals("{keystore_file_alias}")) {
                    evaluatedKeystoreAlias = null;
                } else {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.SettingKeystoreAlias", new Object[]{"{keystore_file_alias}", evaluatedKeystoreAlias}));
                }
                if (evaluatedKeystoreAliasPassword.equals("{keystore_file_alias_password}")) {
                    evaluatedKeystoreAliasPassword = null;
                } else {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.SettingKeystoreAliasPassword", new Object[]{"{keystore_file_alias_password}", Parameter.MASKED_VALUE}));
                }
                if (evaluatedKeystoreTarget.equals("{keystore_file_target}")) {
                    evaluatedKeystoreTarget = null;
                } else {
                    this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.SettingKeystoreTarget", new Object[]{"{keystore_file_target}", evaluatedKeystoreTarget}));
                }
                HashMap<String, Object> keyPasswords = new HashMap<String, Object>();
                if (evaluatedKeystoreAlias != null) {
                    keyPasswords.put(evaluatedKeystoreAlias, evaluatedKeystoreAliasPassword);
                }
                this.keystoreList.add(new KeystoreFile(evaluatedKeystorePath, evaluatedKeystorePassword, keyPasswords, evaluatedKeystoreTarget));
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Could not evaluate parameter", (Throwable)e);
            this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.EvaluateParameter", new Object[]{this.keyStoreFilePath, e.getLocalizedMessage()}));
        }
        if (this.keystoreList != null && this.keystoreList.size() > 0) {
            this.executionContext.keystoreList = new ArrayList<KeystoreFile>(this.keystoreList);
        }
        if (this.passwordSettingsType == PasswordSettingsType.PASSWORD_LIST || this.passwordSettingsType == PasswordSettingsType.PASSWORDS_FILE) {
            this.executionContext.passwords = new HashSet<String>();
            if (this.passwordList != null) {
                for (int i = 0; i < this.passwordList.size(); ++i) {
                    String evaluatedPassword;
                    String pass = (String)((Object[])this.passwordList.get(i))[0];
                    try {
                        evaluatedPassword = this.executionContext.evalParameters(pass, this);
                    }
                    catch (ParameterException e) {
                        LOGGER.error("Error evaluating password at index: " + i);
                        evaluatedPassword = pass;
                    }
                    this.executionContext.passwords.add(evaluatedPassword);
                }
            } else {
                LOGGER.warn("Password list is null");
            }
        }
        this.executionContext.workflowParallelSettings = this.parallelProcessingSettingsSource == ParallelProcessingSettingsSource.WORKFLOW;
        Engine engine = this.executionContext.getEngine();
        if (engine != null && (engineMaxWorkerCount = engine.getMaxWorkerCount()) < this.workflowLocalWorkersCount) {
            this.workflowLocalWorkersCount = engineMaxWorkerCount;
            this.addExecutionLog(this.iu.getFormattedString("ConfigureNuixOperationImplementation.Log.ReducedLocalWorkerCount", (Object)this.workflowLocalWorkersCount));
        }
        this.executionContext.workflowLocalWorkersCount = this.workflowLocalWorkersCount;
        this.executionContext.workflowLocalWorkersMemoryMb = this.workflowLocalWorkersMemoryMb;
        String workflowLocalWorkersTempFolder = this.executionContext.workflowLocalWorkersTempFolder;
        try {
            workflowLocalWorkersTempFolder = this.executionContext.evalParameters(workflowLocalWorkersTempFolder, this);
        }
        catch (ParameterException e) {
            this.addWarning(e.getLocalizedMessage());
        }
        if (!FileUtils.isPathAbsolute((String)workflowLocalWorkersTempFolder)) {
            String errorMsg = this.iu.getFormattedString("ConfigureNuixOperationImplementation.Exception.WorkflowLocalWorkersTempFolderRelative", (Object)workflowLocalWorkersTempFolder);
            LOGGER.error("Temp folder location can't be a relative path");
            this.exception = new Exception(errorMsg);
            this.executionState = ExecutionState.ERROR;
            return;
        }
        this.executionContext.workflowLocalWorkersTempFolder = workflowLocalWorkersTempFolder;
        this.executionContext.workflowBrokerWorkersCount = this.workflowBrokerWorkersCount;
        try {
            this.workflowBrokerIp = this.executionContext.evalParameters(this.workflowBrokerIp, this);
        }
        catch (ParameterException e) {
            this.addWarning(e.getLocalizedMessage());
        }
        this.executionContext.workflowBrokerIp = this.workflowBrokerIp;
        this.executionContext.workflowBrokerPort = this.workflowBrokerPort;
        if (this.executionContext.workflowParallelSettings) {
            this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.LocalWorkersCount", (Object)this.workflowLocalWorkersCount));
            if (this.workflowLocalWorkersCount > 0) {
                this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.LocalWorkersMemory", (Object)String.valueOf(this.workflowLocalWorkersMemoryMb)));
                this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.LocalWorkersTempFolder", (Object)workflowLocalWorkersTempFolder));
            }
            this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.RemoteWorkersCount", (Object)this.workflowBrokerWorkersCount));
            if (this.workflowBrokerWorkersCount > 0 && this.workflowBrokerIp != null && this.workflowBrokerIp.length() > 0) {
                this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.RemoteWorkersBroker", new Object[]{String.valueOf(this.workflowBrokerIp), String.valueOf(this.workflowBrokerPort)}));
            }
        }
        this.trackFinished();
    }
}

