/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.Parameters;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.workflow.UserCancelledException;
import com.nuix.automate.workflow.core.utils.general.DisplayConditionUtils;
import com.nuix.automate.workflow.core.utils.general.FileParameterUtils;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ConfigureParametersOperationImplementation
extends ConfigureParametersOperation
implements Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureParametersOperation.class);
    private transient Map<String, String> sensitiveStaticParameters = new HashMap<String, String>();
    private transient Map<String, String> sensitiveUserParameters = new HashMap<String, String>();
    private transient FileParameterUtils fileParameterUtils;
    private transient Map<String, FileLibraryFile> libraryFiles;
    private static final long regexTimeoutMs = 5000L;

    @Override
    public void startTriggered() {
        List<StaticParameter> parameters = this.getAllParameters();
        this.fileParameterUtils = new FileParameterUtils();
        Parameters sessionParameters = this.executionContext.getSessionConfigParameters();
        for (StaticParameter localParameter : parameters) {
            Parameter sessionParameter = sessionParameters.get(localParameter.getName());
            if (sessionParameter == null) continue;
            try {
                localParameter.setUserDisplayableValue(sessionParameter.getUserDisplayableValue());
                localParameter.setValue(sessionParameter.getProtectedValue());
            }
            catch (ParameterException e) {
                LOGGER.error("Cannot evaluate session parameter " + sessionParameter.getFriendlyNameAndName() + " value", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.CannotEvaluateJobParameter", new Object[]{sessionParameter.getFriendlyNameAndName(), e.getLocalizedMessage()}));
            }
        }
        Parameters executionCustomParameters = this.executionContext.getExecutionCustomParameters();
        if (this.userParameters.size() > 0) {
            try {
                this.executionContext.workflowExecution.fireOnConfigurationPrompt(this);
            }
            catch (UserCancelledException e) {
                this.executionState = ExecutionState.ERROR;
                this.exception = e;
                return;
            }
        }
        String shortId = null;
        Path additionalFilesTempDirectory = null;
        parameters = DisplayConditionUtils.getInstance().evaluateDisplayableParameters(parameters, this.executionContext, 5000L);
        try {
            shortId = this.executionContext.evalParameters("{job_id_short}", this);
            additionalFilesTempDirectory = Paths.get(System.getProperty("java.io.tmpdir"), "Automate", "job-" + shortId, "AdditionalFiles");
        }
        catch (ParameterException e) {
            LOGGER.error("Unable to parse short ID for job", (Throwable)e);
            shortId = UUID.randomUUID().toString().split("-")[0];
            additionalFilesTempDirectory = Paths.get(System.getProperty("java.io.tmpdir"), "Automate", "job-" + shortId, "AdditionalFiles");
        }
        for (StaticParameter parameter : parameters) {
            if (!parameter.getDisplayCondition().getDisplayable()) continue;
            if (this.isStaticParameter(parameter)) {
                String fileLibraryFileId;
                boolean isFileParameter = false;
                if (ParameterType.LIBRARY_FILE.equals((Object)parameter.getParameterType()) && this.libraryFiles != null && (fileLibraryFileId = parameter.getValue()) != null && this.libraryFiles.containsKey(fileLibraryFileId)) {
                    FileLibraryFile file = this.libraryFiles.get(parameter.getValue());
                    HashMap<String, FileLibraryFile> tempFiles = new HashMap<String, FileLibraryFile>();
                    tempFiles.put(parameter.getName(), file);
                    this.fileParameterUtils.createFiles(additionalFilesTempDirectory, tempFiles, this.executionContext.workflowExecution);
                    isFileParameter = true;
                }
                if (ParameterType.FILE_CONTENTS.equals((Object)parameter.getParameterType())) {
                    ArrayList<com.nuix.automate.utils.models.api.job.Parameter> tempParameters = new ArrayList<com.nuix.automate.utils.models.api.job.Parameter>();
                    com.nuix.automate.utils.models.api.job.Parameter tempParameter = new com.nuix.automate.utils.models.api.job.Parameter((Parameter)parameter);
                    tempParameters.add(tempParameter);
                    HashMap<String, FileLibraryFile> fileParameters = new HashMap<String, FileLibraryFile>();
                    this.fileParameterUtils.createFileContentParameters(this.executionContext.workflowExecution, tempParameters, additionalFilesTempDirectory, fileParameters);
                    isFileParameter = true;
                }
                if (isFileParameter) {
                    try {
                        String updatedValue = this.executionContext.evalParameters(parameter.getName(), this);
                        if (updatedValue != null && updatedValue.length() > 0) {
                            parameter.setValue(updatedValue);
                        }
                    }
                    catch (ParameterException updatedValue) {}
                } else {
                    executionCustomParameters.put((Parameter)parameter);
                }
                this.trackParameter((Parameter)parameter);
                continue;
            }
            this.trackParameter((Parameter)parameter);
            executionCustomParameters.put((Parameter)parameter);
        }
        for (StaticParameter parameter : parameters) {
            try {
                String value = this.executionContext.evalProtectedParameter(parameter.getName());
                try {
                    parameter.checkIfValueIsValid(value, 5000L);
                }
                catch (IllegalArgumentException e) {
                    this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.EvaluateParameter", new Object[]{parameter.getFriendlyNameAndName(), e.getLocalizedMessage()}));
                }
            }
            catch (ParameterException e) {
                LOGGER.error("Parameter " + parameter.getName() + " cannot be evaluated" + String.valueOf((Object)e));
                this.addWarning(this.iu.getFormattedString("ConfigurationOperation.Warning.CannotEvaluateParameter", new Object[]{parameter.getFriendlyNameAndName(), e.getLocalizedMessage()}));
            }
        }
        for (StaticParameter parameter : parameters) {
            if (!parameter.getDisplayCondition().getDisplayable()) continue;
            if (parameter.getUserDisplayableValue() != null) {
                this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.UserDisplayableParameter", new Object[]{parameter.getFriendlyNameAndName(), parameter.getUserDisplayableValue(), parameter.getMaskedValue()}));
                continue;
            }
            String maskedValue = parameter.getMaskedValue();
            this.addExecutionLog(this.iu.getFormattedString("ConfigurationOperation.Log.Parameter", new Object[]{parameter.getFriendlyNameAndName(), maskedValue}));
        }
        this.trackFinished();
    }

    public void protectSensitiveParameters() {
        for (StaticParameter localParameter : this.staticParameters) {
            if (!localParameter.isEffectiveTypeMaskedOrProtected()) continue;
            this.sensitiveStaticParameters.put(localParameter.getName(), localParameter.getProtectedValue());
            localParameter.setValue(null);
        }
        for (StaticParameter localParameter : this.userParameters) {
            if (!localParameter.isEffectiveTypeMaskedOrProtected()) continue;
            this.sensitiveUserParameters.put(localParameter.getName(), localParameter.getProtectedValue());
            localParameter.setValue(null);
        }
    }

    public void unProtectSensitiveParameters() {
        String value;
        for (StaticParameter localParameter : this.staticParameters) {
            if (!localParameter.isEffectiveTypeMaskedOrProtected() || (value = this.sensitiveStaticParameters.get(localParameter.getName())) == null) continue;
            localParameter.setValue(value);
        }
        for (StaticParameter localParameter : this.userParameters) {
            if (!localParameter.isEffectiveTypeMaskedOrProtected() || (value = this.sensitiveUserParameters.get(localParameter.getName())) == null) continue;
            localParameter.setValue(value);
        }
    }

    @Override
    public void setLibraryFiles(Map<String, FileLibraryFile> libraryFiles) {
        this.libraryFiles = libraryFiles;
    }
}

