/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.api.relativity.EndpointType;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldHelper;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.models.internal.formbuilder.SensitiveField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.CONFIGURE_RELATIVITY_CONNECTION, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@OperationLicenseModule(module=ModuleType.RELATIVITY_REVIEW)
public class ConfigureRelativityConnectionOperation
extends RelativityOperation {
    @FormField(helpers={@FormFieldHelper(location="#_configure_relativity_connection")})
    public boolean useRelativityService;
    @FormField(visibleOn={@OnField(name="useRelativityService")})
    public String relativityServiceId;
    @FormField(visibleOn={@OnField(name="useRelativityService", value={"false"})})
    public String hostname;
    @FormField(visibleOn={@OnField(name="useRelativityService", value={"false"})})
    public String serviceEndpoint;
    @FormField(allowedValues={"HTTP", "HTTPS"}, visibleOn={@OnField(name="useRelativityService", value={"false"})})
    @ExcludeFromPrintableOptions
    public EndpointType endpointType;
    @FormField(visibleOn={@OnField(name="useRelativityService", value={"false"})})
    public String username;
    @FormField(visibleOn={@OnField(name="useRelativityService", value={"false"})})
    @ExcludeFromPrintableOptions
    @SensitiveField
    public String password;
    public RelativityIdentifierType workspaceIdentifierType;
    public String workspaceIdentifier;
    public String workspaceName;
    @ExcludeFromPrintableOptions
    public String folderPath;
    @ExcludeFromPrintableOptions
    public Boolean createPathIfNotExists;
    @FormField(min=1.0, visibleOn={@OnField(name="useRelativityService", value={"false"})})
    public int importThreads;
    @FormField(min=1.0, visibleOn={@OnField(name="useRelativityService", value={"false"})}, positionLabel=@PositionLabel(right="seconds"))
    @ExcludeFromPrintableOptions
    public int importThreadTimeout;
    @FormField(visibleOn={@OnField(name="useRelativityService", value={"false"})})
    @ExcludeFromPrintableOptions
    public int importThreadRetries;
    @FormField(min=1.0, visibleOn={@OnField(name="useRelativityService", value={"false"})})
    public int metadataThreads;
    @FormField(visibleOn={@OnField(name="useRelativityService", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean patchInvalidEntries;
    @FormField(visibleOn={@OnField(name="useRelativityService", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean useCustomClientVersion;
    @FormField(visibleOn={@OnField(name="useRelativityService", value={"false"}), @OnField(name="useCustomClientVersion")})
    @ExcludeFromPrintableOptions
    public String customClientVersion;
    @FormField(visibleOn={@OnField(name="useRelativityService", value={"false"})})
    public RelativityRestVersion relativityRestVersion;
    @FormField(required=false, visibleOn={@OnField(name="useRelativityService", value={"false"})})
    @ExcludeFromPrintableOptions
    public Set<String> whitelistedCertFingerprints;

    public boolean getDisplayHostname() {
        return !this.useRelativityService;
    }

    public boolean getDisplayServiceEndpoint() {
        return !this.useRelativityService;
    }

    public boolean getDisplayEndpointType() {
        return !this.useRelativityService;
    }

    public boolean getDisplayUsername() {
        return !this.useRelativityService;
    }

    public boolean getDisplayPassword() {
        return !this.useRelativityService;
    }

    public boolean getDisplayWorkspaceIdentifier() {
        return RelativityIdentifierType.ARTIFACT_ID.equals((Object)this.workspaceIdentifierType);
    }

    public boolean getDisplayWorkspaceName() {
        return RelativityIdentifierType.NAME.equals((Object)this.workspaceIdentifierType);
    }

    public boolean getDisplayImportThreads() {
        return !this.useRelativityService;
    }

    public boolean getDisplayImportThreadTimeout() {
        return !this.useRelativityService;
    }

    public boolean getDisplayImportThreadRetries() {
        return !this.useRelativityService;
    }

    public boolean getDisplayMetadataThreads() {
        return !this.useRelativityService;
    }

    public boolean getDisplayPatchInvalidEntries() {
        return !this.useRelativityService;
    }

    public boolean getDisplayUseCustomClientVersion() {
        return !this.useRelativityService;
    }

    public boolean getDisplayCustomClientVersion() {
        return !this.useRelativityService && this.useCustomClientVersion;
    }

    public boolean getDisplayRelativityRestVersion() {
        return !this.useRelativityService;
    }

    public boolean getDisplayWhitelistedCertFingerprints() {
        return !this.useRelativityService;
    }

    public ConfigureRelativityConnectionOperation() {
        this.requiresCase = false;
        this.useRelativityService = false;
        this.relativityServiceId = "{relativity_service_id}";
        this.hostname = "{relativity_hostname}";
        this.username = "{relativity_username}";
        this.password = "{relativity_password}";
        this.serviceEndpoint = "/relativitywebapi";
        this.endpointType = EndpointType.HTTPS;
        this.importThreads = 1;
        this.metadataThreads = 8;
        this.useCustomClientVersion = false;
        this.customClientVersion = "";
        this.importThreadTimeout = 3600;
        this.importThreadRetries = 3;
        this.patchInvalidEntries = true;
        this.relativityRestVersion = RelativityRestVersion.REST_V1;
        this.whitelistedCertFingerprints = new HashSet<String>();
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("UseRelativityWorkspaceOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.CONFIGURE_RELATIVITY_CONNECTION;
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.serviceEndpoint == null) {
            this.serviceEndpoint = "";
        }
        if (this.customClientVersion == null) {
            this.customClientVersion = "";
        }
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

