/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.logging.DummyLogChannel;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.relativity.EndpointType;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.models.api.thirdparty.RelativityService;
import com.nuix.automate.utils.models.api.thirdparty.RelativityUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.nuix.GenericVersion;
import com.nuix.automate.workflow.core.utils.relativity.RelativityClient;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public class ConfigureRelativityConnectionOperationImplementation
extends ConfigureRelativityConnectionOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureRelativityConnectionOperation.class);
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient RelativityService relativityService;
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                HashSet<String> whitelistedCertFingerprints;
                String customClientVersion;
                boolean useCustomClientVersion;
                boolean patchInvalidEntries;
                int metadataThreads;
                int importThreadRetries;
                int importThreadTimeout;
                int importThreads;
                RelativityRestVersion relativityRestVersion;
                EndpointType endpointType;
                Object serviceEndpoint;
                String hostname;
                String password;
                String username;
                ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), RelativityService.class.getSimpleName(), ParameterType.RELATIVITY_SERVICE);
                this.stageName = "";
                ThirdPartyAuthenticationMethod authenticationMethod = ThirdPartyAuthenticationMethod.USERNAME_PASSWORD;
                if (this.useRelativityService) {
                    this.relativityServiceId = this.executionContext.evalParameters(this.relativityServiceId, this);
                    if (this.thirdPartyServices == null || this.thirdPartyServices.get(this.relativityServiceId) == null) {
                        throw new IllegalStateException(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Exception.MissingRelativityService", (Object)this.relativityServiceId));
                    }
                    this.relativityService = (RelativityService)this.thirdPartyServices.get(this.relativityServiceId);
                    RelativityUserCredential userCredential = (RelativityUserCredential)this.relativityService.getUserCredential();
                    if (userCredential == null) {
                        throw new IllegalStateException(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Exception.MissingRelativityServiceUserCredential", (Object)this.relativityServiceId));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.RelativityService", (Object)this.relativityService.getName()));
                    authenticationMethod = this.relativityService.getAuthenticationMethod();
                    username = userCredential.getUsername();
                    switch (this.relativityService.getAuthenticationMethod()) {
                        case OIDC_AUTHORIZATION_CODE: {
                            password = userCredential.getToken();
                            break;
                        }
                        default: {
                            password = userCredential.getPassword();
                        }
                    }
                    if (password == null) {
                        password = userCredential.getToken();
                    }
                    if (password == null) {
                        password = userCredential.getPassword();
                    }
                    hostname = this.relativityService.getHostname();
                    serviceEndpoint = this.relativityService.getServiceEndpoint();
                    endpointType = this.relativityService.getEndpointType();
                    relativityRestVersion = this.relativityService.getRelativityRestVersion();
                    importThreads = this.relativityService.getImportThreads();
                    importThreadTimeout = this.relativityService.getImportThreadTimeout();
                    importThreadRetries = this.relativityService.getImportThreadRetries();
                    metadataThreads = this.relativityService.getMetadataThreads();
                    patchInvalidEntries = this.relativityService.getPatchInvalidEntries();
                    useCustomClientVersion = this.relativityService.getUseCustomClientVersion();
                    customClientVersion = this.relativityService.getCustomClientVersion();
                    whitelistedCertFingerprints = this.relativityService.getWhitelistedCertFingerprints();
                } else {
                    username = this.executionContext.evalParameters(this.username, this);
                    password = this.executionContext.evalProtectedParameter(this.password);
                    hostname = this.executionContext.evalParameters(this.hostname, this);
                    serviceEndpoint = this.serviceEndpoint;
                    endpointType = this.endpointType;
                    relativityRestVersion = this.relativityRestVersion;
                    importThreads = this.importThreads;
                    importThreadTimeout = this.importThreadTimeout;
                    importThreadRetries = this.importThreadRetries;
                    metadataThreads = this.metadataThreads;
                    patchInvalidEntries = this.patchInvalidEntries;
                    useCustomClientVersion = this.useCustomClientVersion;
                    customClientVersion = this.customClientVersion;
                    whitelistedCertFingerprints = this.whitelistedCertFingerprints;
                }
                if (whitelistedCertFingerprints == null) {
                    whitelistedCertFingerprints = new HashSet();
                }
                serviceEndpoint = "/" + ((String)serviceEndpoint).replace("/", "").replace(" ", "");
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_service_endpoint}", (String)serviceEndpoint)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_hostname}", hostname)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_username}", username)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_password}", password)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_endpoint_type}", endpointType.toString())));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_import_threads}", String.valueOf(importThreads))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_metadata_threads}", String.valueOf(metadataThreads))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_whitelisted_cert_fingerprints}", SerializationUtils.toJson(whitelistedCertFingerprints))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_import_thread_timeout}", String.valueOf(importThreadTimeout))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_import_thread_retries}", String.valueOf(importThreadRetries))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_patch_invalid_entries}", String.valueOf(patchInvalidEntries))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_rest_version}", relativityRestVersion.name())));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_authentication_method}", authenticationMethod.name())));
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.Username", (Object)username));
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.RestVersion", (Object)relativityRestVersion));
                RelativityClient relativityRestClient = RelativityClient.getInstance(relativityRestVersion, endpointType, hostname, username, password, whitelistedCertFingerprints, (LogChannel)new DummyLogChannel(), authenticationMethod);
                this.stageName = this.iu.getFormattedString("UseRelativityWorkspaceOperation.Stage.InitializingRestClient", (Object)relativityRestVersion);
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.ServiceLocation", new Object[]{endpointType.toString().toLowerCase(), hostname, serviceEndpoint}));
                this.stageName = this.iu.getString("UseRelativityWorkspaceOperation.Stage.GettingVersion");
                try {
                    String instanceId = relativityRestClient.getInstanceId();
                    LOGGER.info("Relativity Instance ID: " + instanceId);
                    this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.InstanceInfo", (Object)instanceId));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_instance_id}", instanceId)));
                }
                catch (IOException e) {
                    if (e.getMessage().contains("SSLHandshakeException") && whitelistedCertFingerprints.isEmpty()) {
                        try {
                            RelativityClient dummyRelativityRestClient = RelativityClient.getInstance(relativityRestVersion, endpointType, hostname, username, password, new HashSet<String>(Collections.singletonList("dummy-fingerprint")), (LogChannel)new DummyLogChannel(), authenticationMethod);
                            dummyRelativityRestClient.getInstanceId();
                        }
                        catch (IOException e2) {
                            throw new IOException(this.iu.getFormattedString("RestClientFactory.CanotConnectToApi", (Object)e2.getMessage()));
                        }
                    }
                    throw new IOException(this.iu.getFormattedString("RestClientFactory.CanotConnectToApi", (Object)e.getMessage()));
                }
                LOGGER.info("Getting Relativity version");
                String version = relativityRestClient.getVersion();
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.ServiceVersion", (Object)version));
                ArrayList<GenericVersion> availableClientVersions = new ArrayList<GenericVersion>();
                File relativityClientsFolder = new File(SystemUtils.getProgramFilesDir() + "\\Nuix\\Automate\\bin\\RelativityClient\\Versions");
                File[] relativityClientVersions = relativityClientsFolder.listFiles();
                if (relativityClientVersions != null) {
                    for (File file : relativityClientVersions) {
                        if (!file.isDirectory()) continue;
                        LOGGER.info("Detected available client version " + file.getName());
                        availableClientVersions.add(new GenericVersion(file.getName()));
                    }
                }
                Collections.sort(availableClientVersions);
                String clientVersion = "Latest";
                for (GenericVersion availableClientVersion : availableClientVersions) {
                    if (availableClientVersion.getVersionText().equals("Latest")) continue;
                    clientVersion = availableClientVersion.getVersionText();
                }
                if (useCustomClientVersion) {
                    boolean match = false;
                    for (GenericVersion genericVersion : availableClientVersions) {
                        if (!customClientVersion.equals(genericVersion.toString())) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        StringBuilder availableVersions = new StringBuilder();
                        for (GenericVersion availableVersion : availableClientVersions) {
                            if (availableVersions.length() > 0) {
                                availableVersions.append(", ");
                            }
                            availableVersions.append(availableVersion);
                        }
                        throw new IllegalArgumentException(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Exception.InvalidRelativityClientVersion", new Object[]{customClientVersion, ((Object)availableClientVersions).toString()}));
                    }
                    clientVersion = customClientVersion;
                    this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.ExplicitClientVersion", (Object)clientVersion));
                } else {
                    GenericVersion serviceVersion = new GenericVersion(version);
                    for (GenericVersion genericVersion : availableClientVersions) {
                        if (genericVersion.getVersionText().equals(version)) {
                            LOGGER.info("Detected version match: " + String.valueOf(genericVersion));
                            clientVersion = genericVersion.getVersionText();
                            break;
                        }
                        if (!version.equals("Latest") && genericVersion.compareTo(serviceVersion) > 0) {
                            LOGGER.info("Detected lowest greater version: " + String.valueOf(genericVersion));
                            clientVersion = genericVersion.getVersionText();
                            break;
                        }
                        LOGGER.info("Version " + String.valueOf(genericVersion) + " is older than service version");
                    }
                    this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.ClientVersion", (Object)clientVersion));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_client_version}", clientVersion)));
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.ImportedThreads", (Object)importThreads));
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.ImportedThreadTimeout", (Object)importThreadTimeout));
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.ImportedThreadRetries", (Object)importThreadRetries));
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.MetadataThreads", (Object)metadataThreads));
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.PatchInvalidEntries", (Object)patchInvalidEntries));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

