/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.CONVERT_PURVIEW_ADVANCED, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"MICROSOFT_PURVIEW"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@FormFieldGroups(value={@FormFieldGroup(name="exportOptionsGroup", children={"purviewReportZipRegex", "purviewReportItemsRegex", "purviewItemsZipRegex", "purviewPstZipRegex", "convertEmailsToEmlRfc5322", "detachRegularAttachments", "stubModernAttachments"}), @FormFieldGroup(name="itemOptionsGroup", visibleOn={@OnField(name="showAdditionalOptions")}, children={"docIdColumn", "immutableIdColumn", "familyIdColumn", "modernParentIdColumn", "pathColumn", "nativeFileColumn", "fileClassColumn", "itemClassColumn", "dateColumn", "officeDateLastModified", "parentIdColumn", "fileExtensionColumn", "nativeExtensionColumn", "locationColumn", "locationNameColumn", "custodianColumn", "normalizeCustodianColumnToEmail", "documentCreatedDateColumn", "documentLastModifiedDateColumn", "hashColumn", "reduceNoise", "noiseExtensions"}), @FormFieldGroup(name="conversationOptionsGroup", visibleOn={@OnField(name="showAdditionalOptions")}, children={"conversationIdColumn", "conversationTypeColumn", "internetMessageId", "senderColumn", "subjectColumn", "recipientsColumn", "recipientCountColumn", "teamNameColumn", "channelNameColumn", "messageKindColumn"})})
@FormFieldRows(value={@FormFieldRow(name="writeErrorRow", children={"writeErrorLog", "errorLogFileLocation"}), @FormFieldRow(name="exportSplitRow", children={"exportSplit", "exportSplitAt"})})
@OperationLicenseModule(module=ModuleType.PURVIEW_COLLECTIONS_ADVANCED)
public class ConvertPurviewAdvancedOperation
extends Operation {
    @FormField
    public String purviewExportLocation = "";
    @FormField
    public String resultingNliLocation = "C:\\Data\\Purview";
    @FormField
    public String purviewReportZipRegex;
    @FormField
    public String purviewReportItemsRegex;
    @FormField
    public String purviewItemsZipRegex;
    @FormField
    public String purviewPstZipRegex;
    @FormField
    public boolean convertEmailsToEmlRfc5322;
    @FormField
    public boolean detachRegularAttachments;
    @FormField
    public boolean stubModernAttachments;
    @FormField
    public boolean ignoreMissingNativeFiles;
    @FormField
    public boolean writeErrorLog;
    @FormField(enableOn={@OnField(name="writeErrorLog")})
    public String errorLogFileLocation;
    @FormField
    public Boolean exportSplit;
    @FormField(min=1.0, enableOn={@OnField(name="exportSplit")}, positionLabel=@PositionLabel(right="items"))
    @ExcludeFromPrintableOptions
    public int exportSplitAt;
    @FormField
    public boolean showAdditionalOptions;
    @FormField
    public String docIdColumn;
    @FormField
    public String immutableIdColumn;
    @FormField
    public String familyIdColumn;
    @FormField
    public String parentIdColumn;
    @FormField
    public String modernParentIdColumn;
    @FormField
    public String pathColumn;
    public String inputPathColumn;
    @FormField
    public String nativeFileColumn;
    @FormField
    public String fileClassColumn;
    @FormField
    public String itemClassColumn;
    @FormField
    public String dateColumn;
    @FormField
    public String officeDateLastModified;
    @FormField
    public String fileExtensionColumn;
    @FormField
    public String nativeExtensionColumn;
    @FormField
    public String conversationIdColumn;
    @FormField
    public String conversationTypeColumn;
    @FormField
    public String internetMessageId;
    @FormField
    public String senderColumn;
    @FormField
    public String subjectColumn;
    @FormField
    public String recipientsColumn;
    @FormField
    public String recipientCountColumn;
    @FormField
    public String teamNameColumn;
    @FormField
    public String channelNameColumn;
    @FormField
    public String locationColumn;
    @FormField
    public String locationNameColumn;
    @FormField
    public String custodianColumn;
    @FormField
    public boolean normalizeCustodianColumnToEmail;
    @FormField
    public String messageKindColumn;
    @FormField
    public String documentCreatedDateColumn;
    @FormField
    public String documentLastModifiedDateColumn;
    @FormField
    public String hashColumn;
    @FormField
    public boolean reduceNoise;
    @FormField(enableOn={@OnField(name="reduceNoise")})
    public List<String> noiseExtensions;

    public boolean getDisplayExportSplitAt() {
        return this.exportSplit;
    }

    public ConvertPurviewAdvancedOperation() {
        this.requiresCase = false;
        this.purviewReportZipRegex = "Reports-.*?\\.zip";
        this.purviewReportItemsRegex = "Items.*\\.csv";
        this.purviewItemsZipRegex = "Items.*?\\.zip";
        this.purviewPstZipRegex = "PSTs.*?\\.zip";
        this.convertEmailsToEmlRfc5322 = false;
        this.detachRegularAttachments = false;
        this.stubModernAttachments = true;
        this.ignoreMissingNativeFiles = true;
        this.writeErrorLog = false;
        this.errorLogFileLocation = "C:\\Data\\Purview\\errors.csv";
        this.showAdditionalOptions = false;
        this.docIdColumn = "File ID";
        this.immutableIdColumn = "Immutable ID";
        this.familyIdColumn = "Family ID";
        this.parentIdColumn = "Parent ID";
        this.hashColumn = "Native SHA 256";
        this.reduceNoise = true;
        this.modernParentIdColumn = "Modern attachment parent ID";
        this.pathColumn = "Compound path";
        this.nativeFileColumn = "Target path";
        this.inputPathColumn = "Compound path";
        this.fileClassColumn = "File class";
        this.itemClassColumn = "Item class";
        this.dateColumn = "Date";
        this.officeDateLastModified = "O365_date_modified";
        this.fileExtensionColumn = "Original file extension";
        this.nativeExtensionColumn = "File extension";
        this.noiseExtensions = new ArrayList<String>();
        this.noiseExtensions.add(".docx");
        this.noiseExtensions.add(".docm");
        this.noiseExtensions.add(".dotx");
        this.noiseExtensions.add(".dotm");
        this.noiseExtensions.add(".xlsx");
        this.noiseExtensions.add(".xlsm");
        this.noiseExtensions.add(".xltx");
        this.noiseExtensions.add(".xltm");
        this.noiseExtensions.add(".xlsb");
        this.noiseExtensions.add(".pptx");
        this.noiseExtensions.add(".pptm");
        this.noiseExtensions.add(".potx");
        this.noiseExtensions.add(".potm");
        this.noiseExtensions.add(".ppam");
        this.noiseExtensions.add(".ppsx");
        this.noiseExtensions.add(".ppsm");
        this.conversationIdColumn = "Client conversation ID";
        this.conversationTypeColumn = "Conversation type";
        this.senderColumn = "Sender";
        this.subjectColumn = "Subject/Title";
        this.recipientsColumn = "Email recipients";
        this.recipientCountColumn = "Recipient count";
        this.teamNameColumn = "Team name";
        this.channelNameColumn = "Teams channel";
        this.internetMessageId = "Internet message ID";
        this.locationColumn = "Workload";
        this.locationNameColumn = "Item source";
        this.custodianColumn = "Custodian";
        this.normalizeCustodianColumnToEmail = false;
        this.messageKindColumn = "Message kind";
        this.documentCreatedDateColumn = "Doc date created";
        this.documentLastModifiedDateColumn = "Doc date modified|Last modified time";
        this.exportSplit = false;
        this.exportSplitAt = 10000;
    }

    @Override
    public void normalize() {
        super.normalize();
        if (!this.inputPathColumn.equals("Compound path")) {
            this.inputPathColumn = "Compound path";
        }
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ConvertPurviewAdvancedOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.CONVERT_PURVIEW_ADVANCED;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.OTHER_NON_WORKER;
    }

    public String getFileClassColumn() {
        return this.fileClassColumn;
    }

    public void setFileClassColumn(String fileClassColumn) {
        this.fileClassColumn = fileClassColumn;
    }
}

