/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.BooleanOperator;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmMissingApplicationBehaviour;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmMissingFileBehaviour;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmPriority;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRadioButtonGroup(name="useDefaultArchiveDirectoryRadioButtonGroup", radioButton="useDefaultArchiveDirectory", values={@RadioButtonValue(value="false", component="archiveDirectory"), @RadioButtonValue(value="true", component="")})
@FormFieldGroup(name="optionsGroup", children={"includeOptionsRow", "missingFileBehaviour", "missingProcessingFileBehaviour", "missingErrorExportBehaviour"})
@FormFieldRow(name="includeOptionsRow", numberOfColumns=2, children={"includeDatabaseBackup", "includeRepositoryFiles", "includeDtSearch", "includeLinkedFiles", "includeConceptualAnalytics", "includeProcessing", "includeStructuralAnalytics", "includeProcessingFiles", "includeDataGrid", "includeExtendedWorkspaceData"})
@OperationMetadata(alias=OperationAlias.RELATIVITY_CREATE_ARM_ARCHIVE, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@OperationParameter(label="queryRetrieveLastArmArchive", parameter="{last_arm_archive_path}")
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class CreateArmArchiveOperation
extends RelativityOperation {
    @FormField
    public boolean useDefaultArchiveDirectory;
    @FormField(enableOn={@OnField(name="useDefaultArchiveDirectory", value={"false"})})
    @ExcludeFromPrintableOptions
    public String archiveDirectory;
    @FormField
    public ArmPriority priority;
    @FormField
    public boolean waitForArchiveCompletion;
    @FormField
    public boolean lockUiJob;
    @FormField
    public boolean notifyJobCreator;
    @FormField
    public boolean notifyJobExecutor;
    @FormField
    public boolean includeDatabaseBackup;
    @FormField
    public boolean includeRepositoryFiles;
    @FormField
    public boolean includeDtSearch;
    @FormField
    public boolean includeLinkedFiles;
    @FormField
    public boolean includeConceptualAnalytics;
    @FormField
    public boolean includeProcessing;
    @FormField
    public boolean includeStructuralAnalytics;
    @FormField(enableOn={@OnField(name="includeProcessing")})
    @ExcludeFromPrintableOptions
    public boolean includeProcessingFiles;
    @FormField
    public boolean includeDataGrid;
    @FormField
    public boolean includeExtendedWorkspaceData;
    @FormField(enableOnOperator=BooleanOperator.OR, enableOn={@OnField(name="includeLinkedFiles"), @OnField(name="includeRepositoryFiles")})
    @ExcludeFromPrintableOptions
    public ArmMissingFileBehaviour missingFileBehaviour;
    @FormField(enableOn={@OnField(name="includeProcessing"), @OnField(name="includeProcessingFiles")})
    @ExcludeFromPrintableOptions
    public ArmMissingFileBehaviour missingProcessingFileBehaviour;
    @FormField(enableOn={@OnField(name="includeExtendedWorkspaceData")})
    @ExcludeFromPrintableOptions
    public ArmMissingApplicationBehaviour missingErrorExportBehaviour;

    public boolean getDisplayArchiveDirectory() {
        return !this.useDefaultArchiveDirectory;
    }

    public boolean getDisplayIncludeProcessingFiles() {
        return this.includeProcessing;
    }

    public boolean getDisplayMissingFileBehaviour() {
        return this.includeLinkedFiles || this.includeRepositoryFiles;
    }

    public boolean getDisplayMissingProcessingFileBehaviour() {
        return this.includeProcessing && this.includeProcessingFiles;
    }

    public boolean getDisplayMissingErrorExportBehaviour() {
        return this.includeExtendedWorkspaceData;
    }

    public CreateArmArchiveOperation() {
        this.requiresCase = false;
        this.archiveDirectory = "";
        this.useDefaultArchiveDirectory = false;
        this.priority = ArmPriority.MEDIUM;
        this.lockUiJob = false;
        this.notifyJobCreator = false;
        this.notifyJobExecutor = false;
        this.includeDatabaseBackup = false;
        this.includeDtSearch = false;
        this.includeConceptualAnalytics = false;
        this.includeStructuralAnalytics = false;
        this.includeDataGrid = false;
        this.includeRepositoryFiles = false;
        this.includeLinkedFiles = false;
        this.missingFileBehaviour = ArmMissingFileBehaviour.SKIP_FILE;
        this.includeProcessing = false;
        this.includeProcessingFiles = false;
        this.missingProcessingFileBehaviour = ArmMissingFileBehaviour.SKIP_FILE;
        this.includeExtendedWorkspaceData = false;
        this.missingErrorExportBehaviour = ArmMissingApplicationBehaviour.SKIP_APPLICATION;
        this.waitForArchiveCompletion = true;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityCreateArmArchiveOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedSetRelativityWorkspaceOperation = false;
        boolean detectedConfigureRelativityConnectionOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetWorkspaceOperation) {
                detectedSetRelativityWorkspaceOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (!detectedSetRelativityWorkspaceOperation) {
            prerequisites.add(this.iu.getString("RelativitySetWorkspaceOperation.Prerequisites.Missing"));
        }
        if (!this.useDefaultArchiveDirectory && (this.archiveDirectory == null || this.archiveDirectory.trim().equals(""))) {
            prerequisites.add(this.iu.getString("RelativityCreateArmArchiveOperation.Prerequisites.MissingArchiveDirectory"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

