/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.CreateArmRestoreOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativityLoadDynamicObjectsOperationImplementation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.AssociatedResourcePoolType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.ArmJobStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.ArmNotificationOptions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.restore.ArmAdvancedFileOptions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.restore.ArmDestinationOptions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.restore.ArmGroupMapping;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.restore.ArmMigratorsDestinationOptions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.restore.ArmRestore;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.restore.ArmUserMapping;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.IOException;
import java.util.List;

public class CreateArmRestoreOperationImplementation
extends CreateArmRestoreOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityLoadDynamicObjectsOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.archivePath = this.executionContext.evalParameters(this.archivePath, this);
                this.resourcePoolIdentifier = this.executionContext.evalParameters(this.resourcePoolIdentifier, this);
                this.matterIdentifier = this.executionContext.evalParameters(this.matterIdentifier, this);
                this.cacheLocationIdentifier = this.executionContext.evalParameters(this.cacheLocationIdentifier, this);
                this.fileRepositoryIdentifier = this.executionContext.evalParameters(this.fileRepositoryIdentifier, this);
                this.structuredAnalyticsServerIdentifier = this.executionContext.evalParameters(this.structuredAnalyticsServerIdentifier, this);
                this.conceptualAnalyticsServerIdentifier = this.executionContext.evalParameters(this.conceptualAnalyticsServerIdentifier, this);
                this.dtSearchLocationIdentifier = this.executionContext.evalParameters(this.dtSearchLocationIdentifier, this);
                this.existingTargetDatabase = this.executionContext.evalParameters(this.existingTargetDatabase, this);
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                Long resourcePoolArtifactId = -1L;
                Long databaseServerArtifactId = -1L;
                Long matterArtifactId = -1L;
                Long cacheLocationArtifactId = -1L;
                Long fileRepositoryArtifactId = -1L;
                Long structuredAnalyticsArtifactId = null;
                Long conceptualAnalyticsArtifactId = null;
                Long dtSearchArtifactId = null;
                Object existingTargetDatabaseId = null;
                this.stageName = this.iu.getString("RelativityCreateArmRestoreOperation.Stage.PreparingForRestore");
                this.percentageComplete = 0.05;
                boolean armApplicationInstalled = this.relativityRestClient.instanceContainsArmApplication();
                if (!armApplicationInstalled) {
                    throw new IOException(this.iu.getString("RelativityCreateArmRestoreOperation.Exception.ArmNotInstalled"));
                }
                ArmRestore restore = new ArmRestore();
                restore.setArchivePath(this.archivePath);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.ArchivePath", (Object)this.archivePath));
                restore.setJobPriority(this.priority);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.Priority", (Object)this.priority));
                restore.setUiJobActionsLocked(this.lockUiJobActions);
                this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.LockUi"));
                ArmNotificationOptions notificationOptions = new ArmNotificationOptions();
                notificationOptions.setNotifyJobCreator(this.notifyJobCreator);
                notificationOptions.setNotifyJobExecutor(this.notifyJobExecutor);
                restore.setNotificationOptions(notificationOptions);
                if (this.notifyJobCreator && this.notifyJobExecutor) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.NotifyBoth"));
                } else if (this.notifyJobCreator) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.NotifyCreator"));
                } else if (this.notifyJobExecutor) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.NotifyExecutor"));
                }
                ArmDestinationOptions destinationOptions = new ArmDestinationOptions();
                List<EligibleObject> eligibleResourcePools = this.relativityRestClient.queryResourcePools();
                EligibleObject eligibleResourcePool = null;
                if (this.useResourcePoolIdentifier) {
                    eligibleResourcePool = RelativityUtils.getInstance().filterEligibleObject(this.resourcePoolIdentifier, this.resourcePoolIdentifierType, eligibleResourcePools, RelativityFieldType.RESOURCE_POOL);
                    if (eligibleResourcePool == null) {
                        throw new IOException(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Exception.MissingDefinedResourcePool", (Object)String.valueOf(this.resourcePoolIdentifier)));
                    }
                } else if (eligibleResourcePools != null && eligibleResourcePools.size() > 0) {
                    eligibleResourcePool = eligibleResourcePools.get(0);
                }
                if (eligibleResourcePool == null) {
                    throw new IOException(this.iu.getString("RelativityCreateArmRestoreOperation.Exception.NoResourcePoolsExist"));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.ResourcePool", (Object)eligibleResourcePool.getName()));
                resourcePoolArtifactId = eligibleResourcePool.getArtifactId();
                destinationOptions.setResourcePoolID(resourcePoolArtifactId);
                List<EligibleObject> eligibleDatabaseServers = this.relativityRestClient.queryAssociatedResourcePoolObject(resourcePoolArtifactId, AssociatedResourcePoolType.SQL_SERVERS);
                EligibleObject eligibleDatabaseServer = null;
                if (this.useResourcePoolIdentifier && this.useDatabaseIdentifier) {
                    eligibleDatabaseServer = RelativityUtils.getInstance().filterEligibleObject(this.databaseServerIdentifier, this.databaseServerIdentifierType, eligibleDatabaseServers, RelativityFieldType.SQL_SERVER);
                    if (eligibleDatabaseServer == null) {
                        throw new IOException(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Exception.MissingDefinedDatabaseServer", (Object)String.valueOf(this.databaseServerIdentifier)));
                    }
                } else if (eligibleDatabaseServers != null && eligibleDatabaseServers.size() > 0) {
                    eligibleDatabaseServer = eligibleDatabaseServers.get(0);
                }
                if (eligibleDatabaseServer == null) {
                    throw new IOException(this.iu.getString("RelativityCreateArmRestoreOperation.Exception.NoDatabaseServersExist"));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.DatabaseServer", (Object)eligibleDatabaseServer.getName()));
                databaseServerArtifactId = eligibleDatabaseServer.getArtifactId();
                destinationOptions.setDatabaseServerID(databaseServerArtifactId);
                List<EligibleObject> eligibleCacheLocations = this.relativityRestClient.queryAssociatedResourcePoolObject(resourcePoolArtifactId, AssociatedResourcePoolType.CACHE_LOCATION_SERVERS);
                EligibleObject eligibleCacheLocation = null;
                if (this.useResourcePoolIdentifier && this.useCacheLocationIdentifier) {
                    eligibleCacheLocation = RelativityUtils.getInstance().filterEligibleObject(this.cacheLocationIdentifier, this.cacheLocationIdentifierType, eligibleCacheLocations, RelativityFieldType.CACHE_LOCATION);
                    if (eligibleCacheLocation == null) {
                        throw new IOException(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Exception.MissingDefinedCacheLocation", (Object)String.valueOf(this.cacheLocationIdentifier)));
                    }
                } else if (eligibleCacheLocations != null && eligibleCacheLocations.size() > 0) {
                    eligibleCacheLocation = eligibleCacheLocations.get(0);
                }
                if (eligibleCacheLocation == null) {
                    throw new IOException(this.iu.getString("RelativityCreateArmRestoreOperation.Exception.NoCacheLocationsExist"));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.CacheLocation", (Object)eligibleCacheLocation.getName()));
                cacheLocationArtifactId = eligibleCacheLocation.getArtifactId();
                destinationOptions.setCacheLocationID(cacheLocationArtifactId);
                List<EligibleObject> eligibleFileRepositories = this.relativityRestClient.queryAssociatedResourcePoolObject(resourcePoolArtifactId, AssociatedResourcePoolType.FILE_REPOSITORIES);
                EligibleObject eligibleFileRepository = null;
                if (this.useResourcePoolIdentifier && this.useFileRepositoryIdentifier) {
                    eligibleFileRepository = RelativityUtils.getInstance().filterEligibleObject(this.fileRepositoryIdentifier, this.fileRepositoryIdentifierType, eligibleFileRepositories, RelativityFieldType.FILE_REPOSITORY);
                    if (eligibleFileRepository == null) {
                        throw new IOException(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Exception.MissingDefinedFileRepository", (Object)String.valueOf(this.fileRepositoryIdentifier)));
                    }
                } else if (eligibleFileRepositories != null && eligibleFileRepositories.size() > 0) {
                    eligibleFileRepository = eligibleFileRepositories.get(0);
                }
                if (eligibleFileRepository == null) {
                    throw new IOException(this.iu.getString("RelativityCreateArmRestoreOperation.Exception.NoFileRepositoriesExist"));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.FileRepository", (Object)eligibleFileRepository.getName()));
                fileRepositoryArtifactId = eligibleFileRepository.getArtifactId();
                destinationOptions.setFileRepositoryID(fileRepositoryArtifactId);
                if (!this.useMatterIdentifier) {
                    this.matterIdentifierType = RelativityIdentifierType.ARTIFACT_ID;
                    this.matterIdentifier = this.executionContext.evalProtectedParameter("{relativity_matter_id}");
                }
                List<EligibleObject> eligibleMatters = this.relativityRestClient.queryEligibleMattersNoWorkspace(this.matterIdentifierType, this.matterIdentifier);
                EligibleObject eligibleMatter = RelativityUtils.getInstance().filterAllEligibleObject(this.matterIdentifier, this.matterIdentifierType, eligibleMatters, RelativityFieldType.MATTER);
                if (eligibleMatter == null) {
                    throw new IOException(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Exception.MissingDefinedMatter", (Object)String.valueOf(this.matterIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.Matter", (Object)eligibleMatter.getName()));
                matterArtifactId = eligibleMatter.getArtifactId();
                destinationOptions.setMatterID(matterArtifactId);
                restore.setDestinationOptions(destinationOptions);
                ArmMigratorsDestinationOptions migratorsDestinationOptions = new ArmMigratorsDestinationOptions();
                List<EligibleObject> eligibleAnalyticServers = this.relativityRestClient.queryAssociatedResourcePoolObject(resourcePoolArtifactId, AssociatedResourcePoolType.ANALYTICS_SERVERS);
                if (this.hasStructuredAnalytics) {
                    EligibleObject eligibleStructuralAnalyticsServer = RelativityUtils.getInstance().filterEligibleObject(this.structuredAnalyticsServerIdentifier, this.structuredAnalyticsServerIdentifierType, eligibleAnalyticServers, RelativityFieldType.ANALYTICS_SEVER);
                    if (eligibleStructuralAnalyticsServer == null) {
                        throw new IOException(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Exception.MissingDefinedStructuredAnalytics", (Object)String.valueOf(this.structuredAnalyticsServerIdentifier)));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.StructuredAnalytics", (Object)eligibleStructuralAnalyticsServer.getName()));
                    structuredAnalyticsArtifactId = eligibleStructuralAnalyticsServer.getArtifactId();
                    migratorsDestinationOptions.setStructuredAnalyticsServerID(structuredAnalyticsArtifactId);
                } else {
                    migratorsDestinationOptions.setStructuredAnalyticsServerID(null);
                }
                if (this.hasConceptualAnalytics) {
                    EligibleObject eligibleConceptualAnalyticsServer = RelativityUtils.getInstance().filterEligibleObject(this.conceptualAnalyticsServerIdentifier, this.conceptualAnalyticsServerIdentifierType, eligibleAnalyticServers, RelativityFieldType.ANALYTICS_SEVER);
                    if (eligibleConceptualAnalyticsServer == null) {
                        throw new IOException(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Exception.MissingDefinedConceptualAnalytics", (Object)String.valueOf(this.conceptualAnalyticsServerIdentifier)));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.ConceptualAnalytics", (Object)eligibleConceptualAnalyticsServer.getName()));
                    conceptualAnalyticsArtifactId = eligibleConceptualAnalyticsServer.getArtifactId();
                    migratorsDestinationOptions.setConceptualAnalyticsServerID(conceptualAnalyticsArtifactId);
                } else {
                    migratorsDestinationOptions.setConceptualAnalyticsServerID(null);
                }
                if (this.hasDtSearchLocation) {
                    EligibleObject eligibleDtSearchLocations = RelativityUtils.getInstance().filterEligibleObject(this.dtSearchLocationIdentifier, this.dtSearchLocationIdentifierType, eligibleAnalyticServers, RelativityFieldType.DT_INDEX);
                    if (eligibleDtSearchLocations == null) {
                        throw new IOException(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Exception.MissingDefinedDtSearch", (Object)String.valueOf(this.dtSearchLocationIdentifier)));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.DtSearchLocation", (Object)eligibleDtSearchLocations.getName()));
                    dtSearchArtifactId = eligibleDtSearchLocations.getArtifactId();
                    migratorsDestinationOptions.setDtSearchLocationID(dtSearchArtifactId);
                } else {
                    migratorsDestinationOptions.setDtSearchLocationID(null);
                }
                restore.setMigratorsDestinationOptions(migratorsDestinationOptions);
                ArmAdvancedFileOptions advancedFileOptions = new ArmAdvancedFileOptions();
                advancedFileOptions.setReferenceFilesAsArchiveLinks(this.referenceFilesAsArchiveLinks);
                if (this.referenceFilesAsArchiveLinks) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.ReferenceFilesAsArchiveLinks"));
                }
                advancedFileOptions.setUpdateRepositoryFilePaths(this.updateRepositoryFilePaths);
                if (this.updateRepositoryFilePaths) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.UpdateRepositoryFilePaths"));
                }
                advancedFileOptions.setUpdateLinkedFilePaths(this.updateLinkedFilePaths);
                if (this.updateLinkedFilePaths) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.UpdateLinkedFilePaths"));
                }
                restore.setAdvancedFileOptions(advancedFileOptions);
                ArmUserMapping userMapping = new ArmUserMapping();
                userMapping.setUserMappings(null);
                userMapping.setAutoMapUsers(this.autoMapUsers);
                if (this.autoMapUsers) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.AutoMapUsers"));
                }
                restore.setUserMapping(userMapping);
                ArmGroupMapping groupMapping = new ArmGroupMapping();
                groupMapping.setGroupMappings(null);
                groupMapping.setAutoMapGroups(this.autoMapGroups);
                if (this.autoMapGroups) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.AutoMapGroups"));
                }
                restore.setGroupMapping(groupMapping);
                if (this.backupDoesNotContainDatabaseBackup) {
                    restore.setExistingTargetDatabase(this.existingTargetDatabase);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.ExistingTargetDatabase", (Object)this.existingTargetDatabase));
                } else {
                    restore.setExistingTargetDatabase(null);
                }
                this.stageName = this.iu.getString("RelativityCreateArmRestoreOperation.Stage.CreatingRestore");
                this.percentageComplete = 0.3;
                Long jobArtifactId = this.relativityRestClient.createArmRestore(restore);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateArmRestoreOperation.Info.JobId", (Object)String.valueOf(jobArtifactId)));
                this.relativityRestClient.runArmJob(jobArtifactId);
                if (this.waitForCompletion) {
                    this.addExecutionLog(this.iu.getString("RelativityCreateArmRestoreOperation.Info.WaitingForCompletion"));
                    ArmJobStatus restoreStatus = this.relativityRestClient.getArmJobStatus(jobArtifactId);
                    while (!RelativityUtils.getInstance().isArmJobCompleted(restoreStatus)) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        if (restoreStatus.getCurrentJobStage() != null) {
                            this.percentageComplete = 0.3 + (double)restoreStatus.getCurrentJobStage().getOrder().intValue() / (double)restoreStatus.getTotalNumberOfStages().intValue() * 0.7;
                            this.stageName = restoreStatus.getCurrentJobStage().getName();
                        } else {
                            this.percentageComplete = 0.3;
                            this.stageName = restoreStatus.getJobState().toString();
                        }
                        Thread.sleep(1000L);
                        restoreStatus = this.relativityRestClient.getArmJobStatus(jobArtifactId);
                    }
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

