/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.CreateNuixLogicalImageOperation;
import com.nuix.automate.workflow.core.utils.loadfile.LoadFileField;
import com.nuix.automate.workflow.core.utils.loadfile.Loadfile;
import com.nuix.automate.workflow.core.utils.loadfile.LoadfileItem;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jetbrains.annotations.NotNull;

public class CreateNuixLogicalImageOperationImplementation
extends CreateNuixLogicalImageOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CreateNuixLogicalImageOperation.class);
    private AtomicLong totalRecordsCount;
    private AtomicLong totalTlRecordsCount;
    private AtomicLong totalItemsProcessed;
    private AtomicLong itemsWithErrors;

    private void convertFolder(Path sourceFolder) throws IOException, ParserConfigurationException, TransformerException {
        if (this.stopRequested) {
            return;
        }
        LOGGER.info("Handling folder " + String.valueOf(sourceFolder));
        Path resultingNli = this.getResultingNli(sourceFolder);
        if (!Files.exists(resultingNli.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(resultingNli.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Cannot create NLI parent folder", (Throwable)e);
            }
        }
        try (ZipOutputStream outputZip = new ZipOutputStream(new FileOutputStream(resultingNli.toFile()));){
            outputZip.setLevel(0);
            outputZip.setMethod(0);
            ArrayList<LoadFileField> fileSystemProperties = new ArrayList<LoadFileField>();
            fileSystemProperties.add(new LoadFileField("Creation Date", "DateTime", 0));
            fileSystemProperties.add(new LoadFileField("Last Access Date", "DateTime", 1));
            fileSystemProperties.add(new LoadFileField("Last Modified Date", "DateTime", 2));
            Loadfile loadfile = new Loadfile(fileSystemProperties);
            try (Stream<Path> stream = Files.walk(sourceFolder, new FileVisitOption[0]);){
                stream.forEach(streamItem -> {
                    if (!Files.isDirectory(streamItem, new LinkOption[0])) {
                        this.totalRecordsCount.incrementAndGet();
                        String docId = "DOC-" + String.format("%07d", this.totalRecordsCount.get());
                        String location = sourceFolder.relativize((Path)streamItem).toString();
                        LoadfileItem loadfileItem = this.createLoadfileItem((Path)streamItem, docId, location);
                        loadfile.addTopLevelItem(loadfileItem);
                    } else {
                        loadfile.getCreateFolderAtLocation(String.valueOf(sourceFolder.relativize((Path)streamItem)) + "/DummyChildName");
                    }
                });
            }
            LOGGER.info("Scanned " + this.totalRecordsCount.get() + " files");
            this.totalItemsProcessed = new AtomicLong(0L);
            this.itemsWithErrors = new AtomicLong(0L);
            loadfile.writeNli(outputZip, this.totalItemsProcessed, this.itemsWithErrors);
            this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.WroteNli", (Object)resultingNli.getFileName().toString()));
        }
    }

    @NotNull
    private LoadfileItem createLoadfileItem(final Path streamItem, String docId, String location) {
        String fileClass = "file";
        ArrayList<String> properties = new ArrayList<String>();
        try {
            BasicFileAttributes attributes = Files.readAttributes(streamItem, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            properties.add(attributes.creationTime().toString());
            properties.add(attributes.lastAccessTime().toString());
            properties.add(attributes.lastModifiedTime().toString());
        }
        catch (IOException e) {
            LOGGER.error("Cannot get file " + String.valueOf(streamItem) + " attributes", (Throwable)e);
        }
        LoadfileItem loadfileItem = new LoadfileItem(docId, docId, location, fileClass, properties){

            @Override
            public InputStream getInputStream() throws IOException {
                return Files.newInputStream(streamItem, StandardOpenOption.READ);
            }
        };
        return loadfileItem;
    }

    private Path getResultingNli(Path sourceFolder) throws IOException {
        Path destinationPath = Paths.get(this.resultingNliLocation, new String[0]);
        Object desiredFileName = FileUtils.getFileNameWithoutExtension((String)sourceFolder.getFileName().toString()) + ".nli";
        Path folderPath = destinationPath;
        if (destinationPath.getFileName().toString().toLowerCase().contains(".nli")) {
            folderPath = destinationPath.getParent();
            desiredFileName = destinationPath.getFileName().toString();
        }
        if (Files.exists(folderPath, new LinkOption[0])) {
            Files.createDirectories(folderPath, new FileAttribute[0]);
        }
        Path resultingNli = folderPath.resolve((String)desiredFileName);
        String originalName = resultingNli.getFileName().toString();
        boolean originalFileAlreadyExists = false;
        for (int i = 2; i < 100; ++i) {
            if (!Files.exists(resultingNli, new LinkOption[0])) {
                if (originalFileAlreadyExists) {
                    this.addWarning(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.FileAlreadyExists", new Object[]{originalName, resultingNli.getFileName().toString()}));
                }
                return resultingNli;
            }
            resultingNli = folderPath.resolve(FileUtils.getFileNameWithoutExtension((String)desiredFileName) + " " + i + ".nli");
            originalFileAlreadyExists = true;
        }
        throw new IOException("Output file " + resultingNli.toString() + " already exists");
    }

    @Override
    protected void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.startTriggerThread = new Thread(() -> {
            try {
                this.sourceLocation = this.executionContext.evalParameters(this.sourceLocation, this);
                this.resultingNliLocation = this.executionContext.evalParameters(this.resultingNliLocation, this);
                this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.SourceLocation", (Object)this.sourceLocation));
                this.addExecutionLog(this.iu.getFormattedString("ConvertPurviewExportOperation.Log.DestinationLocation", (Object)this.resultingNliLocation));
                this.totalRecordsCount = new AtomicLong(0L);
                this.totalItemsProcessed = new AtomicLong(0L);
                this.convertFolder(Paths.get(this.sourceLocation, new String[0]));
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.addExecutionLog(this.iu.getNumeralString("ConvertPurviewExport.Log.Records", this.totalRecordsCount.get()));
                if (this.itemsWithErrors.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("ConvertPurviewExport.Log.RecordsErrors", this.itemsWithErrors.get()));
                }
                if (this.executionState != ExecutionState.ERROR) {
                    this.trackFinished();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
        this.startTriggerThread.join();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.totalItemsProcessed != null && this.totalItemsProcessed.get() > 0L && this.totalTlRecordsCount != null && this.totalTlRecordsCount.get() > 0L) {
            return (double)this.totalItemsProcessed.get() / (double)this.totalTlRecordsCount.get();
        }
        return 0.0;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.totalItemsProcessed != null && this.totalItemsProcessed.get() > 0L) {
            result = (String)result + this.iu.getNumeralString("General.Progress.ItemsProcessed", this.totalItemsProcessed.get());
        }
        return result;
    }
}

