/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.daterangefilter.DateCriteria;
import com.nuix.automate.workflow.core.execution.options.daterangefilter.DateFilterIntervalType;
import com.nuix.automate.workflow.core.execution.options.daterangefilter.FilterActionType;
import com.nuix.automate.workflow.core.execution.options.matchitems.MatchScope;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@FormFieldRow(name="dateRangeRow", children={"dateFilterIntervalType", "dateAfter", "dateBefore"})
@OperationMetadata(alias=OperationAlias.DATE_RANGE_FILTER, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"CULLING", "TAG"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class DateRangeFilterOperation
extends Operation {
    @FormField(required=false)
    public String scope = "flag:audited";
    @FormField(allowedValues={"BETWEEN", "NOT_BETWEEN", "AFTER", "BEFORE"})
    public DateFilterIntervalType dateFilterIntervalType;
    @FormField(enableOn={@OnField(name="dateFilterIntervalType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"BEFORE"})})
    public Date dateAfter;
    @FormField(enableOn={@OnField(name="dateFilterIntervalType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"AFTER"})})
    public Date dateBefore;
    @FormField
    @ExcludeFromPrintableOptions
    public DateCriteria dateCriteria;
    @FormField(visibleOn={@OnField(name="dateCriteria", value={"DATE_PROPERTIES"})}, columnFields={@FormFieldColumn(label="propertyName")})
    public Set<String> datePropertyNames;
    @FormField
    public FilterActionType filterActionType;
    @FormField
    public String actionName = this.iu.getString("DateRangeFilterOperation.Property.ActionName");
    @FormField
    public MatchScope filterActionScope;

    public DateRangeFilterOperation() {
        this.datePropertyNames = new LinkedHashSet<String>();
        this.datePropertyNames.add("File Created");
        this.filterActionType = FilterActionType.TAG;
        this.filterActionScope = MatchScope.MATCHES;
        this.dateCriteria = DateCriteria.ITEM_DATE;
        this.dateFilterIntervalType = DateFilterIntervalType.BETWEEN;
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        this.dateAfter = calendar.getTime();
        calendar.set(2, 11);
        calendar.set(5, 31);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 0);
        this.dateBefore = calendar.getTime();
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("DateRangeFilterOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.DATE_RANGE_FILTER;
    }

    protected String getActionName() {
        return this.filterActionType == FilterActionType.TAG ? "Tag" : "Exclusion";
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.actionName.trim().length() == 0) {
            prerequisites.add(this.iu.getFormattedString("DateRangeFilterOperation.Prerequisites.NameCannotBeBlank", (Object)this.getActionName()));
        }
        if (this.dateCriteria == DateCriteria.DATE_PROPERTIES && this.datePropertyNames.size() == 0) {
            prerequisites.add(this.iu.getString("DateRangeFilterOperation.Prerequisites.DatePropertiesCantBeBlank"));
        }
        return prerequisites;
    }
}

