/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.DateRangeFilterOperation;
import com.nuix.automate.workflow.core.execution.options.daterangefilter.DateFilterIntervalType;
import com.nuix.automate.workflow.core.execution.options.daterangefilter.FilterActionType;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import nuix.BulkAnnotater;
import nuix.ItemEventCallback;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class DateRangeFilterOperationImplementation
extends DateRangeFilterOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DateRangeFilterOperation.class);
    private transient String stage;
    private transient int stageId;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stage = this.iu.getString("DateRangeFilterOperation.Stage.FindingItems");
                this.stageId = 0;
                this.executionContext.closeAllTabs();
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.actionName = this.executionContext.evalParameters(this.actionName, this);
                this.addExecutionLog(this.iu.getFormattedString("DateRangeFilterOperation.Log.ScopeQuery", (Object)this.scope));
                Set scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("DateRangeFilterOperation.Log.ScopeCount", (long)scopeItems.size()));
                if (scopeItems.size() == 0) {
                    this.addWarning(this.iu.getString("DateRangeFilterOperation.Warning.NoItemsFoundInScope"));
                    this.trackFinished();
                    return;
                }
                String filterBeforeDateParameter = "{filter_before_date}";
                String evaluatedFilterBeforeDateParameter = this.executionContext.evalParameters(filterBeforeDateParameter, this);
                try {
                    if (!filterBeforeDateParameter.equals(evaluatedFilterBeforeDateParameter)) {
                        DateTimeFormatter nuixDateTimeFormat = new DateTimeFormatterBuilder().appendOptional(DateTimeFormat.forPattern((String)"YYYYMMdd").getParser()).toFormatter();
                        DateTime dateTime = DateTime.parse((String)evaluatedFilterBeforeDateParameter, (DateTimeFormatter)nuixDateTimeFormat).plusDays(1).minusMillis(1);
                        this.dateBefore = dateTime.toDate();
                        LOGGER.info("Parsed specified filter before date " + this.dateBefore.toString() + " from " + filterBeforeDateParameter + " with Nuix format");
                        this.addExecutionLog(this.iu.getFormattedString("DateRangeFilterOperation.Log.FilterBeforeDateFromParameter", new Object[]{"{filter_before_date}", this.dateBefore.toString()}));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse before date: ", (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("DateRangeFilterOperation.Log.InvalidFilterBeforeDateParameter", new Object[]{"{filter_before_date}", evaluatedFilterBeforeDateParameter}));
                }
                String filterAfterDateParameter = "{filter_after_date}";
                String evaluatedFilterAfterDateParameter = this.executionContext.evalParameters(filterAfterDateParameter, this);
                try {
                    if (!filterAfterDateParameter.equals(evaluatedFilterAfterDateParameter)) {
                        DateTimeFormatter nuixDateTimeFormat = new DateTimeFormatterBuilder().appendOptional(DateTimeFormat.forPattern((String)"YYYYMMdd").getParser()).toFormatter();
                        DateTime dateTime = DateTime.parse((String)evaluatedFilterAfterDateParameter, (DateTimeFormatter)nuixDateTimeFormat);
                        this.dateAfter = dateTime.toDate();
                        LOGGER.info("Parsed specified filter after date " + this.dateAfter.toString() + " from " + filterAfterDateParameter + " with Nuix format");
                        this.addExecutionLog(this.iu.getFormattedString("DateRangeFilterOperation.Log.FilterAfterDateFromParameter", new Object[]{"{filter_after_date}", this.dateAfter.toString()}));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse after date: ", (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("DateRangeFilterOperation.Log.InvalidFilterAfterDateParameter", new Object[]{"{filter_after_date}", evaluatedFilterAfterDateParameter}));
                }
                LOGGER.info("Searching for items in date range: " + this.getDateIntervalToString() + " with criteria " + String.valueOf((Object)this.dateCriteria));
                this.addExecutionLog(this.iu.getFormattedString("DateRangeFilterOperation.Log.DateRange", (Object)this.getDateIntervalToString()));
                this.addExecutionLog(this.iu.getFormattedString("DateRangeFilterOperation.Log.DateCriteria", (Object)this.dateCriteria));
                if ((this.dateFilterIntervalType.equals(DateFilterIntervalType.BETWEEN) || this.dateFilterIntervalType.equals(DateFilterIntervalType.NOT_BETWEEN)) && this.dateBefore.before(this.dateAfter)) {
                    this.addWarning(this.iu.getString("DateRangeFilterOperation.Warning.DateRangeReversed"));
                }
                String dateRangeQuery = this.getDateRangeQuery();
                LOGGER.info("Built date range query: " + dateRangeQuery);
                Object dateQuery = "";
                switch (this.dateCriteria) {
                    case ITEM_DATE: {
                        dateQuery = "item-date:" + dateRangeQuery;
                        break;
                    }
                    case TOP_LEVEL_ITEM_DATE: {
                        dateQuery = "top-level-item-date:" + dateRangeQuery;
                        break;
                    }
                    case DATE_PROPERTIES: {
                        HashSet<CallSite> datePropertyQueries = new HashSet<CallSite>();
                        for (String datePropertyName : this.datePropertyNames) {
                            datePropertyName = this.executionContext.evalParameters(datePropertyName, this);
                            String datePropertyQuery = "date-properties:\"" + datePropertyName + "\":" + dateRangeQuery;
                            datePropertyQueries.add((CallSite)((Object)datePropertyQuery));
                        }
                        dateQuery = String.join((CharSequence)" OR ", datePropertyQueries);
                    }
                }
                if (this.dateFilterIntervalType == DateFilterIntervalType.NOT_BETWEEN) {
                    dateQuery = "NOT (" + (String)dateQuery + ")";
                }
                LOGGER.info("Built final date query: " + (String)dateQuery);
                String filterQuery = NuixUtils.addAndQuery(this.scope, (String)dateQuery);
                LOGGER.info("Searching for items in scope within date range, filterQuery = " + filterQuery);
                Set filterItems = this.executionContext.nuixCase.searchUnsorted(filterQuery);
                this.addExecutionLog(this.iu.getNumeralString("DateRangeFilterOperation.Log.ScopeItemsWithinDateRangeCount", (long)filterItems.size()));
                this.stage = this.iu.getString("DateRangeFilterOperation.Stage.ApplyingActionScope");
                this.stageId = 1;
                LOGGER.info("Matching items using action scope " + String.valueOf((Object)this.filterActionScope));
                this.addExecutionLog(this.iu.getFormattedString("DateRangeFilterOperation.Log.ActionScope", (Object)this.filterActionScope));
                Set matchedItems = null;
                switch (this.filterActionScope) {
                    case MATCHES: {
                        matchedItems = filterItems;
                        break;
                    }
                    case ALL_FAMILIES: {
                        matchedItems = this.executionContext.nuixUtilities.getItemUtility().findFamilies((Collection)filterItems);
                        break;
                    }
                    case ALL_DESCENDANTS: {
                        matchedItems = this.executionContext.nuixUtilities.getItemUtility().findDescendants((Collection)filterItems);
                        break;
                    }
                    case MATCHES_DESCENDANTS: {
                        matchedItems = this.executionContext.nuixUtilities.getItemUtility().findItemsAndDescendants((Collection)filterItems);
                        break;
                    }
                    case TOP_LEVEL: {
                        matchedItems = this.executionContext.nuixUtilities.getItemUtility().findTopLevelItems((Collection)filterItems);
                    }
                }
                if (matchedItems == null) {
                    throw new Exception(this.iu.getFormattedString("DateRangeFilterOperation.Exception.FailedToMatchScopeItems", (Object)this.filterActionScope));
                }
                this.addExecutionLog(this.iu.getNumeralString("DateRangeFilterOperation.Log.ActionScopeCount", (long)matchedItems.size()));
                LOGGER.info("Intersecting action scope matched items with global scope: " + this.scope);
                Set actionItems = this.executionContext.nuixUtilities.getItemUtility().intersection((Collection)scopeItems, (Collection)matchedItems);
                this.stage = this.filterActionType == FilterActionType.TAG ? "Tag" : "Exclusion";
                this.stageId = 2;
                String action = this.getActionName();
                LOGGER.info("Applying action " + String.valueOf((Object)this.filterActionType) + " to matched items");
                this.addExecutionLog(this.iu.getFormattedString("DateRangeFilterOperation.Log.Action", (Object)this.filterActionType));
                this.addExecutionLog(this.iu.getFormattedString("DateRangeFilterOperation.Log.ActionName", new Object[]{action, this.actionName}));
                AtomicLong countItemsFailedToAction = new AtomicLong(0L);
                if (actionItems.size() > 0) {
                    BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    ItemEventCallback itemEventCallback = itemEventInfo -> {
                        if (itemEventInfo.getFailure() != null) {
                            LOGGER.error("Failed to apply action to item " + itemEventInfo.getItem().getGuid(), (Throwable)itemEventInfo.getFailure());
                            countItemsFailedToAction.getAndIncrement();
                        }
                    };
                    switch (this.filterActionType) {
                        case TAG: {
                            bulkAnnotater.addTag(this.actionName, (Collection)actionItems, itemEventCallback);
                            break;
                        }
                        case EXCLUDE: {
                            bulkAnnotater.exclude(this.actionName, (Collection)actionItems, itemEventCallback);
                        }
                    }
                }
                this.stageId = 3;
                long countItemsActionFailed = countItemsFailedToAction.get();
                long countItemsActionApplied = (long)actionItems.size() - countItemsActionFailed;
                this.addExecutionLog(this.iu.getNumeralFormattedString("DateRangeFilterOperation.Log.ActionCount", countItemsActionApplied, (Object)action));
                if (countItemsActionFailed > 0L) {
                    this.addWarning(this.iu.getNumeralFormattedString("DateRangeFilterOperation.Warning.FailedToApply", countItemsActionFailed, (Object)action));
                }
                this.trackFinished();
            }
            catch (ParameterException e) {
                LOGGER.error("Error evaluating parameters", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private String getDateRangeQuery() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
        Object dateRangeQuery = "";
        switch (this.dateFilterIntervalType) {
            case AFTER: {
                dateRangeQuery = "[" + simpleDateFormat.format(this.dateAfter) + " TO *]";
                break;
            }
            case BEFORE: {
                dateRangeQuery = "[* TO " + simpleDateFormat.format(this.dateBefore) + "]";
                break;
            }
            case BETWEEN: 
            case NOT_BETWEEN: {
                dateRangeQuery = "[" + simpleDateFormat.format(this.dateAfter) + " TO " + simpleDateFormat.format(this.dateBefore) + "]";
                break;
            }
            default: {
                dateRangeQuery = "[* TO *]";
            }
        }
        return ((String)dateRangeQuery).replaceAll("-", "T");
    }

    private String getDateIntervalToString() {
        Object dateIntervalString = "";
        switch (this.dateFilterIntervalType) {
            case AFTER: {
                dateIntervalString = "After " + FormattingUtils.dateToLocalString((Date)this.dateAfter);
                break;
            }
            case BEFORE: {
                dateIntervalString = "Before " + FormattingUtils.dateToLocalString((Date)this.dateBefore);
                break;
            }
            case BETWEEN: {
                dateIntervalString = "Between " + FormattingUtils.dateToLocalString((Date)this.dateAfter) + " and " + FormattingUtils.dateToLocalString((Date)this.dateBefore);
                break;
            }
            case NOT_BETWEEN: {
                dateIntervalString = "Not between " + FormattingUtils.dateToLocalString((Date)this.dateAfter) + " and " + FormattingUtils.dateToLocalString((Date)this.dateBefore);
            }
        }
        return dateIntervalString;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = (double)this.stageId / 3.0;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stage != null && this.stage.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stage;
        }
        return result;
    }
}

