/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.DeleteDigestListOperation;
import com.nuix.automate.workflow.core.utils.digestlist.DigestHelper;
import com.nuix.automate.workflow.core.utils.digestlist.DigestLocation;
import java.io.IOException;
import java.util.ArrayList;

public class DeleteDigestListOperationImplementation
extends DeleteDigestListOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DeleteDigestListOperation.class);
    private transient DigestHelper digestHelper;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.digestListName = this.executionContext.evalParameters(this.digestListName, this);
                this.addExecutionLog(this.iu.getFormattedString("DeleteDigestListOperation.Log.DigestListName", (Object)this.digestListName));
                this.addExecutionLog(this.iu.getFormattedString("DeleteDigestListOperation.Log.DeleteFrom", (Object)this.getJoinedDigestLocations()));
                this.stageName = this.iu.getString("DeleteDigestListOperation.Stage.DeletingDigestList");
                this.digestHelper = new DigestHelper(this.executionContext.nuixCase);
                this.digestHelper.deleteDigestList(this.digestListName, this.digestLocations);
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.addExecutionLog(this.iu.getString("DeleteDigestListOperation.Log.DigestListDeletedFromAllLocations"));
                this.trackFinished();
            }
            catch (ParameterException e) {
                LOGGER.error("Error evaluating parameters", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (IOException e) {
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private String getJoinedDigestLocations() {
        ArrayList<String> locations = new ArrayList<String>(3);
        for (DigestLocation location : this.digestLocations) {
            locations.add(location.toString());
        }
        return String.join((CharSequence)"; ", locations);
    }

    @Override
    protected void stopTriggered() {
        this.digestHelper.requestStop();
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        long itemsProcessed = 0L;
        if (this.digestHelper != null) {
            itemsProcessed = this.digestHelper.getItemsProcessed();
        }
        if (itemsProcessed > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("DeleteDigestListOperation.Progress.ItemsProcessed", itemsProcessed);
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.digestHelper != null) {
            percentageComplete = this.digestHelper.getExecutionProgress();
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }
}

