/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.general.ToInclude;
import com.nuix.automate.workflow.core.execution.options.productionset.ProductionSetState;
import java.util.ArrayList;
import java.util.List;

@OperationMetadata(alias=OperationAlias.DELETE_PRODUCTION_SET, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"PRODUCTION"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_LEGAL)
public class DeleteProductionSetOperation
extends Operation {
    @FormField
    public ToInclude productionSetsToDelete;
    @FormField
    public ProductionSetState productionSetState;
    @FormField(visibleOn={@OnField(name="productionSetsToDelete", value={"SPECIFIC"})}, columnFields={@FormFieldColumn(label="name")})
    public List<Object[]> productionSetNames = new ArrayList<Object[]>();

    public DeleteProductionSetOperation() {
        this.productionSetNames.add(new String[]{"", ""});
        this.productionSetsToDelete = ToInclude.SPECIFIC;
        this.productionSetState = ProductionSetState.FROZEN;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("DeleteProductionSetOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.DELETE_PRODUCTION_SET;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.productionSetsToDelete == ToInclude.SPECIFIC) {
            boolean allEmpty = true;
            for (Object[] name : this.productionSetNames) {
                String productionSetName = (String)name[0];
                if (productionSetName.trim().length() == 0) continue;
                allEmpty = false;
                break;
            }
            if (allEmpty) {
                prerequisites.add(this.iu.getString("DeleteProductionSetOperation.Prerequisites.NameMustBeSpecified"));
            }
        }
        return prerequisites;
    }
}

