/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.DeleteProductionSetOperation;
import com.nuix.automate.workflow.core.execution.options.general.ToInclude;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nuix.ProductionSet;

public class DeleteProductionSetOperationImplementation
extends DeleteProductionSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DeleteProductionSetOperation.class);
    private transient String stageName;
    private transient String stageDeleting;
    private transient int productionSetsToProcess;
    private transient int productionSetsProcessed;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.addExecutionLog(this.iu.getFormattedString("DeleteProductionSetOperation.Log.ProductionSets", (Object)this.getJoinedProductionSetNames(true)));
                this.addExecutionLog(this.iu.getFormattedString("DeleteProductionSetOperation.Log.ProductionSetState", (Object)this.productionSetState));
                this.stageName = this.iu.getString("DeleteProductionSetOperation.Stage.DeletingProductionSets");
                this.productionSetsProcessed = 0;
                int productionSetCountBefore = this.executionContext.nuixCase.getProductionSets().size();
                if (this.productionSetsToDelete == ToInclude.ALL) {
                    List productionSets = this.executionContext.nuixCase.getProductionSets();
                    this.productionSetsToProcess = productionSets.size();
                    Iterator iterator = productionSets.iterator();
                    while (iterator.hasNext()) {
                        ProductionSet productionSet = (ProductionSet)iterator.next();
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        this.deleteProductionSet(productionSet);
                        ++this.productionSetsProcessed;
                    }
                } else {
                    this.productionSetsToProcess = this.productionSetNames.size();
                    for (Object[] productionSetName : this.productionSetNames) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        String name = (String)productionSetName[0];
                        if ((name = this.executionContext.evalParameters(name, this)).trim().length() > 0) {
                            ProductionSet productionSet = this.executionContext.nuixCase.findProductionSetByName(name);
                            if (productionSet != null) {
                                this.deleteProductionSet(productionSet);
                            } else {
                                this.addWarning(this.iu.getFormattedString("DeleteProductionSetOperation.Warning.CouldNotFindProductionSetWithName", (Object)name));
                            }
                        }
                        ++this.productionSetsProcessed;
                    }
                }
                int productionSetCountAfter = this.executionContext.nuixCase.getProductionSets().size();
                int productionSetsDeleted = productionSetCountBefore - productionSetCountAfter;
                this.addExecutionLog(this.iu.getNumeralString("DeleteProductionSetOperation.Log.DeletedProductionSets", (long)productionSetsDeleted));
                this.trackFinished();
            }
            catch (IOException e) {
                LOGGER.error("Error finding Production Set by name", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void deleteProductionSet(ProductionSet productionSet) {
        this.stageDeleting = productionSet.getName();
        boolean toDelete = false;
        switch (this.productionSetState) {
            case FROZEN: {
                if (!productionSet.isFrozen()) break;
                toDelete = true;
                break;
            }
            case UNFROZEN: {
                if (productionSet.isFrozen()) break;
                toDelete = true;
                break;
            }
            case FROZEN_AND_UNFROZEN: {
                toDelete = true;
                break;
            }
        }
        if (toDelete) {
            productionSet.delete();
            this.addExecutionLog(this.iu.getFormattedString("DeleteProductionSetOperation.Log.DeletedProductionSet", (Object)productionSet.getName()));
        }
    }

    private String getJoinedProductionSetNames(boolean evalParameters) {
        ArrayList<String> names = new ArrayList<String>();
        for (Object[] productionSetName : this.productionSetNames) {
            String name = (String)productionSetName[0];
            if (evalParameters) {
                try {
                    name = this.executionContext.evalParameters(name, this);
                }
                catch (ParameterException e) {
                    LOGGER.error("Error evaluating parameter", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
            }
            if (name.trim().length() <= 0) continue;
            names.add(name);
        }
        return this.productionSetsToDelete == ToInclude.ALL ? "All" : String.join((CharSequence)"; ", names);
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.productionSetsToProcess > 0) {
            percentageComplete = (double)this.productionSetsProcessed / (double)this.productionSetsToProcess;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        double percentageComplete = this.getNormalizedPercentageComplete();
        Object result = String.format("%.2f%%", percentageComplete * 100.0);
        if (this.stageName != null) {
            result = (String)result + " / " + FormattingUtils.stageToString((String)this.stageName);
            if (this.stageDeleting != null) {
                result = (String)result + " / " + FormattingUtils.stageToString((String)this.stageDeleting);
            }
        }
        return result;
    }
}

