/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.models.internal.formbuilder.SensitiveField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureEccConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.EccOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRadioButtonGroup(name="useComputersFileRadioButtonGroup", radioButton="useComputerNamesFile", values={@RadioButtonValue(value="true", component="computerNamesFileLocation"), @RadioButtonValue(value="false", component="computerNames")})
@FormFieldRow(name="retryCommandRow", children={"retryRunningCommandIfFails", "retryCount"})
@FormFieldGroup(name="deploymentSettingsGroup", children={"username", "password", "installCommand", "retryCommandRow", "timeout"})
@OperationMetadata(alias=OperationAlias.DEPLOY_ECC_AGENTS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"ECC"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@OperationParameters(value={@OperationParameter(label="computerIds", parameter="{ecc_deployed_computer_ids}"), @OperationParameter(label="computerNames", parameter="{ecc_deployed_computer_names}"), @OperationParameter(label="failedComputerNames", parameter="{ecc_failed_computer_names}")})
public class DeployEccAgentsOperation
extends EccOperation {
    @FormField
    public boolean useComputerNamesFile;
    @FormField(enableOn={@OnField(name="useComputerNamesFile", value={"false"})})
    @ExcludeFromPrintableOptions
    public List<String> computerNames;
    @FormField(enableOn={@OnField(name="useComputerNamesFile")})
    public String computerNamesFileLocation;
    @FormField(required=false)
    public String username;
    @FormField(required=false)
    @SensitiveField
    @ExcludeFromPrintableOptions
    public String password;
    @FormField
    public String installCommand;
    @FormField
    public boolean retryRunningCommandIfFails;
    @FormField(enableOn={@OnField(name="retryRunningCommandIfFails")}, positionLabel=@PositionLabel(right="times"))
    public Integer retryCount;
    @FormField(positionLabel=@PositionLabel(right="minutes"))
    public Integer timeout;

    public boolean getDisplayComputerNames() {
        return !this.useComputerNamesFile;
    }

    public boolean getDisplayComputerNamesFileLocation() {
        return this.useComputerNamesFile;
    }

    public DeployEccAgentsOperation() {
        this.requiresCase = false;
        this.username = "";
        this.password = "";
        this.useComputerNamesFile = false;
        this.computerNamesFileLocation = "";
        this.installCommand = "winrs /r:{computer_name} /u:{username} /p:{password} \"msiexec.exe /i PATH_TO_INSTALLER /q /norestart\"";
        this.retryRunningCommandIfFails = true;
        this.retryCount = 5;
        this.timeout = 2;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("DeployEccAgentsOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureEccConnectionOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureEccConnectionOperation) {
                detectedConfigureEccConnectionOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureEccConnectionOperation) {
            prerequisites.add(this.iu.getString("EccOperation.Prerequisites.MissingEccConnection"));
        }
        if (!(this.useComputerNamesFile || this.computerNames != null && this.computerNames.size() != 0)) {
            prerequisites.add(this.iu.getString("DeployEccAgentsOperation.Prerequisites.MissingComputerNames"));
        }
        if (this.useComputerNamesFile && (this.computerNamesFileLocation == null || this.computerNamesFileLocation.trim().equals(""))) {
            prerequisites.add(this.iu.getString("DeployEccAgentsOperation.Prerequisites.MissingComputerNamesFile"));
        }
        if (this.installCommand == null || this.installCommand.trim().equals("")) {
            prerequisites.add(this.iu.getString("DeployEccAgentsOperation.Prerequisites.MissingInstallCommand"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

