/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.internal.EccRemoteCommand;
import com.nuix.automate.utils.ecc.internal.EccRemoteCommandType;
import com.nuix.automate.utils.ecc.internal.EccUtils;
import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.ecc.responses.computers.Presence;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.DeployEccAgentsOperation;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public class DeployEccAgentsOperationImplementation
extends DeployEccAgentsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DeployEccAgentsOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient long agentsSkipped;
    private transient AtomicLong agentsDeployed;
    private transient AtomicLong agentsFailedToDeploy;
    private transient ConcurrentHashMap<String, Computer> computers;
    private transient ExecutorService threadPool;
    private transient ConcurrentHashMap<String, Future<Boolean>> deployFutures;
    private transient Map<String, Integer> retryCountMap;
    private transient EccUtils utils;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("DeployEccAgentsOperation.Stage.PreparingForDeployment");
                this.utils = EccUtils.getInstance();
                this.initializeEccClient();
                HashMap<String, String> deployedComputersMap = new HashMap<String, String>();
                HashSet<String> deployComputerFailedList = new HashSet<String>();
                this.username = this.executionContext.evalParameters(this.username, this);
                this.password = this.executionContext.evalProtectedParameter(this.password);
                this.installCommand = this.executionContext.evalParameters(this.installCommand, this);
                if (this.useComputerNamesFile) {
                    this.computerNamesFileLocation = this.executionContext.evalParameters(this.computerNamesFileLocation, this);
                    Path path = Paths.get(this.computerNamesFileLocation, new String[0]);
                    this.addExecutionLog(this.iu.getFormattedString("DeployEccAgentsOperation.Log.ComputerNamesFileLocation", (Object)path.toFile().getAbsolutePath()));
                    this.computerNames = new ArrayList();
                    List names = FileUtils.loadVariableColumnDetectFormatFile((File)path.toFile());
                    Iterator iterator = names.iterator();
                    while (iterator.hasNext()) {
                        Object[] name = (Object[])iterator.next();
                        this.computerNames.add(name[0].toString());
                    }
                }
                ArrayList<String> evaluatedComputerNames = new ArrayList<String>();
                for (String computerName : this.computerNames) {
                    List<String> evaluatedComputerName = this.executionContext.evalOneOrManyStringParameter(computerName, this);
                    evaluatedComputerNames.addAll(evaluatedComputerName);
                }
                int totalComputers = evaluatedComputerNames.size();
                this.percentageComplete = 0.1;
                this.stageName = this.iu.getString("DeployEccAgentsOperation.Stage.DeployingAgents");
                this.addExecutionLog(this.iu.getFormattedString("DeployEccAgentsOperation.Log.ComputerDeploymentCount", (Object)totalComputers));
                this.agentsFailedToDeploy = new AtomicLong(0L);
                this.agentsDeployed = new AtomicLong(0L);
                this.agentsSkipped = 0L;
                this.computers = new ConcurrentHashMap();
                this.threadPool = Executors.newFixedThreadPool(10);
                this.deployFutures = new ConcurrentHashMap();
                this.retryCountMap = new HashMap<String, Integer>();
                this.updateCachedComputersMap(evaluatedComputerNames, this.computers);
                HashSet<Presence> presences = new HashSet<Presence>();
                presences.add(Presence.ONLINE);
                HashMap<String, EccRemoteCommand> remoteCommands = new HashMap<String, EccRemoteCommand>();
                for (String string : evaluatedComputerNames) {
                    boolean computerExists = this.computerExistsWithPresence(this.computers, string, Presence.ONLINE);
                    if (computerExists) {
                        ++this.agentsSkipped;
                        deployedComputersMap.put(string, this.resolveComputerId(string, this.computers));
                        this.addExecutionLog(this.iu.getFormattedString("DeployEccAgentsOperation.Log.ExistingComputer", (Object)string));
                        continue;
                    }
                    EccRemoteCommand remoteCommand = new EccRemoteCommand(string, this.timeout, this.computers, EccRemoteCommandType.DEPLOYING_AGENT, this.installCommand, presences, this.username, this.password);
                    remoteCommands.put(string, remoteCommand);
                    this.deployFutures.put(string, this.threadPool.submit(remoteCommand));
                    if (!this.retryRunningCommandIfFails) continue;
                    this.retryCountMap.put(string, 0);
                }
                while (this.deployFutures.size() != 0) {
                    boolean computersMapUpdated = this.updateCachedComputersMap(evaluatedComputerNames, this.computers);
                    if (computersMapUpdated) {
                        for (EccRemoteCommand remoteCommand : remoteCommands.values()) {
                            remoteCommand.setComputersMap(this.computers);
                        }
                    }
                    for (Map.Entry<String, Future<Boolean>> entry : this.deployFutures.entrySet()) {
                        String name = entry.getKey();
                        Future<Boolean> status = entry.getValue();
                        if (status.isDone()) {
                            Boolean result = status.get();
                            this.deployFutures.remove(name);
                            if (!result.booleanValue()) {
                                if (this.retryRunningCommandIfFails) {
                                    int currentRetryCount = this.retryCountMap.get(name) + 1;
                                    if (currentRetryCount < this.retryCount) {
                                        LOGGER.warn("Failed to run command on computer " + name + ", retry (" + currentRetryCount + " of " + this.retryCount + ")");
                                        remoteCommands.remove(name);
                                        this.retryCountMap.put(name, currentRetryCount);
                                        EccRemoteCommand remoteCommand = new EccRemoteCommand(name, this.timeout, this.computers, EccRemoteCommandType.DEPLOYING_AGENT, this.installCommand, presences, this.username, this.password);
                                        remoteCommands.put(name, remoteCommand);
                                        this.deployFutures.put(name, this.threadPool.submit(remoteCommand));
                                        continue;
                                    }
                                    this.agentsFailedToDeploy.incrementAndGet();
                                    this.addWarning(this.iu.getFormattedString("DeployEccAgentsOperation.Warning.FailedToDeployOn", new Object[]{name, ((EccRemoteCommand)remoteCommands.get(name)).getOutputLog().getAbsolutePath()}));
                                    deployComputerFailedList.add(name);
                                    continue;
                                }
                                this.agentsFailedToDeploy.incrementAndGet();
                                this.addWarning(this.iu.getFormattedString("DeployEccAgentsOperation.Warning.FailedToDeployOn", new Object[]{name, ((EccRemoteCommand)remoteCommands.get(name)).getOutputLog().getAbsolutePath()}));
                                deployComputerFailedList.add(name);
                                continue;
                            }
                            this.agentsDeployed.incrementAndGet();
                            remoteCommands.remove(name);
                            deployedComputersMap.put(name, this.resolveComputerId(name, this.computers));
                        }
                        int totalAgentsFinished = this.agentsDeployed.intValue() + this.agentsFailedToDeploy.intValue();
                        this.percentageComplete = 0.1 + (double)totalAgentsFinished / (double)totalComputers * 0.9;
                    }
                    if (this.stopRequested) {
                        for (EccRemoteCommand remoteCommand : remoteCommands.values()) {
                            remoteCommand.setStopRequested(true);
                        }
                        this.threadPool.shutdownNow();
                        throw new WorkflowExecutionStopRequested();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.error("Sleep interrupted");
                        break;
                    }
                }
                if (this.agentsDeployed.get() > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("DeployEccAgentsOperation.Log.AgentsDeployed", this.agentsDeployed.get()));
                }
                if (this.agentsSkipped > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("DeployEccAgentsOperation.Log.SkippedDeployment", this.agentsSkipped));
                }
                if (this.agentsFailedToDeploy.get() > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("DeployEccAgentsOperation.Warning.FailedAgents", this.agentsFailedToDeploy.get()));
                }
                this.concatenateToCollectionJson("{ecc_deployed_computer_ids}", deployedComputersMap.values());
                this.concatenateToCollectionJson("{ecc_deployed_computer_names}", deployedComputersMap.keySet());
                this.concatenateToCollectionJson("{ecc_failed_computer_names}", deployComputerFailedList);
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

