/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.DigestListExportOperation;
import com.nuix.automate.workflow.core.utils.digestlist.DigestHelper;
import java.io.IOException;

public class DigestListExportOperationImplementation
extends DigestListExportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DigestListExportOperation.class);
    private transient DigestHelper digestHelper;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.digestHelper = new DigestHelper(this.executionContext.nuixCase);
                this.digestListName = this.executionContext.evalParameters(this.digestListName, this);
                this.exportLocation = this.executionContext.evalParameters(this.exportLocation, this);
                this.addExecutionLog(this.iu.getFormattedString("DigestListExportOperation.Log.DigestListName", (Object)this.digestListName));
                this.addExecutionLog(this.iu.getFormattedString("DigestListExportOperation.Log.ExportLocation", (Object)this.exportLocation));
                this.stageName = this.iu.getString("DigestListExportOperation.Stage.ExportingDigestList");
                this.digestHelper.exportDigestList(this.digestListName, this.exportLocation, this.overwriteIfExists);
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.addExecutionLog(this.iu.getNumeralString("DigestListExportOperation.Log.DigestListSize", this.digestHelper.getItemsProcessed()));
                this.trackFinished();
            }
            catch (ParameterException e) {
                LOGGER.error("Error evaluating parameters", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (IOException | IllegalArgumentException e) {
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected void stopTriggered() {
        this.digestHelper.requestStop();
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        long itemsProcessed = 0L;
        if (this.digestHelper != null) {
            itemsProcessed = this.digestHelper.getItemsProcessed();
        }
        if (itemsProcessed > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("DigestListExportOperation.Progress.ItemsProcessed", itemsProcessed);
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.digestHelper != null) {
            percentageComplete = this.digestHelper.getExecutionProgress();
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }
}

