/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.utils.digestlist.DigestLocation;
import java.util.List;

@OperationMetadata(alias=OperationAlias.DIGEST_LIST_IMPORT, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"CULLING"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class DigestListImportOperation
extends Operation {
    @FormField
    public String importFromLocation = "";
    @FormField
    public String digestListName = "";
    @FormField
    public DigestLocation importToLocation = DigestLocation.CASE;
    @FormField
    public boolean overwriteIfExists = false;

    @Override
    public String getOperationName() {
        return this.iu.getString("DigestListImportOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.DIGEST_LIST_IMPORT;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.digestListName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("DigestListImportOperation.Prerequisites.DigestListNameMustBeSpecified"));
        }
        if (this.importFromLocation.trim().length() == 0) {
            prerequisites.add(this.iu.getString("DigestListImportOperation.Prerequisites.FileToImportMD5HashesMustBeSpecified"));
        }
        if (this.importToLocation == DigestLocation.LOCAL_COMPUTER && !System.getProperty("os.name").contains("Windows")) {
            prerequisites.add(this.iu.getFormattedString("DigestListImportOperation.Prerequisites.LocationNotSupported", (Object)DigestLocation.LOCAL_COMPUTER));
        }
        this.requiresCase = this.importToLocation == DigestLocation.CASE;
        return prerequisites;
    }
}

