/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.DiscoverRetrieveMetadataOperation;
import com.nuix.automate.workflow.core.execution.options.discover.DiscoverItemSourceType;
import com.nuix.automate.workflow.core.execution.options.discover.DiscoverMatchSource;
import com.nuix.automate.workflow.core.utils.discover.DiscoverRestException;
import com.nuix.automate.workflow.core.utils.discover.responses.DiscoverDocument;
import com.nuix.automate.workflow.core.utils.discover.responses.DiscoverDocumentField;
import com.nuix.automate.workflow.core.utils.discover.responses.DiscoverObject;
import com.nuix.automate.workflow.core.utils.discover.responses.DocumentSearchResultsResponse;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.ProductionSetItem;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class DiscoverRetrieveMetadataOperationImplementation
extends DiscoverRetrieveMetadataOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DiscoverRetrieveMetadataOperation.class);
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;
    private transient AtomicLong countItemsReceived;
    private transient Set<String> numericFieldNames;
    private transient Set<String> evaluatedDiscoverFields;
    private transient Path discoverExportCsvLocation;
    private transient Map<String, Integer> exportCsvColumnMapping;
    private transient int stageCount;
    private transient int stageId;
    private transient int discoverCaseId;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                long nuixItemsWithoutMatchCount;
                String discoverMatchingSourceIdentifier;
                ConcurrentHashMap.KeySetView discoverInternalDocumentIds;
                AtomicLong discoverItemsWithoutFieldCount = new AtomicLong(0L);
                AtomicLong discoverItemsWithNoMatchingFieldCount = new AtomicLong(0L);
                AtomicLong discoverItemsWithMatchingFieldCount = new AtomicLong(0L);
                AtomicLong failedNuixItems = new AtomicLong(0L);
                AtomicLong matchedItemsCount = new AtomicLong(0L);
                ConcurrentHashMap.KeySetView matchedFields = ConcurrentHashMap.newKeySet();
                ConcurrentHashMap<String, AtomicLong> taggedItemsCounts = new ConcurrentHashMap<String, AtomicLong>();
                this.numericFieldNames = ConcurrentHashMap.newKeySet();
                this.evaluatedDiscoverFields = new HashSet<String>();
                this.stageCount = 3;
                if (this.tagSavedSearchesInNuix) {
                    ++this.stageCount;
                }
                if (this.tagProductionsInNuix) {
                    ++this.stageCount;
                }
                if (this.tagBindersInNuix) {
                    ++this.stageCount;
                }
                ++this.stageId;
                this.stageName = this.iu.getString("DiscoverRetrieveMetadataOperation.Stage.QueryingDiscoverFields");
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.discoverItemSourceIdentifier = this.executionContext.evalParameters(this.discoverItemSourceIdentifier, this);
                this.discoverNamedFieldMatchSourceIdentifier = this.executionContext.evalParameters(this.discoverNamedFieldMatchSourceIdentifier, this);
                this.nuixTagMatchingItems = this.executionContext.evalParameters(this.nuixTagMatchingItems, this);
                this.exportCsvLocation = this.executionContext.evalParameters(this.exportCsvLocation, this);
                this.discoverCaseId = Integer.parseInt(this.executionContext.evalParameters("{discover_case_id}", this));
                this.initializeDiscoverClient();
                this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.DiscoverScope", (Object)this.discoverItemSourceType.toString()));
                String itemSourceIdentifier = "";
                if (this.discoverItemSourceType != DiscoverItemSourceType.ALL_ITEMS) {
                    switch (this.discoverItemSourceType) {
                        case SAVED_SEARCH: {
                            itemSourceIdentifier = this.discoverRestClient.getSavedSearch(this.discoverCaseId, this.discoverItemSourceIdentifierType, this.discoverItemSourceIdentifier);
                            break;
                        }
                        case PRODUCTION: {
                            itemSourceIdentifier = this.discoverRestClient.getProduction(this.discoverCaseId, this.discoverItemSourceIdentifierType, this.discoverItemSourceIdentifier);
                            break;
                        }
                        case BINDER: {
                            itemSourceIdentifier = this.discoverRestClient.getBinder(this.discoverCaseId, this.discoverItemSourceIdentifierType, this.discoverItemSourceIdentifier);
                        }
                    }
                    this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.DiscoverScopeIdentifierName", new Object[]{this.discoverItemSourceType.toString(), itemSourceIdentifier}));
                }
                if (this.useDiscoverFieldsFile) {
                    if (this.discoverFieldsFile == null) {
                        this.discoverFieldsFile = "";
                    }
                    this.discoverFieldsFile = this.executionContext.evalParameters(this.discoverFieldsFile, this);
                    List rows = FileUtils.loadVariableColumnTsv((File)new File(this.discoverFieldsFile));
                    Iterator iterator2 = rows.iterator();
                    while (iterator2.hasNext()) {
                        Object[] row = (Object[])iterator2.next();
                        this.discoverFields.add(row[0].toString());
                    }
                    this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.DiscoverFieldsFile", (Object)this.discoverFieldsFile));
                }
                for (String field : this.discoverFields) {
                    String fieldName = this.executionContext.evalParameters(field, this);
                    this.evaluatedDiscoverFields.add(fieldName);
                }
                if (this.discoverMatchSource == DiscoverMatchSource.NAMED_FIELD && !this.evaluatedDiscoverFields.contains(this.discoverNamedFieldMatchSourceIdentifier)) {
                    LOGGER.info("Adding discover named field identifier to list of fields");
                    this.evaluatedDiscoverFields.add(this.discoverNamedFieldMatchSourceIdentifier);
                    this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.AddedDiscoverMatchSourceField", (Object)this.discoverNamedFieldMatchSourceIdentifier));
                }
                if (this.exportCsv) {
                    if (this.exportCsvLocation == null) {
                        this.exportCsvLocation = "";
                    }
                    this.discoverExportCsvLocation = Paths.get(this.exportCsvLocation, new String[0]);
                    this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.ExportCsvLocation", (Object)this.discoverExportCsvLocation.toFile().getAbsolutePath()));
                    int columnId = 0;
                    StringBuilder header = new StringBuilder();
                    this.exportCsvColumnMapping = new HashMap<String, Integer>();
                    String firstColumnIdentifier = "";
                    firstColumnIdentifier = this.discoverMatchSource == DiscoverMatchSource.DOCUMENT_ID ? "Document ID" : this.discoverNamedFieldMatchSourceIdentifier;
                    this.exportCsvColumnMapping.put(firstColumnIdentifier, columnId);
                    header.append(FormattingUtils.encodeForCsv((String)firstColumnIdentifier));
                    ++columnId;
                    for (String string : this.evaluatedDiscoverFields) {
                        if (string.equals(firstColumnIdentifier)) continue;
                        header.append(", ");
                        header.append(FormattingUtils.encodeForCsv((String)string));
                        this.exportCsvColumnMapping.putIfAbsent(string, columnId);
                        ++columnId;
                    }
                    if (!Files.exists(this.discoverExportCsvLocation.getParent(), new LinkOption[0])) {
                        Files.createDirectories(this.discoverExportCsvLocation.getParent(), new FileAttribute[0]);
                    }
                    if (!Files.exists(this.discoverExportCsvLocation, new LinkOption[0])) {
                        Files.createFile(this.discoverExportCsvLocation, new FileAttribute[0]);
                    }
                    FileUtils.writeToFile((StringBuilder)header, (Path)this.discoverExportCsvLocation);
                }
                ConcurrentHashMap savedSearches = new ConcurrentHashMap();
                ConcurrentHashMap productions = new ConcurrentHashMap();
                ConcurrentHashMap binders = new ConcurrentHashMap();
                this.countItemsProcessed = new AtomicLong(0L);
                if (this.tagSavedSearchesInNuix) {
                    ++this.stageId;
                    this.stageName = this.iu.getString("DiscoverRetrieveMetadataOperation.Stage.RetrievingSavedSearches");
                    List<DiscoverObject> discoverSavedSearches = this.discoverRestClient.getSavedSearches(this.discoverCaseId);
                    this.countItemsToProcess = discoverSavedSearches.size();
                    for (DiscoverObject discoverObject : discoverSavedSearches) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        discoverInternalDocumentIds = ConcurrentHashMap.newKeySet();
                        this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.SavedSearch", (Object)discoverObject.getName()));
                        try {
                            this.queryDocumentIds(DiscoverItemSourceType.SAVED_SEARCH, discoverObject, discoverInternalDocumentIds);
                            savedSearches.put(discoverObject.getName(), discoverInternalDocumentIds);
                        }
                        catch (DiscoverRestException e) {
                            LOGGER.error("Failed to retrieve document ids for saved search " + discoverObject.getName(), (Throwable)e);
                            this.addWarning(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.ExistsButNoPermissionSavedSearch", (Object)discoverObject.getName()));
                        }
                        this.countItemsProcessed.incrementAndGet();
                    }
                    this.countItemsToProcess = 0L;
                    this.countItemsProcessed.set(0L);
                }
                if (this.tagProductionsInNuix) {
                    ++this.stageId;
                    this.stageName = this.iu.getString("DiscoverRetrieveMetadataOperation.Stage.RetrievingProductions");
                    List<DiscoverObject> discoverProductions = this.discoverRestClient.getProductions(this.discoverCaseId);
                    this.countItemsToProcess = discoverProductions.size();
                    for (DiscoverObject discoverObject : discoverProductions) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        discoverInternalDocumentIds = ConcurrentHashMap.newKeySet();
                        this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.Production", (Object)discoverObject.getName()));
                        try {
                            this.queryDocumentIds(DiscoverItemSourceType.PRODUCTION, discoverObject, discoverInternalDocumentIds);
                            productions.put(discoverObject.getName(), discoverInternalDocumentIds);
                        }
                        catch (DiscoverRestException e) {
                            LOGGER.error("Failed to retrieve document ids for production " + discoverObject.getName(), (Throwable)e);
                            this.addWarning(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.ExistsButNoPermissionProduction", (Object)discoverObject.getName()));
                        }
                    }
                    this.countItemsToProcess = 0L;
                    this.countItemsProcessed.set(0L);
                }
                if (this.tagBindersInNuix) {
                    ++this.stageId;
                    this.stageName = this.iu.getString("DiscoverRetrieveMetadataOperation.Stage.RetrievingBinders");
                    List<DiscoverObject> discoverBinders = this.discoverRestClient.getBinders(this.discoverCaseId);
                    this.countItemsToProcess = discoverBinders.size();
                    for (DiscoverObject discoverObject : discoverBinders) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        discoverInternalDocumentIds = ConcurrentHashMap.newKeySet();
                        this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.Binder", (Object)discoverObject.getName()));
                        try {
                            this.queryDocumentIds(DiscoverItemSourceType.BINDER, discoverObject, discoverInternalDocumentIds);
                            binders.put(discoverObject.getName(), discoverInternalDocumentIds);
                        }
                        catch (DiscoverRestException e) {
                            LOGGER.error("Failed to retrieve document ids for binder " + discoverObject.getName(), (Throwable)e);
                            this.addWarning(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.ExistsButNoPermissionBinder", (Object)discoverObject.getName()));
                        }
                    }
                    this.countItemsToProcess = 0L;
                    this.countItemsProcessed.set(0L);
                }
                this.stageName = this.iu.getString("DiscoverRetrieveMetadataOperation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Log.Scope", (Object)this.scope));
                LOGGER.info("Searching for items to update: " + this.scope);
                Set itemsToUpdate = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.countItemsToProcess = itemsToUpdate.size();
                LOGGER.info("Got " + this.countItemsToProcess + " items");
                this.addExecutionLog(this.iu.getNumeralString("DiscoverRetrieveMetadataOperation.Log.ScopeCount", this.countItemsToProcess));
                HashMap<String, Item> hashMap = new HashMap<String, Item>();
                for (Item item : itemsToUpdate) {
                    if (this.nuixMatchSource == DiscoverMatchSource.GUID) {
                        hashMap.put(item.getGuid(), item);
                    } else if (this.nuixMatchSource == DiscoverMatchSource.DOCUMENT_ID) {
                        Set productionSetItems = item.getProductionSetItems();
                        for (ProductionSetItem productionSetItem : productionSetItems) {
                            String key = productionSetItem.getDocumentNumber().toString();
                            if (!productionSetItem.getItem().getGuid().equals(item.getGuid())) continue;
                            hashMap.put(key, item);
                            break;
                        }
                    }
                    this.countItemsProcessed.incrementAndGet();
                }
                this.countItemsReceived = new AtomicLong(0L);
                this.countItemsProcessed.set(0L);
                this.countItemsToProcess = 0L;
                ++this.stageId;
                boolean bl = false;
                this.stageName = this.iu.getString("DiscoverRetrieveMetadataOperation.Stage.RetrievingMetadata");
                int searchRunId = this.discoverRestClient.getDocumentQuerySearchRunId(this.discoverCaseId, this.discoverItemSourceType, itemSourceIdentifier);
                while (true) {
                    void var14_31;
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    DocumentSearchResultsResponse response = this.discoverRestClient.queryDocumentsResponse(this.discoverCaseId, searchRunId, 1000, (int)var14_31, this.evaluatedDiscoverFields);
                    List<DiscoverDocument> responseDocuments = response.getData().getCases().get(0).getSearchResults().get(0).getDocuments();
                    int documentsCount = response.getData().getCases().get(0).getSearchResults().get(0).getCount();
                    if (this.countItemsToProcess == 0L) {
                        this.addExecutionLog(this.iu.getNumeralString("DiscoverRetrieveMetadataOperation.Log.DiscoverScopeCount", (long)documentsCount));
                    }
                    this.countItemsToProcess = documentsCount;
                    FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(responseDocuments, ItemsUtils.getPartitionerChunkSize(100, this));
                    ConcurrentHashMap.KeySetView matchedItems = ConcurrentHashMap.newKeySet();
                    ConcurrentHashMap matchedItemsTags = new ConcurrentHashMap();
                    try {
                        Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            while (iterator.hasNext()) {
                                boolean itemFailed = false;
                                this.countItemsProcessed.incrementAndGet();
                                String discoverIdentifier = null;
                                String nuixGuid = "";
                                try {
                                    ConcurrentLinkedQueue<Object> existingItemsList;
                                    ConcurrentLinkedQueue itemsList;
                                    String tagNameValue;
                                    Object tagPrefix;
                                    DiscoverDocument discoverDocument = (DiscoverDocument)iterator.next();
                                    int discoverInternalId = discoverDocument.getId();
                                    List<DiscoverDocumentField> fields = discoverDocument.getFields();
                                    if (this.discoverMatchSource == DiscoverMatchSource.DOCUMENT_ID) {
                                        discoverIdentifier = discoverDocument.getDocumentId();
                                    } else if (this.discoverMatchSource == DiscoverMatchSource.NAMED_FIELD) {
                                        for (DiscoverDocumentField field : fields) {
                                            if (!field.getName().equals(this.discoverNamedFieldMatchSourceIdentifier)) continue;
                                            discoverIdentifier = field.getValues().get(0).getValue();
                                            break;
                                        }
                                    }
                                    if (this.exportCsv) {
                                        this.writeCsvRow(discoverDocument);
                                    }
                                    if (discoverIdentifier == null) {
                                        discoverItemsWithoutFieldCount.incrementAndGet();
                                        continue;
                                    }
                                    Item nuixItem = (Item)nuixItems.get(discoverIdentifier);
                                    if (nuixItem == null) {
                                        discoverItemsWithNoMatchingFieldCount.incrementAndGet();
                                        LOGGER.warn("Cannot match Discover identifier " + discoverIdentifier + " to a Nuix item in scope");
                                        continue;
                                    }
                                    matchedItemsCount.incrementAndGet();
                                    nuixGuid = nuixItem.getGuid();
                                    discoverItemsWithMatchingFieldCount.incrementAndGet();
                                    if (this.exportFieldsToCustomMetadata) {
                                        try {
                                            ItemCustomMetadataMap itemCustomMetadata = nuixItem.getCustomMetadata();
                                            for (DiscoverDocumentField discoverDocumentField : fields) {
                                                String fieldName = discoverDocumentField.getName();
                                                String value = "";
                                                matchedFields.add(discoverDocumentField.getName());
                                                if (discoverDocumentField.getValues().get(0).getValue() != null) {
                                                    value = discoverDocumentField.getValues().get(0).getValue();
                                                }
                                                itemCustomMetadata.put((Object)fieldName, (Object)value);
                                            }
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Cannot handle Discover fields", (Throwable)e);
                                            itemFailed = true;
                                        }
                                    }
                                    if (this.tagMatchingItemsInNuix) {
                                        matchedItems.add(nuixItem);
                                    }
                                    if (this.tagSavedSearchesInNuix) {
                                        tagPrefix = this.savedSearchTagPrefix;
                                        if (!((String)tagPrefix).endsWith("|")) {
                                            tagPrefix = (String)tagPrefix + "|";
                                        }
                                        for (Map.Entry entry : savedSearches.entrySet()) {
                                            if (!((Set)entry.getValue()).contains(discoverInternalId)) continue;
                                            tagNameValue = (String)tagPrefix + (String)entry.getKey();
                                            existingItemsList = matchedItemsTags.putIfAbsent(tagNameValue, itemsList = new ConcurrentLinkedQueue());
                                            if (existingItemsList == null) {
                                                existingItemsList = itemsList;
                                            }
                                            existingItemsList.add(nuixItem);
                                        }
                                    }
                                    if (this.tagProductionsInNuix) {
                                        tagPrefix = this.productionsTagPrefix;
                                        if (!((String)tagPrefix).endsWith("|")) {
                                            tagPrefix = (String)tagPrefix + "|";
                                        }
                                        for (Map.Entry entry : productions.entrySet()) {
                                            if (!((Set)entry.getValue()).contains(discoverInternalId)) continue;
                                            tagNameValue = (String)tagPrefix + (String)entry.getKey();
                                            existingItemsList = matchedItemsTags.putIfAbsent(tagNameValue, itemsList = new ConcurrentLinkedQueue());
                                            if (existingItemsList == null) {
                                                existingItemsList = itemsList;
                                            }
                                            existingItemsList.add(nuixItem);
                                        }
                                    }
                                    if (this.tagBindersInNuix) {
                                        tagPrefix = this.binderTagPrefix;
                                        if (!((String)tagPrefix).endsWith("|")) {
                                            tagPrefix = (String)tagPrefix + "|";
                                        }
                                        for (Map.Entry entry : binders.entrySet()) {
                                            if (!((Set)entry.getValue()).contains(discoverInternalId)) continue;
                                            tagNameValue = (String)tagPrefix + (String)entry.getKey();
                                            existingItemsList = matchedItemsTags.putIfAbsent(tagNameValue, itemsList = new ConcurrentLinkedQueue());
                                            if (existingItemsList == null) {
                                                existingItemsList = itemsList;
                                            }
                                            existingItemsList.add(nuixItem);
                                        }
                                    }
                                    if (!itemFailed) continue;
                                    throw new Exception("Item encountered errors");
                                }
                                catch (Exception e) {
                                    failedNuixItems.incrementAndGet();
                                    LOGGER.error("Cannot handle item " + nuixGuid, (Throwable)e);
                                }
                            }
                        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                        LOGGER.info("Tagging " + matchedItems.size() + " matching items");
                        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.nuixTagMatchingItems, matchedItems);
                        if (this.tagMatchingItemsInNuix) {
                            for (String tagName : matchedItemsTags.keySet()) {
                                ConcurrentLinkedQueue items = (ConcurrentLinkedQueue)matchedItemsTags.get(tagName);
                                LOGGER.info("Tagging " + items.size() + " item(s) as " + tagName);
                                this.executionContext.nuixUtilities.getBulkAnnotater().addTag(tagName, (Collection)items);
                                AtomicLong taggedItemsCount = (AtomicLong)taggedItemsCounts.get(tagName);
                                if (taggedItemsCount == null) {
                                    taggedItemsCount = new AtomicLong(0L);
                                    taggedItemsCounts.put(tagName, taggedItemsCount);
                                }
                                taggedItemsCount.addAndGet(items.size());
                            }
                        }
                    }
                    catch (WorkflowExecutionStopRequested e) {
                        this.trackStopped();
                        return;
                    }
                    this.countItemsReceived.addAndGet(response.getData().getCases().get(0).getSearchResults().get(0).getDocuments().size());
                    if (this.countItemsReceived.get() >= (long)response.getData().getCases().get(0).getSearchResults().get(0).getCount()) break;
                    ++var14_31;
                }
                if (failedNuixItems.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("DiscoverRetrieveMetadataOperation.Error.FailedItems", failedNuixItems.get()));
                }
                String string = discoverMatchingSourceIdentifier = this.discoverMatchSource == DiscoverMatchSource.DOCUMENT_ID ? "Document ID" : this.discoverNamedFieldMatchSourceIdentifier;
                if (discoverItemsWithoutFieldCount.get() > 0L) {
                    this.addWarning(this.iu.getNumeralFormattedString("DiscoverRetrieveMetadataOperation.Error.DiscoverItemsWithNoField", discoverItemsWithoutFieldCount.get(), (Object)discoverMatchingSourceIdentifier));
                }
                if (discoverItemsWithNoMatchingFieldCount.get() > 0L) {
                    this.addWarning(this.iu.getNumeralFormattedString("DiscoverRetrieveMetadataOperation.Error.DiscoverItemsWithNoMatchingField", discoverItemsWithNoMatchingFieldCount.get(), (Object)discoverMatchingSourceIdentifier));
                }
                if ((nuixItemsWithoutMatchCount = (long)hashMap.size() - matchedItemsCount.get()) > 0L) {
                    this.addWarning(this.iu.getNumeralString("DiscoverRetrieveMetadataOperation.Error.NuixItemsNotMatched", nuixItemsWithoutMatchCount));
                }
                this.addExecutionLog(this.iu.getNumeralString("DiscoverRetrieveMetadataOperation.Log.MatchedItems", matchedItemsCount.get()));
                if (this.tagMatchingItemsInNuix) {
                    this.addExecutionLog(this.iu.getNumeralFormattedString("DiscoverRetrieveMetadataOperation.Log.TaggedMatchedItems", matchedItemsCount.get(), (Object)this.nuixTagMatchingItems));
                }
                if (this.tagSavedSearchesInNuix || this.tagProductionsInNuix || this.tagBindersInNuix) {
                    ArrayList tags = new ArrayList();
                    tags.addAll(taggedItemsCounts.keySet());
                    tags.sort(String::compareToIgnoreCase);
                    for (String tag : tags) {
                        this.addExecutionLog(this.iu.getNumeralFormattedString("DiscoverRetrieveMetadataOperation.Log.TaggedMatchedItems", ((AtomicLong)taggedItemsCounts.get(tag)).get(), (Object)tag));
                    }
                }
                if (this.exportFieldsToCustomMetadata) {
                    ArrayList matchedFieldsSorted = new ArrayList();
                    matchedFieldsSorted.addAll(matchedFields);
                    matchedFieldsSorted.sort(String::compareToIgnoreCase);
                    if (matchedFieldsSorted.size() > 0) {
                        this.addExecutionLog(this.iu.getFormattedString("DiscoverRetrieveMetadataOperation.Error.FieldsRetrieved", (Object)String.join((CharSequence)", ", matchedFieldsSorted)));
                    } else {
                        this.addExecutionLog(this.iu.getString("DiscoverRetrieveMetadataOperation.Error.NoFieldsRetrieved"));
                    }
                }
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private synchronized void writeCsvRow(DiscoverDocument document) {
        CharSequence[] row = new String[this.exportCsvColumnMapping.size()];
        if (this.discoverMatchSource == DiscoverMatchSource.DOCUMENT_ID) {
            row[0] = document.getDocumentId();
        }
        for (DiscoverDocumentField field : document.getFields()) {
            String fieldName = field.getName();
            int columnId = this.exportCsvColumnMapping.get(fieldName);
            String fieldValue = "";
            if (field.getValues().get(0).getValue() != null) {
                fieldValue = FormattingUtils.encodeForCsv((String)field.getValues().get(0).getValue());
            }
            if (row[columnId] != null) continue;
            row[columnId] = fieldValue;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.discoverExportCsvLocation, StandardOpenOption.CREATE, StandardOpenOption.APPEND), StandardCharsets.UTF_8);){
            writer.write("\n" + String.join((CharSequence)", ", row));
        }
        catch (IOException e) {
            LOGGER.error("Failed to write to export CSV file", (Throwable)e);
        }
    }

    private void queryDocumentIds(DiscoverItemSourceType itemSourceType, DiscoverObject itemSourceIdentifier, Set<Integer> discoverInternalDocumentIds) throws DiscoverRestException {
        int page = 0;
        int itemsReceived = 0;
        int searchRunId = this.discoverRestClient.getDocumentInternalIdSearchRunId(this.discoverCaseId, itemSourceType, itemSourceIdentifier.getName());
        while (true) {
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            DocumentSearchResultsResponse response = this.discoverRestClient.queryDocumentInternalId(this.discoverCaseId, searchRunId, 1000, page);
            List<DiscoverDocument> responseDocuments = response.getData().getCases().get(0).getSearchResults().get(0).getDocuments();
            for (DiscoverDocument document : responseDocuments) {
                discoverInternalDocumentIds.add(document.getId());
            }
            if ((itemsReceived += responseDocuments.size()) >= response.getData().getCases().get(0).getSearchResults().get(0).getCount()) break;
            ++page;
        }
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        double stagePercent = 0.0;
        if (this.countItemsToProcess > 0L) {
            stagePercent = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        if (this.stageCount > 0) {
            percentageComplete = ((double)this.stageId + stagePercent) / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
            if (this.countItemsToProcess > 0L && this.countItemsProcessed != null) {
                result = (String)result + " / ";
                result = (String)result + this.iu.getNumeralString("DiscoverRetrieveMetadataOperation.Progress.ItemsProcessed", this.countItemsProcessed.get());
            }
        }
        return result;
    }
}

