/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.SensitiveField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;

@FormFieldGroup(name="esConfigurationGroup", styled=false, children={"host", "port", "username", "password", "certificateFingerprint", "bulkOperationsCount"})
@OperationMetadata(alias=OperationAlias.ES_CONFIGURE, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"ELASTIC_SEARCH"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@OperationParameter(label="queryRetrieveElasticsearchVersion", parameter="{es_version}")
@OperationLicenseModule(module=ModuleType.ELASTICSEARCH)
public class ElasticSearchConfigureOperation
extends Operation {
    @FormField
    public String host;
    @FormField
    public int port;
    @FormField
    public String username;
    @FormField
    @ExcludeFromPrintableOptions
    @SensitiveField
    public String password;
    @FormField(required=false)
    @ExcludeFromPrintableOptions
    public String certificateFingerprint;
    @FormField
    public int bulkOperationsCount;

    public ElasticSearchConfigureOperation() {
        this.requiresCase = false;
        this.host = "127.0.0.1";
        this.port = 9200;
        this.username = "elastic";
        this.password = "{es_password}";
        this.certificateFingerprint = "";
        this.bulkOperationsCount = 128;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ElasticSearchConfigureOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.ES_CONFIGURE;
    }
}

