/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.InfoResponse;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.BrainspaceUseDatasetOperation;
import com.nuix.automate.workflow.core.execution.operations.ElasticSearchConfigureOperation;
import com.nuix.automate.workflow.core.utils.es.EsConfig;
import com.nuix.automate.workflow.core.utils.es.EsFactory;
import java.io.IOException;

public class ElasticSearchConfigureOperationImplementation
extends ElasticSearchConfigureOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BrainspaceUseDatasetOperation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = "";
                this.host = this.executionContext.evalParameters(this.host, this);
                this.username = this.executionContext.evalParameters(this.username, this);
                this.password = this.executionContext.evalProtectedParameter(this.password);
                this.certificateFingerprint = this.executionContext.evalParameters(this.certificateFingerprint, this);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_es_host}", this.host)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_es_port}", "" + this.port)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_es_username}", this.username)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_es_password}", this.password)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_es_certificateFingerprint}", this.certificateFingerprint)));
                if (this.bulkOperationsCount <= 0) {
                    this.bulkOperationsCount = Runtime.getRuntime().availableProcessors();
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_es_bulk_operations_count}", "" + this.bulkOperationsCount)));
                EsConfig esConfig = new EsConfig();
                esConfig.setHost(this.host);
                esConfig.setPort(this.port);
                esConfig.setUsername(this.username);
                esConfig.setPassword(this.password);
                esConfig.setCertFingerprint(this.certificateFingerprint);
                this.addExecutionLog(this.iu.getFormattedString("ElasticSearchConfigureOperation.Host", (Object)this.host));
                this.addExecutionLog(this.iu.getFormattedString("ElasticSearchConfigureOperation.Port", (Object)this.port));
                this.addExecutionLog(this.iu.getFormattedString("ElasticSearchConfigureOperation.Username", (Object)this.username));
                this.addExecutionLog(this.iu.getFormattedString("ElasticSearchConfigureOperation.BulkOperations", (Object)this.bulkOperationsCount));
                if (this.certificateFingerprint != null && this.certificateFingerprint.trim().length() > 0) {
                    this.addExecutionLog(this.iu.getFormattedString("ElasticSearchConfigureOperation.CertificateFingerprint", (Object)this.certificateFingerprint));
                }
                try {
                    LOGGER.info("Connecting to ElasticSearch");
                    ElasticsearchClient esClient = EsFactory.getEsClient(esConfig);
                    InfoResponse esInfo = esClient.info();
                    LOGGER.info("ElasticSearch version: " + esInfo.version().toString());
                    this.addExecutionLog(this.iu.getFormattedString("ElasticSearchConfigureOperation.Name", (Object)esInfo.name()));
                    this.addExecutionLog(this.iu.getFormattedString("ElasticSearchConfigureOperation.ClusterName", (Object)esInfo.clusterName()));
                    this.addExecutionLog(this.iu.getFormattedString("ElasticSearchConfigureOperation.Version", (Object)esInfo.version().number()));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{es_version}", esInfo.version().number())));
                }
                catch (IOException e) {
                    throw new IOException(this.iu.getFormattedString("ElasticSearchConfigureOperation.CannotConnect", (Object)e.getMessage()));
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }
}

