/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.ItemExportCallback;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import nuix.Item;
import nuix.MetadataItem;

public class ElasticSearchExportConsumerGenerator
implements Runnable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ElasticSearchExportConsumerGenerator.class);
    private BlockingDeque<Item> items;
    private Writer writer;
    private List<MetadataItem> metadata;
    private AtomicInteger itemsGeneratedMetadata;
    private boolean doneProducing = false;
    private boolean stopRequested = false;
    private Set<String> rubyFieldNames;
    private ItemExportCallback callback;
    private ElasticsearchClient esClient;
    private String index;
    private boolean exportText;
    private int maxTextSize;
    private BlockingDeque<Map<String, Object>> itemsMetadata;
    private int maxNumberOfPendingItems;

    public ElasticSearchExportConsumerGenerator(BlockingDeque<Item> items, BlockingDeque<Map<String, Object>> itemsMetadata, boolean exportText, int maxTextSize, List<MetadataItem> metadata, AtomicInteger itemsGeneratedMetadata, Set<String> rubyFieldNames, ItemExportCallback callback, int maxNumberOfPendingItems) {
        this.items = items;
        this.exportText = exportText;
        this.maxTextSize = maxTextSize;
        this.metadata = metadata;
        this.itemsGeneratedMetadata = itemsGeneratedMetadata;
        this.rubyFieldNames = rubyFieldNames;
        this.callback = callback;
        this.itemsMetadata = itemsMetadata;
        this.maxNumberOfPendingItems = maxNumberOfPendingItems;
    }

    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    public void run() {
        LOGGER.info("Starting consumer");
        try {
            while (!this.doneProducing || this.items.size() > 0) {
                if (this.stopRequested) {
                    return;
                }
                if (this.itemsMetadata.size() > this.maxNumberOfPendingItems) {
                    Thread.sleep(1L);
                    continue;
                }
                Item item = this.items.poll(1L, TimeUnit.SECONDS);
                if (item == null) continue;
                this.consume(item);
            }
        }
        catch (InterruptedIOException ex) {
            LOGGER.info("Metadata export thread interrupted", (Throwable)ex);
            return;
        }
        catch (IOException e) {
            LOGGER.error("Error writing metadata", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOGGER.info("Metadata export thread interrupted", (Throwable)e);
            return;
        }
        LOGGER.info("Exiting metadata export thread");
    }

    public void setDoneProducing() {
        this.doneProducing = true;
    }

    private Object convertToBaseType(Object metadataItemRepresentation, boolean root) {
        if (metadataItemRepresentation == null) {
            return metadataItemRepresentation;
        }
        if (metadataItemRepresentation instanceof Number || metadataItemRepresentation instanceof Integer || metadataItemRepresentation instanceof Long || metadataItemRepresentation instanceof Double || metadataItemRepresentation instanceof Boolean || metadataItemRepresentation instanceof String) {
            return metadataItemRepresentation;
        }
        if (metadataItemRepresentation instanceof Collection) {
            if (!root) {
                return metadataItemRepresentation.toString();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object sourceObject : (Collection)metadataItemRepresentation) {
                result.add(this.convertToBaseType(sourceObject, false));
            }
            return result;
        }
        if (metadataItemRepresentation instanceof Object[]) {
            if (!root) {
                return metadataItemRepresentation.toString();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object sourceObject : (Object[])metadataItemRepresentation) {
                result.add(this.convertToBaseType(sourceObject, false));
            }
            return result;
        }
        if (metadataItemRepresentation instanceof byte[]) {
            return FormattingUtils.encodeHexString((byte[])((byte[])metadataItemRepresentation));
        }
        return metadataItemRepresentation.toString();
    }

    void consume(Item item) throws IOException {
        HashMap<String, Object> document = new HashMap<String, Object>();
        for (MetadataItem metadataItem : this.metadata) {
            Object metadataItemRepresentation = null;
            try {
                metadataItemRepresentation = MetadataItemUtils.evaluateUnformatted(metadataItem, item, this.rubyFieldNames);
                metadataItemRepresentation = this.convertToBaseType(metadataItemRepresentation, true);
            }
            catch (Exception e) {
                metadataItemRepresentation = e.getMessage();
            }
            document.put(metadataItem.getName(), metadataItemRepresentation);
        }
        document.put("_id", item.getGuid());
        if (this.exportText) {
            StringBuilder itemText = new StringBuilder();
            boolean fullTextExtracted = ItemsUtils.copyItemText(item, itemText, (long)this.maxTextSize, "");
            document.put("_doc_text", itemText.toString());
            if (!fullTextExtracted) {
                document.put("_doc_text_trimmed", true);
            }
        }
        this.itemsMetadata.add(document);
        this.itemsGeneratedMetadata.incrementAndGet();
        this.callback.onItemProcessed(item, false);
    }
}

