/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ExportItemsOperation;
import com.nuix.automate.workflow.core.execution.options.exportitems.ExportPathType;
import com.nuix.automate.workflow.core.execution.options.exportitems.NamingType;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nuix.AddedWorkers;
import nuix.BatchExporter;
import nuix.BulkAnnotater;
import nuix.ExportProcessingJob;
import nuix.Item;
import nuix.ItemEventInfo;
import nuix.LicenceException;
import nuix.MetadataProfile;
import nuix.ParallelProcessingConfigurable;
import nuix.ProcessingJob;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;

public class ExportItemsOperationImplementation
extends ExportItemsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ExportItemsOperation.class);
    transient Map<String, Integer> stageNameToId;
    private transient ExportProcessingJob exportProcessingJob;
    private transient double partStartPercentage;
    private transient double partSizePercentage;
    private transient int exportPart;
    private transient long failedExportItemCount;
    private transient Set<Item> failedItems;
    private transient Set<Item> itemsToUntag;
    private transient long itemsInScopeCount;
    private transient List<AddedWorkers> addedWorkersList;
    private transient List<Item> itemsInScope;
    private transient int workersPendingCount;
    private transient boolean isPaused;
    private transient int exportItemsAt = 0;
    private transient Integer workerMemory = null;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);

    public List<Item> getItemsInScope() {
        if (this.itemsInScope != null) {
            return this.itemsInScope;
        }
        return new ArrayList<Item>();
    }

    private void exportItems(String exportFolder, String consolidateToFolder, List<Item> items) throws Exception {
        HashMap<String, String> productOptions;
        String effectiveLegalExportType = this.legalExportType.toNuixString();
        String effectiveLegalExportName = this.legalExportType.toString();
        BatchExporter batchExporter = this.executionContext.nuixUtilities.createBatchExporter(exportFolder);
        ConfigurationParser configurationParser = new ConfigurationParser();
        HashMap<String, Boolean> numberingOptions = new HashMap<String, Boolean>();
        numberingOptions.put("createProductionSet", false);
        batchExporter.setNumberingOptions(numberingOptions);
        ArrayList<String> stageNames = new ArrayList<String>();
        HashMap<String, String> commonProductOptions = new HashMap<String, String>();
        commonProductOptions.put("path", "Items");
        stageNames.add("work_queue");
        if (this.exportPathType == ExportPathType.SINGLE_DIRECTORY) {
            if (NamingType.ITEM_GUID.equals((Object)this.namingType)) {
                commonProductOptions.put("naming", "guid");
            } else {
                commonProductOptions.put("naming", "item_name");
            }
        } else {
            commonProductOptions.put("naming", "item_name_with_path");
        }
        if (this.exportFileTypeNative.booleanValue()) {
            productOptions = new HashMap<String, String>(commonProductOptions);
            productOptions.put("mailFormat", this.mailType.toNuixString());
            batchExporter.addProduct("native", productOptions);
            stageNames.add("native");
            stageNames.add("stored_email_fixup");
        }
        if (this.exportFileTypePdf.booleanValue()) {
            productOptions = new HashMap(commonProductOptions);
            batchExporter.addProduct("pdf", productOptions);
            stageNames.add("pdf");
        }
        stageNames.add("numbering");
        stageNames.add("binary_store");
        if (this.exportFileTypeThumbnail.booleanValue()) {
            productOptions = new HashMap(commonProductOptions);
            batchExporter.addProduct("thumbnail", productOptions);
            stageNames.add("thumbnails");
        }
        if (this.exportFileTypeText.booleanValue()) {
            productOptions = new HashMap(commonProductOptions);
            batchExporter.addProduct("text", productOptions);
            stageNames.add("text");
        }
        if (this.exportFileTypeImage.booleanValue()) {
            productOptions = new HashMap(commonProductOptions);
            batchExporter.addProduct("tiff", productOptions);
            stageNames.add("image");
        }
        stageNames.add("file_naming");
        stageNames.add("set_file_times");
        stageNames.add("digest");
        if (this.exportFileTypeXhtmlReport.booleanValue()) {
            productOptions = new HashMap(commonProductOptions);
            batchExporter.addProduct("xhtml_report", productOptions);
            stageNames.add("xhtml_reports");
        }
        if (this.exportFileTypeThumbnail.booleanValue()) {
            stageNames.add("thumbnail_report");
        }
        stageNames.add("load_files");
        this.stageNameToId = new HashMap<String, Integer>();
        int id = 0;
        for (String stageName : stageNames) {
            this.stageNameToId.put(stageName, id);
            ++id;
        }
        HashMap<String, Object> loadFileOptions = new HashMap<String, Object>();
        MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.metadataProfile);
        if (mp != null) {
            loadFileOptions.put("metadataProfile", mp);
        } else {
            this.addWarning(this.iu.getFormattedString("ExportItemsOperation.Warning.MetadataProfile", (Object)this.metadataProfile));
            loadFileOptions.put("metadataProfile", NuixUtils.getDefaultMetadataProfileName());
        }
        batchExporter.addLoadFile(effectiveLegalExportType, loadFileOptions);
        batchExporter.setParallelProcessingSettings(configurationParser.getParallelProcessingLegalExportSettings());
        NuixWorkerUtils.setWorkerSettings(this.executionContext, this, (ParallelProcessingConfigurable)batchExporter, true);
        this.workerMemory = NuixWorkerUtils.getProcessorWorkerMemory((ParallelProcessingConfigurable)batchExporter);
        batchExporter.whenItemEventOccurs(this::itemProcessed);
        if (items.size() > 0) {
            if (this.stopRequested) {
                this.trackStopped();
                return;
            }
            this.exportProcessingJob = batchExporter.exportItemsAsync(items);
            String processingJobGuid = this.exportProcessingJob.getJobGuid().replace("-", "");
            LOGGER.info("Job Guid: " + processingJobGuid);
            NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.exportProcessingJob, this.addedWorkerCount);
            NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.exportProcessingJob);
            if (this.executionState == ExecutionState.STOPPING) {
                this.trackStopped();
            }
        } else {
            this.addWarning(this.iu.getFormattedString("ExportItemsOperation.Warning.NoItemsInScope", (Object)this.scope));
            LOGGER.warn("No items were found in scope " + this.scope);
        }
        try {
            this.failedExportItemCount += this.exportProcessingJob.getFailedItemCount();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get job failed items", (Throwable)e);
        }
    }

    @Override
    public void startTriggered() throws Exception {
        this.addedWorkersList = new ArrayList<AddedWorkers>();
        this.partStartPercentage = 0.0;
        this.partSizePercentage = 1.0;
        this.failedExportItemCount = 0L;
        this.scope = this.executionContext.evalParameters(this.scope, this);
        if (this.scope.trim().length() > 0) {
            this.addExecutionLog(this.iu.getFormattedString("ExportItemsOperation.Log.ScopeQuery", (Object)this.scope));
        }
        this.addExecutionLog(this.iu.getFormattedString("ExportItemsOperation.Log.ExportFolder", (Object)this.exportFolder));
        this.addExecutionLog(this.iu.getFormattedString("ExportItemsOperation.Log.ExportFormat", (Object)this.legalExportType.toString()));
        String metadataProfileParameterName = "{metadata_profile}";
        String evaluatedMetadataProfileParameter = this.executionContext.evalParameters(metadataProfileParameterName, this);
        if (!metadataProfileParameterName.equals(evaluatedMetadataProfileParameter)) {
            this.metadataProfile = evaluatedMetadataProfileParameter;
            this.addExecutionLog(this.iu.getFormattedString("ExportItemsOperation.Log.CustomMetadataProfile", new Object[]{metadataProfileParameterName, this.metadataProfile}));
        } else {
            this.addExecutionLog(this.iu.getFormattedString("ExportItemsOperation.Log.MetadataProfile", (Object)this.metadataProfile));
        }
        ArrayList<String> fileTypes = new ArrayList<String>();
        if (this.exportFileTypeNative.booleanValue()) {
            fileTypes.add("Native");
        }
        if (this.exportFileTypeText.booleanValue()) {
            fileTypes.add("Text");
        }
        if (this.exportFileTypePdf.booleanValue()) {
            fileTypes.add("PDF");
        }
        if (this.exportFileTypeImage.booleanValue()) {
            fileTypes.add("Images");
        }
        if (this.exportFileTypeXhtmlReport.booleanValue()) {
            fileTypes.add("XHTML Report");
        }
        if (this.exportFileTypeThumbnail.booleanValue()) {
            fileTypes.add("Thumbnail");
        }
        this.addExecutionLog(this.iu.getFormattedString("ExportItemsOperation.Log.FileTypes", (Object)String.join((CharSequence)"; ", fileTypes)));
        try {
            this.executionContext.workflowLocalWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{local_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerCountFromParameter", new Object[]{"{local_worker_count}", this.executionContext.workflowLocalWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowLocalWorkersMemoryMb = Integer.parseInt(this.executionContext.evalParameters("{local_worker_memory}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerMemoryFromParameter", new Object[]{"{local_worker_memory}", this.executionContext.workflowLocalWorkersMemoryMb}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowBrokerWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{broker_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingBrokerWorkerCountFromParameter", new Object[]{"{broker_worker_count}", this.executionContext.workflowBrokerWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.jobBrokerPort = Integer.parseInt(this.executionContext.evalParameters("{job_worker_broker_port}", this));
            this.executionContext.jobBrokerIp = this.executionContext.evalParameters("{job_worker_broker_ip}", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executionContext.workflowLocalWorkersTempFolder = this.executionContext.evalParameters(this.executionContext.workflowLocalWorkersTempFolder, this);
        this.executionContext.closeAllTabs();
        this.startTriggerThread = new Thread(() -> {
            try {
                BulkAnnotater bulkAnnotater;
                String unevaluatedExportFolder = this.exportFolder;
                if (this.exportItemsAt > 0) {
                    this.addExecutionLog(this.iu.getString("ExportItemsOperation.Log.Separator"));
                }
                this.exportFolder = this.executionContext.evalParameters(unevaluatedExportFolder, this);
                this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_failed_items_tag_name}", this.failedItemTagName)));
                File exportFolderFile = new File(this.exportFolder);
                this.exportFolder = exportFolderFile.getCanonicalPath();
                LOGGER.info("Canonical export folder: " + this.exportFolder);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", this.exportFolder)));
                this.failedItems = new HashSet<Item>();
                this.itemsToUntag = new HashSet<Item>();
                if (exportFolderFile.exists() && exportFolderFile.list().length > 0) {
                    LOGGER.error("Folder has " + exportFolderFile.list().length + " items");
                    this.exception = new IOException(this.iu.getFormattedString("ExportItemsOperation.Exception.FolderNotEmpty", (Object)exportFolderFile.getCanonicalPath()));
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.itemsInScope = new ArrayList<Item>(this.executionContext.nuixCase.searchUnsorted(this.scope));
                this.itemsInScopeCount = this.itemsInScope.size();
                this.addExecutionLog(this.iu.getNumeralString("ExportItemsOperation.Log.ScopeCount", this.itemsInScopeCount));
                if (this.itemsInScopeCount == 0L) {
                    LOGGER.info("No items in scope");
                }
                if (Boolean.TRUE.equals(this.trackDescendantsOfExportedItems)) {
                    Set<Item> itemsInScopeAndDescendants = ItemsUtils.findItemsAndMaterialDescendants(this.itemsInScope);
                    String tagName = "Automate Utils|Export|Items And Descendants|" + DateTime.now().getMillis();
                    LOGGER.info("Tagging " + itemsInScopeAndDescendants.size() + " items with tag " + tagName);
                    bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    bulkAnnotater.addTag(tagName, itemsInScopeAndDescendants);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("ExportItemsOperation.Log.Tagged", (long)itemsInScopeAndDescendants.size(), (Object)tagName));
                    this.utilizationScope = "tag:\"" + tagName + "\"";
                } else {
                    this.utilizationScope = this.scope;
                }
                if (this.exportSplit.booleanValue() && this.itemsInScopeCount > (long)this.exportSplitAt) {
                    this.addExecutionLog(this.iu.getNumeralString("ExportItemsOperation.Log.SplitExportAt", (long)this.exportSplitAt));
                    if (this.exportConsolidateSplits.booleanValue()) {
                        this.addExecutionLog(this.iu.getString("ExportItemsOperation.Log.ConsolidateExportParts"));
                    }
                    LOGGER.info("Exporting in parts");
                    int addedForExport = 0;
                    this.exportPart = 0;
                    while (addedForExport < this.itemsInScope.size()) {
                        long itemsFailedInPart;
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        ArrayList<Item> partExportItems = new ArrayList<Item>();
                        this.partStartPercentage = (double)addedForExport / (double)this.itemsInScope.size();
                        LOGGER.info("Exported in parts: " + addedForExport + " of " + this.itemsInScope.size());
                        ++this.exportPart;
                        int nextItemId = Math.min(addedForExport + this.exportSplitAt, this.itemsInScope.size());
                        partExportItems.addAll(this.itemsInScope.subList(addedForExport, nextItemId));
                        LOGGER.info("Exporting part from " + addedForExport + " to " + (nextItemId - 1));
                        addedForExport = nextItemId;
                        LOGGER.info("Added to export: " + addedForExport);
                        String lastTlGuid = ((Item)partExportItems.get(partExportItems.size() - 1)).getTopLevelItem().getGuid();
                        LOGGER.info("Last TL Guid: " + lastTlGuid);
                        while (this.itemsInScope.size() > addedForExport) {
                            Item nextItem = this.itemsInScope.get(addedForExport);
                            String nextTlGuid = nextItem.getTopLevelItem().getGuid();
                            LOGGER.info("Next TL Guid: " + nextTlGuid);
                            if (!lastTlGuid.equals(nextTlGuid)) break;
                            partExportItems.add(nextItem);
                            LOGGER.info("Adding to export, total: " + ++addedForExport + " of " + this.itemsInScope.size());
                        }
                        double trancheEndPercentage = (double)addedForExport / (double)this.itemsInScope.size();
                        this.partSizePercentage = trancheEndPercentage - this.partStartPercentage;
                        LOGGER.info("Exporting part " + this.exportPart);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("ExportItemsOperation.Log.ExportFolderParts", (long)partExportItems.size(), new Object[]{this.exportFolder, this.exportPart}));
                        long oldItemsFailedCount = this.failedExportItemCount;
                        if (this.exportConsolidateSplits.booleanValue()) {
                            this.exportItems(this.exportFolder + "/Part" + this.exportPart, this.exportFolder, partExportItems);
                        } else {
                            this.exportItems(this.exportFolder + "/Part" + this.exportPart, null, partExportItems);
                        }
                        if ((itemsFailedInPart = this.failedExportItemCount - oldItemsFailedCount) <= 0L) continue;
                        if (this.exportConsolidateSplits.booleanValue()) {
                            this.addWarning(this.iu.getNumeralFormattedString("ExportItemsOperation.Warning.FailedExportingPartExplained", itemsFailedInPart, (Object)this.exportPart));
                            continue;
                        }
                        this.addWarning(this.iu.getNumeralFormattedString("ExportItemsOperation.Warning.FailedExportingPartDetailed", itemsFailedInPart, (Object)this.exportPart));
                    }
                    LOGGER.info("Exported in parts: " + addedForExport + " of " + this.itemsInScope.size());
                } else {
                    this.addExecutionLog(this.iu.getFormattedString("ExportItemsOperation.Log.ExportFolder", (Object)this.exportFolder));
                    this.exportItems(this.exportFolder, null, this.itemsInScope);
                    if (this.failedExportItemCount > 0L) {
                        this.addWarning(this.iu.getNumeralString("ExportItemsOperation.Warning.FailedExportingPart", this.failedExportItemCount));
                    }
                }
                if (!this.stopRequested) {
                    if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
                        LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
                        BulkAnnotater bulkAnnotater2 = this.executionContext.nuixUtilities.getBulkAnnotater();
                        bulkAnnotater2.addTag(this.failedItemTagName, this.failedItems);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("ExportItemsOperation.Log.Tagged", (long)this.failedItems.size(), (Object)this.failedItemTagName));
                    }
                    if (this.tagFailedItems.booleanValue() && this.untagSuccessfulItems.booleanValue()) {
                        String query = "tag:\"" + this.failedItemTagName + "\"";
                        LOGGER.info("Searching: " + query);
                        Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
                        this.itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
                        if (this.itemsToUntag.size() > 0) {
                            LOGGER.info("Untagging " + this.itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                            bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                            bulkAnnotater.removeTag(this.failedItemTagName, this.itemsToUntag);
                            this.addExecutionLog(this.iu.getNumeralFormattedString("ExportItemsOperation.Log.Untagged", (long)this.itemsToUntag.size(), (Object)this.failedItemTagName));
                        }
                    }
                } else {
                    this.trackStopped();
                    return;
                }
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void consolidateExportPart(Path mainExportPath, Path partExportPath, int exportPart) {
        try {
            Files.createDirectories(mainExportPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot create main export path folder", (Throwable)e);
        }
        try {
            Stream<Path> filesList = Files.list(partExportPath);
            for (Path path : filesList.collect(Collectors.toList())) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Path destinationPath = Paths.get(mainExportPath.toString(), path.getFileName().toString());
                    try {
                        FileUtils.moveMergeDirectories((Path)path, (Path)destinationPath);
                    }
                    catch (IOException e) {
                        this.addWarning(this.iu.getFormattedString("ExportItemsOperation.Warning.CannotConsolidatePartialExport", new Object[]{exportPart, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                        LOGGER.error("Cannot consolidate partial export " + exportPart + " folder " + path.toString(), (Throwable)e);
                    }
                    continue;
                }
                File exportFile = path.toFile();
                String extension = FilenameUtils.getExtension((String)exportFile.getName());
                String filename = exportFile.getName();
                String filenameWithPart = filename.substring(0, filename.length() - extension.length() - 1) + "_" + exportPart + "." + extension;
                Path destinationPath = Paths.get(mainExportPath.toString(), filenameWithPart);
                try {
                    Files.move(path, destinationPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    this.addWarning(this.iu.getFormattedString("ExportItemsOperation.Warning.CannotConsolidatePartialExport", new Object[]{exportPart, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    LOGGER.error("Cannot consolidate partial export " + exportPart + " file " + exportFile.toString(), (Throwable)e);
                }
            }
            filesList.close();
            try {
                LOGGER.info("Deleting partial export folder " + partExportPath.toString());
                org.apache.commons.io.FileUtils.deleteDirectory((File)partExportPath.toFile());
            }
            catch (InterruptedIOException e) {
                LOGGER.warn("Cannot delete directory " + partExportPath.toString(), (Throwable)e);
            }
        }
        catch (IOException e) {
            this.addWarning(this.iu.getFormattedString("ExportItemsOperation.Warning.CannotConsolidatePartialExport", new Object[]{exportPart, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
            LOGGER.error("Cannot consolidate partial export " + exportPart, (Throwable)e);
        }
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                try {
                    if (this.exportProcessingJob != null) {
                        LOGGER.info("Sending stop command while job is in state " + this.exportProcessingJob.getCurrentStage());
                        this.exportProcessingJob.stop();
                    }
                }
                catch (LicenceException e) {
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop job");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName() + " Stop request");
        thread.start();
    }

    @Override
    public synchronized void updateState() {
        if (this.exportProcessingJob != null) {
            if (!this.isPaused && this.exportProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.exportProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
            if (this.exportProcessingJob.hasFinished() && this.executionState == ExecutionState.STOPPING) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete;
        block6: {
            percentageComplete = 0.0;
            if (this.exportProcessingJob != null) {
                try {
                    int stageCount = this.stageNameToId.size();
                    int currentStage = 0;
                    long itemsExported = 0L;
                    long itemsCount = this.exportProcessingJob.getTotalItemCount();
                    String exportStage = this.exportProcessingJob.getCurrentStage().toLowerCase();
                    if (this.stageNameToId.containsKey(exportStage)) {
                        currentStage = this.stageNameToId.get(exportStage);
                    }
                    itemsExported = this.exportProcessingJob.getCurrentStageExportedItemsCount();
                    double stageExportPercentageComplete = 0.0;
                    if (itemsCount > 0L) {
                        stageExportPercentageComplete = (double)itemsExported / (double)itemsCount;
                    }
                    percentageComplete = (stageExportPercentageComplete + (double)currentStage) / (double)stageCount;
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug("Cannot get progress.", (Throwable)e);
                }
            }
        }
        if (this.partSizePercentage > 0.0) {
            percentageComplete = percentageComplete * this.partSizePercentage + this.partStartPercentage;
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result;
        block12: {
            result = "";
            double percentageComplete = -1.0;
            percentageComplete = this.getNormalizedPercentageComplete();
            if (!Double.isNaN(percentageComplete)) {
                result = String.format("%.2f%%", percentageComplete * 100.0);
            }
            if (this.exportProcessingJob != null) {
                try {
                    Object exportStage = "";
                    if (!this.exportProcessingJob.hasFinished() || this.executionState == ExecutionState.STOPPED) {
                        if (this.exportPart > 0) {
                            exportStage = this.iu.getFormattedString("ExportItemsOperation.Progress.ExportPart", (Object)this.exportPart);
                        }
                        try {
                            exportStage = (String)exportStage + FormattingUtils.stageToString((String)this.exportProcessingJob.getCurrentStage().toLowerCase());
                        }
                        catch (Exception e) {
                            exportStage = (String)exportStage + this.iu.getString("ExportItemsOperation.Progress.Discovering");
                        }
                        exportStage = (String)exportStage + this.iu.getNumeralString("ExportItemsOperation.Progress.ItemsProcessed", this.exportProcessingJob.getCurrentStageExportedItemsCount());
                    } else {
                        exportStage = "";
                    }
                    if (((String)result).length() > 0 && ((String)exportStage).length() > 0) {
                        result = (String)result + " / ";
                    }
                    result = (String)result + (String)exportStage;
                }
                catch (Exception e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Cannot get job stage.", (Throwable)e);
                    }
                    break block12;
                }
            }
            String exportStage = this.iu.getString("ExportItemsOperation.Progress.Initializing");
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + exportStage;
        }
        return result;
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.exportProcessingJob != null) {
            return this.exportProcessingJob.getJobGuid();
        }
        return null;
    }

    public void itemProcessed(ItemEventInfo itemEventInfo) {
        this.trackIncrementVolumeProcessed(itemEventInfo.getItem().getAuditedSize());
        Item processedItem = itemEventInfo.getItem();
        String mimeType = "unknown";
        String pathName = "N/A";
        if (processedItem != null) {
            pathName = String.join((CharSequence)"/", processedItem.getPathNames());
            mimeType = processedItem.getType().getName();
        }
        String stage = itemEventInfo.getStage() == null ? "exported" : itemEventInfo.getStage();
        String translatedStage = this.iu.getString("MimeType.Stage." + stage);
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.ExportedStage", new Object[]{translatedStage, pathName}));
        this.trackItemProcessedFailed(mimeType, stage, itemEventInfo.getFailure() != null);
        if (this.tagFailedItems.booleanValue() && itemEventInfo.getFailure() != null) {
            this.failedItems.add(itemEventInfo.getItem());
        }
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }
}

