/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.FindItemsWithWordsOperation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import nuix.BulkAnnotater;
import nuix.Item;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class FindItemsWithWordsOperationImplementation
extends FindItemsWithWordsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FindItemsWithWordsOperation.class);
    private transient long itemsInScope;
    private transient AtomicInteger itemsProcessed = new AtomicInteger();
    private transient AtomicInteger itemsWithErrors = new AtomicInteger();
    private transient int stageId;
    private transient int stageCount;
    private transient String stageName;
    private transient String itemType;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.itemsProcessed = new AtomicInteger(0);
        this.splitRegex = this.executionContext.evalParameters(this.splitRegex, this);
        this.responsiveTagName = this.executionContext.evalParameters(this.responsiveTagName, this);
        this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        Pattern pattern = Pattern.compile(this.splitRegex);
        this.stageCount = 2;
        this.stageId = 0;
        this.startTriggerThread = new Thread(() -> {
            try {
                Set items = null;
                try {
                    this.executionContext.closeAllTabs();
                    this.itemType = this.iu.getString("FindItemsWithWordsOperation.ItemType.Item");
                    this.stageName = this.iu.getString("FindItemsWithWordsOperation.Stage.SearchingForItems");
                    LOGGER.info("Searching for " + NuixUtils.addAndQuery(this.scope, "has-exclusion:0"));
                    this.addExecutionLog(this.iu.getFormattedString("FindItemsWithWordsOperation.Log.ScopeQuery", (Object)this.scope));
                    items = this.executionContext.nuixCase.searchUnsorted(this.scope);
                    this.itemsInScope = items.size();
                    this.addExecutionLog(this.iu.getNumeralString("FindItemsWithWordsOperation.Log.ScopeCount", this.itemsInScope));
                    this.addExecutionLog(this.iu.getFormattedString("FindItemsWithWordsOperation.Log.SplitRegex", (Object)this.splitRegex));
                    this.addExecutionLog(this.iu.getNumeralString("FindItemsWithWordsOperation.Log.MinWordLength", (long)this.minWordLength));
                    this.addExecutionLog(this.iu.getNumeralString("FindItemsWithWordsOperation.Log.MaxWordLength", (long)this.maxWordLength));
                    this.addExecutionLog(this.iu.getNumeralString("FindItemsWithWordsOperation.Log.MinWordCount", (long)this.minWordCount));
                    this.addExecutionLog(this.iu.getNumeralString("FindItemsWithWordsOperation.Log.MaxWordCount", (long)this.maxWordCount));
                }
                catch (IOException e) {
                    LOGGER.error("Error searching scope items: " + this.scope, (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.stageName = this.iu.getString("FindItemsWithWordsOperation.Stage.ExtractingWordsFromText");
                Set responsiveItems = Collections.newSetFromMap(new ConcurrentHashMap());
                Set failedItems = Collections.newSetFromMap(new ConcurrentHashMap());
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)items, ItemsUtils.getPartitionerChunkSize(1000, this));
                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                    while (iterator.hasNext()) {
                        Item item = (Item)iterator.next();
                        try {
                            String[] words = pattern.split((CharSequence)item.getTextObject());
                            int wordCount = 0;
                            HashSet<String> wordSet = new HashSet<String>();
                            for (String word : words) {
                                if (word.length() < this.minWordLength || word.length() > this.maxWordLength) continue;
                                if (this.countUniqueWordsOnly.booleanValue()) {
                                    wordSet.add(word);
                                    continue;
                                }
                                ++wordCount;
                            }
                            if (this.countUniqueWordsOnly.booleanValue()) {
                                wordCount = wordSet.size();
                            }
                            if (wordCount >= this.minWordCount && wordCount <= this.maxWordCount) {
                                responsiveItems.add(item);
                            }
                        }
                        catch (Exception e) {
                            failedItems.add(item);
                        }
                        this.itemsProcessed.incrementAndGet();
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (failedItems.size() > 0) {
                    this.addWarning(this.iu.getNumeralString("FindItemsWithWordsOperation.Warning.FailedExtractingWordsFrom", (long)failedItems.size()));
                }
                ++this.stageId;
                if (this.tagFailedItems.booleanValue() && failedItems.size() > 0) {
                    this.stageName = this.iu.getString("FindItemsWithWordsOperation.Stage.TaggingFailedItems");
                    LOGGER.info("Tagging " + failedItems.size() + " items with tag " + this.failedItemTagName);
                    BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    bulkAnnotater.addTag(this.failedItemTagName, failedItems);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("FindItemsWithWordsOperation.Log.TaggedFailed", (long)failedItems.size(), (Object)this.failedItemTagName));
                }
                this.stageName = this.iu.getString("FindItemsWithWordsOperation.Stage.TaggingResponsiveItems");
                this.itemsProcessed.set(0);
                this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.responsiveTagName, responsiveItems);
                this.addExecutionLog(this.iu.getNumeralFormattedString("FindItemsWithWordsOperation.Log.TaggedResponsive", (long)responsiveItems.size(), (Object)this.responsiveTagName));
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.itemsProcessed != null) {
            stageProgress = (double)this.itemsProcessed.get() / (double)this.itemsInScope;
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.itemsProcessed != null && this.itemsProcessed.get() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("FindItemsWithWordsOperation.Progress.ItemsProcessed", (long)this.itemsProcessed.get());
        }
        return result;
    }
}

