/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.GenAiConfigureConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.util.Map;

public class GenAiConfigureConnectionOperationImplementation
extends GenAiConfigureConnectionOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenAiConfigureConnectionOperation.class);
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient String stageName;
    private transient double percentageComplete;
    private transient GenAiHelper genAiHelper;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), GenAiService.class.getSimpleName(), ParameterType.GEN_AI_SERVICE);
                this.stageName = "";
                this.genAiServiceId = this.executionContext.evalParameters(this.genAiServiceId, this);
                if (this.thirdPartyServices == null || this.thirdPartyServices.get(this.genAiServiceId) == null) {
                    throw new IllegalStateException(this.iu.getFormattedString("GenAiConfigureConnectionOperation.Exception.MissingService", (Object)this.genAiServiceId));
                }
                GenAiService genAiService = (GenAiService)this.thirdPartyServices.get(this.genAiServiceId);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_gen_ai_service_id}", this.genAiServiceId)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_gen_ai_override_model}", "" + this.overrideModel)));
                if (this.overrideModel) {
                    this.model = this.executionContext.evalParameters(this.model, this);
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_gen_ai_model}", this.model)));
                }
                this.executionContext.workflowExecution.log(this.iu.getFormattedString("GenAiConfigureConnectionOperation.Log.ServiceApi", (Object)genAiService.getUrl()));
                if (this.overrideModel) {
                    this.executionContext.workflowExecution.log(this.iu.getString("GenAiConfigureConnectionOperation.Log.OverrideModel"));
                    this.executionContext.workflowExecution.log(this.iu.getFormattedString("GenAiConfigureConnectionOperation.Log.Model", (Object)this.model));
                } else {
                    this.executionContext.workflowExecution.log(this.iu.getFormattedString("GenAiConfigureConnectionOperation.Log.Model", (Object)genAiService.getModel()));
                }
                Map customParameters = genAiService.getCustomParameters();
                if (customParameters != null && !customParameters.isEmpty()) {
                    for (Map.Entry entry : customParameters.entrySet()) {
                        this.executionContext.workflowExecution.log(this.iu.getFormattedString("GenAiConfigureConnectionOperation.Log.Parameter", new Object[]{entry.getKey(), entry.getValue()}));
                    }
                }
                boolean enableSystemRole = false;
                if (genAiService.getEnableSystemRole() != null) {
                    enableSystemRole = genAiService.getEnableSystemRole();
                }
                if (!enableSystemRole) {
                    this.addExecutionLog(this.iu.getString("GenAiConfigureConnectionOperation.Log.SystemRoleDisabled"));
                } else {
                    this.addExecutionLog(this.iu.getString("GenAiConfigureConnectionOperation.Log.SystemRoleEnabled"));
                }
                if (!this.overrideModel) {
                    this.model = null;
                }
                this.genAiHelper = new GenAiHelper(genAiService, this.model);
                Object response = this.genAiHelper.test();
                if (((String)response).length() > 10) {
                    response = ((String)response).substring(0, 10) + "...";
                }
                this.executionContext.workflowExecution.log(this.iu.getFormattedString("GenAiConfigureConnectionOperation.Log.Connected", (Object)genAiService.getName()));
                this.executionContext.workflowExecution.log(this.iu.getFormattedString("GenAiConfigureConnectionOperation.Log.TestResponse", response));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }

    @Override
    public void stopTriggered() {
        if (this.genAiHelper != null) {
            this.genAiHelper.stop();
        }
    }
}

