/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.GenAiConfigureConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.NuixQueryMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.ArrayList;
import java.util.List;

@FormFieldGroups(value={@FormFieldGroup(name="multiPageGroup", children={"repeatPromptForEachPage", "keepIndividualPagesTranscriptions", "skipExistingPages", "maxPagesRow", "multiPageAutoMergeJson", "multiPageOutputSeparator", "addPageSeparatorBeforeFirstPage"}), @FormFieldGroup(name="renderingGroup", children={"nativeImagesScope", "nonNativeImagesPrintMP"})})
@FormFieldRows(value={@FormFieldRow(name="maxPagesRow", children={"maxPagesEnabled", "maxPages"}), @FormFieldRow(name="temperatureRow", children={"temperatureEnabled", "temperature"}), @FormFieldRow(name="maxResponseTokensRow", children={"maxResponseTokensEnabled", "maxResponseTokens"}), @FormFieldRow(name="tagAnalyzedItemsRow", children={"tagAnalyzedItems", "analyzedItemsTagName", "untagUnanalyzedItems"}), @FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"}), @FormFieldRow(name="sampleRow", children={"sampleEnabled", "sampleSize"}), @FormFieldRow(name="jsonRow", children={"jsonEnabled", "jsonSchema"}), @FormFieldRow(name="metadataProfileRow", children={"createMetadataProfileEnabled", "metadataProfileName"})})
@OperationMetadata(alias=OperationAlias.GEN_AI_PROMPT_ON_IMAGES, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE", "GEN_AI"}), @OperationTag(name="Category", value={"METADATA"})})
@OperationLicenseModule(module=ModuleType.GEN_AI)
public class GenAiPromptOnImagesOperation
extends NuixQueryMimeTypeVolumesUtilizationOperation {
    @FormField(required=false)
    public String scope = "flag:audited AND (mime-type:application/pdf OR kind:image) AND NOT tag:\"Automate|Analyzed Items|GenAI\"";
    @FormField
    public boolean sampleEnabled = true;
    @FormField(enableOn={@OnField(name="sampleEnabled")}, positionLabel=@PositionLabel(right="items"), min=1.0)
    @ExcludeFromPrintableOptions
    public int sampleSize = 10;
    @FormField(componentType=FieldComponentType.TEXTAREA, rowSize=3, required=false)
    public String contextPrompt = "";
    @FormField(columnFields={@FormFieldColumn(label="name"), @FormFieldColumn(label="prompt", componentType=FieldComponentType.TEXTAREA)})
    public List<Object[]> prompts = new ArrayList<Object[]>();
    @FormField
    public boolean parseJsonOutput;
    @FormField
    public boolean jsonEnabled;
    @FormField(visibleOn={@OnField(name="jsonEnabled")}, componentType=FieldComponentType.SCRIPT_PANE, scriptLanguage="json")
    public String jsonSchema;
    @FormField
    public boolean temperatureEnabled = false;
    @FormField(max=100.0, enableOn={@OnField(name="temperatureEnabled")}, positionLabel=@PositionLabel(right="temperatureRange"))
    @ExcludeFromPrintableOptions
    public double temperature = 0.2;
    @FormField
    public boolean maxResponseTokensEnabled = false;
    @FormField(max=1000.0, enableOn={@OnField(name="maxResponseTokensEnabled")})
    @ExcludeFromPrintableOptions
    public int maxResponseTokens = 1000;
    @FormField(required=false)
    public String nativeImagesScope = "mime-type:( image/jpeg OR image/png )";
    @FormField(max=100.0)
    public double nonNativeImagesPrintMP;
    @FormField
    public boolean maxPagesEnabled;
    @FormField(enableOn={@OnField(name="maxPagesEnabled")}, min=1.0)
    public int maxPages;
    @FormField
    public boolean repeatPromptForEachPage;
    @FormField(enableOn={@OnField(name="repeatPromptForEachPage")})
    public boolean keepIndividualPagesTranscriptions;
    @FormField(enableOn={@OnField(name="keepIndividualPagesTranscriptions")})
    public boolean skipExistingPages;
    @FormField(required=false, enableOn={@OnField(name="repeatPromptForEachPage")})
    public boolean multiPageAutoMergeJson;
    @FormField(componentType=FieldComponentType.TEXTAREA, rowSize=3, required=false, enableOn={@OnField(name="repeatPromptForEachPage")})
    public String multiPageOutputSeparator;
    @FormField(enableOn={@OnField(name="repeatPromptForEachPage")})
    public boolean addPageSeparatorBeforeFirstPage;
    @FormField
    public boolean createMetadataProfileEnabled;
    @FormField(enableOn={@OnField(name="createMetadataProfileEnabled")})
    public String metadataProfileName;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagAnalyzedItems = true;
    @FormField(enableOn={@OnField(name="tagAnalyzedItems")})
    @ExcludeFromPrintableOptions
    public String analyzedItemsTagName = "Automate|Analyzed Items|GenAI";
    @FormField(enableOn={@OnField(name="tagAnalyzedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagUnanalyzedItems = true;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagFailedItems = true;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName = "Automate|Failed Items|GenAI";
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagSuccessfulItems = true;

    public boolean getDisplaySampleSize() {
        return this.sampleEnabled;
    }

    public boolean getDisplayTemperature() {
        return this.temperatureEnabled;
    }

    public boolean getDisplayMaxResponseTokens() {
        return this.maxResponseTokensEnabled;
    }

    public GenAiPromptOnImagesOperation() {
        this.prompts.add(new String[]{"Theme", "What's theme of the image, in no more than 2 words?"});
        this.prompts.add(new String[]{"Description", "Provide a very short description of the image, in no more than 10 words. Don't say \"the image shows\" or \"the image features\" or \"this appears to be\" or \"this is\". Start directly with the description."});
        this.prompts.add(new String[]{"Objects", "List the objects in the image. Don't say \"the image contains\" or \"the image shows\" or \"Here is the list\". Output only the objects, comma separated."});
        this.parseJsonOutput = true;
        this.createMetadataProfileEnabled = true;
        this.metadataProfileName = "Default";
        this.multiPageOutputSeparator = "; ";
        this.addPageSeparatorBeforeFirstPage = false;
        this.multiPageAutoMergeJson = true;
        this.nonNativeImagesPrintMP = 1.0;
        this.maxPagesEnabled = false;
        this.maxPages = 1;
        this.repeatPromptForEachPage = true;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("GenAiPromptOnImagesOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.GEN_AI_PROMPT_ON_IMAGES;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigure = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof GenAiConfigureConnectionOperation) {
                detectedConfigure = true;
                break;
            }
            if (o == this) break;
        }
        if (!detectedConfigure) {
            prerequisites.add(this.iu.getString("GenAiPromptOnDocumentsOperation.Prerequisites.MissingConfigureOperation"));
        }
        return prerequisites;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return null;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.LLM_PROMPT;
    }

    @Override
    public Activity getActivity() {
        return Activity.AI;
    }
}

