/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.NuixQueryMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.options.genai.ResultsLocation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import java.util.HashSet;
import java.util.Set;

@FormFieldGroups(value={@FormFieldGroup(name="multiPageGroup", children={"maxPagesRow", "repeatPromptForEachPage", "keepIndividualPagesTranscriptions", "skipExistingPages", "multiPageOutputSeparator", "addPageSeparatorBeforeFirstPage"}), @FormFieldGroup(name="renderingGroup", children={"nativeImagesScope", "nonNativeImagesPrintMP"})})
@FormFieldRows(value={@FormFieldRow(name="maxPagesRow", children={"maxPagesEnabled", "maxPages"}), @FormFieldRow(name="temperatureRow", children={"temperatureEnabled", "temperature"}), @FormFieldRow(name="maxResponseTokensRow", children={"maxResponseTokensEnabled", "maxResponseTokens"}), @FormFieldRow(name="tagAnalyzedItemsRow", children={"tagAnalyzedItems", "analyzedItemsTagName", "untagUnanalyzedItems"}), @FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"}), @FormFieldRow(name="sampleRow", children={"sampleEnabled", "sampleSize"})})
@OperationParameter(label="queryRetrieveFailedItems", parameter="tag:\"{last_failed_items_tag_name}\"")
@OperationMetadata(alias=OperationAlias.GEN_AI_TRANSCRIBE_ITEMS, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE", "GEN_AI"}), @OperationTag(name="Category", value={"OCR"})})
@OperationLicenseModule(module=ModuleType.GEN_AI)
public class GenAiTranscribeItemsOperation
extends NuixQueryMimeTypeVolumesUtilizationOperation {
    @FormField(required=false)
    public String scope = "flag:audited AND (mime-type:application/pdf OR kind:image) AND NOT tag:\"Automate|Analyzed Items|GenAI\"";
    @FormField
    public boolean sampleEnabled = true;
    @FormField(enableOn={@OnField(name="sampleEnabled")}, positionLabel=@PositionLabel(right="items"), min=1.0)
    @ExcludeFromPrintableOptions
    public int sampleSize = 10;
    @FormField(allowedValues={"TEXT", "CUSTOM_METADATA"})
    public ResultsLocation resultsLocation = ResultsLocation.CUSTOM_METADATA;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON, allowedValues={"false", "true"}, visibleOn={@OnField(name="resultsLocation", value={"TEXT"})})
    public boolean replaceText = false;
    @FormField(visibleOn={@OnField(name="resultsLocation", value={"CUSTOM_METADATA"})})
    public String metadataFieldName = "GenAI|Transcription";
    @FormField(componentType=FieldComponentType.TEXTAREA, rowSize=4, required=false)
    public String contextPrompt = "";
    @FormField(componentType=FieldComponentType.TEXTAREA, rowSize=8)
    public String transcriptionPrompt = "You are a data entry expert and are tasked with transcribing an image of a page from a document into text as closely as possible.\n\nThe page might begin with text in the middle of a sentence, or it might end in the middle of a sentence. Keep the text as-is and do not attempt to complete the sentence.\n\nIf the paragraph is numbered, make sure to extract the number.\n\nFlatten tables to plain text.\n\nDo not describe the image. Do not output any comments\n\nDo NOT say \"Here is the transcription of the text on the page\" or \"The image shows a page from a document\" or \"The page begins with the text\" or \"Transcription of the Image\". Start directly with the transcription text.\n\nDo not use Markdown or formatting, use plain text.";
    @FormField
    public boolean temperatureEnabled = false;
    @FormField(max=100.0, enableOn={@OnField(name="temperatureEnabled")}, positionLabel=@PositionLabel(right="temperatureRange"))
    @ExcludeFromPrintableOptions
    public double temperature = 0.7;
    @FormField
    public boolean maxResponseTokensEnabled = false;
    @FormField(enableOn={@OnField(name="maxResponseTokensEnabled")})
    @ExcludeFromPrintableOptions
    public int maxResponseTokens = 16000;
    @FormField(required=false)
    public String nativeImagesScope = "mime-type:( image/jpeg OR image/png )";
    @FormField(max=100.0)
    public double nonNativeImagesPrintMP = 1.0;
    @FormField
    public boolean maxPagesEnabled = false;
    @FormField(enableOn={@OnField(name="maxPagesEnabled")}, min=1.0)
    public int maxPages = 1;
    @FormField
    public boolean repeatPromptForEachPage = true;
    @FormField(enableOn={@OnField(name="repeatPromptForEachPage")})
    public boolean keepIndividualPagesTranscriptions = true;
    @FormField(enableOn={@OnField(name="keepIndividualPagesTranscriptions")})
    public boolean skipExistingPages = true;
    @FormField(componentType=FieldComponentType.TEXTAREA, rowSize=3, required=false, enableOn={@OnField(name="repeatPromptForEachPage")})
    public String multiPageOutputSeparator = "\n<|Page {page_number}|>\n";
    @FormField(enableOn={@OnField(name="repeatPromptForEachPage")})
    public boolean addPageSeparatorBeforeFirstPage = true;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagAnalyzedItems = true;
    @FormField(enableOn={@OnField(name="tagAnalyzedItems")})
    @ExcludeFromPrintableOptions
    public String analyzedItemsTagName = "Automate|Analyzed Items|GenAI";
    @FormField(enableOn={@OnField(name="tagAnalyzedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagUnanalyzedItems = true;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean tagFailedItems = true;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName = "Automate|Failed Items|GenAI";
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public boolean untagSuccessfulItems = true;

    public boolean getDisplaySampleSize() {
        return this.sampleEnabled;
    }

    public boolean getDisplayTemperature() {
        return this.temperatureEnabled;
    }

    public boolean getDisplayMaxResponseTokens() {
        return this.maxResponseTokensEnabled;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return null;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("GenAiTranscribeItemsOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.GEN_AI_TRANSCRIBE_ITEMS;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }

    @Override
    public Activity getActivity() {
        return Activity.AI;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.TRANSCRIBE;
    }

    @Override
    public long getVolume(WorkflowExecution workflowExecution) {
        return 0L;
    }
}

