/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.workflow.core.execution.operations.GenAiGenericPromptOnImagesOperation;
import com.nuix.automate.workflow.core.execution.operations.NativeOcrItemsOperation;
import com.nuix.automate.workflow.core.execution.operations.ReplaceTextFromStringModifierCallback;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.options.genai.ResultsLocation;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nuix.Item;
import nuix.ItemModifierCallback;

public class GenAiTranscribeItemsOperationImplementation
extends GenAiGenericPromptOnImagesOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NativeOcrItemsOperation.class);
    public String transcriptionPrompt;
    public ResultsLocation resultsLocation;
    public boolean replaceText;
    public String metadataFieldName;
    private String effectiveTextSeparator;
    private static final String DEFAULT_SEPARATOR = "\n\n------\n\n";
    public boolean keepIndividualPagesTranscriptions;
    public boolean skipExistingPages;

    @Override
    public OperationType getOperationType() {
        return OperationType.TRANSCRIBE;
    }

    @Override
    public Activity getActivity() {
        return Activity.AI;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("GenAiTranscribeItemsOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.GEN_AI_TRANSCRIBE_ITEMS;
    }

    @Override
    public void startTriggered() throws Exception {
        try {
            this.effectiveTextSeparator = this.executionContext.evalParametersIfSet("{transcribe_page_separator}", this);
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        if (this.effectiveTextSeparator == null) {
            this.effectiveTextSeparator = DEFAULT_SEPARATOR;
        } else {
            this.addExecutionLog(this.iu.getFormattedString("NativeOcrItemsOperation.Log.CustomSeparator", (Object)this.effectiveTextSeparator));
        }
        if (this.resultsLocation.equals((Object)ResultsLocation.CUSTOM_METADATA)) {
            this.metadataFieldName = this.executionContext.evalParameters(this.metadataFieldName, this);
        }
        this.transcriptionPrompt = this.executionContext.evalParameters(this.transcriptionPrompt, this);
        switch (this.resultsLocation) {
            case CUSTOM_METADATA: {
                this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.StoreResultInMetadataField", (Object)this.metadataFieldName));
                break;
            }
            case TEXT: {
                if (this.replaceText) {
                    this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.ReplaceText", new Object[0]));
                    break;
                }
                this.addExecutionLog(this.iu.getFormattedString("GenAiOperation.Log.AppendText", new Object[0]));
            }
        }
        super.startTriggered();
    }

    @Override
    public List<Object[]> getPrompts() {
        switch (this.resultsLocation) {
            case CUSTOM_METADATA: {
                return Collections.singletonList(new Object[]{this.metadataFieldName, this.transcriptionPrompt});
            }
            case TEXT: {
                return Collections.singletonList(new Object[]{"Transcription", this.transcriptionPrompt});
            }
        }
        throw new IllegalStateException("Unsupported results location: " + String.valueOf((Object)this.resultsLocation));
    }

    @Override
    public void applyPromptResult(Item item, String promptName, String result) throws IOException {
        switch (this.resultsLocation) {
            case CUSTOM_METADATA: {
                super.applyPromptResult(item, promptName, result);
                break;
            }
            case TEXT: {
                if (this.replaceText) {
                    item.modify((ItemModifierCallback)new ReplaceTextFromStringModifierCallback(result));
                    break;
                }
                String updatedText = item.getTextObject().toString() + this.effectiveTextSeparator + result;
                item.modify((ItemModifierCallback)new ReplaceTextFromStringModifierCallback(updatedText));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported results location: " + String.valueOf((Object)this.resultsLocation));
            }
        }
    }

    @Override
    public void clearPreviousResults(Item item) {
        switch (this.resultsLocation) {
            case CUSTOM_METADATA: {
                super.clearPreviousResults(item);
                break;
            }
            case TEXT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported results location: " + String.valueOf((Object)this.resultsLocation));
            }
        }
    }

    @Override
    public void logPrompts() {
        this.addExecutionLog(this.iu.getFormattedString("Operation.Log.TranscriptionPrompt", (Object)GenAiHelper.indentMultiLineText(this.transcriptionPrompt)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean skipPage(Item item, String promptName, int pageNumber) {
        if (this.keepIndividualPagesTranscriptions && this.skipExistingPages) {
            String effectiveName = this.getEffectiveMetadataName(promptName);
            Item item2 = item;
            synchronized (item2) {
                return item.getCustomMetadata().get((Object)(effectiveName + "|" + pageNumber)) != null;
            }
        }
        return false;
    }

    @Override
    protected void storePageResult(Item item, String promptName, int pageNumber, String result) throws IOException {
        if (this.keepIndividualPagesTranscriptions) {
            super.applyPromptResult(item, this.getEffectiveMetadataName(promptName + "|" + pageNumber), result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearPageResults(Item item, String promptName) {
        if (!this.keepIndividualPagesTranscriptions) {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            String keyPrefix = this.getEffectiveMetadataName(promptName + "|");
            Item item2 = item;
            synchronized (item2) {
                for (String key : item.getCustomMetadata().keySet()) {
                    if (!key.startsWith(keyPrefix)) continue;
                    keysToRemove.add(key);
                }
                for (String key : keysToRemove) {
                    item.getCustomMetadata().remove((Object)key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> getResponsesFromPageResponses(Item item, Map<Integer, String> pageResponses, String promptName, int pages) {
        if (this.keepIndividualPagesTranscriptions) {
            ArrayList<String> responses = new ArrayList<String>();
            for (int pageNumber = 1; pageNumber <= pages; ++pageNumber) {
                if (pageResponses.containsKey(pageNumber)) {
                    responses.add(pageResponses.get(pageNumber));
                    continue;
                }
                Item item2 = item;
                synchronized (item2) {
                    Object metadataResponse = item.getCustomMetadata().get((Object)this.getEffectiveMetadataName(promptName + "|" + pageNumber));
                    if (metadataResponse != null) {
                        responses.add(metadataResponse.toString());
                    } else {
                        responses.add("");
                    }
                    continue;
                }
            }
            return responses;
        }
        return super.getResponsesFromPageResponses(item, pageResponses, promptName, pages);
    }
}

