/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.GenerateDomainFieldsOperation;
import com.nuix.automate.workflow.core.utils.general.NuixEmailUtils;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Address;
import nuix.Communication;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.ProductionSetItem;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class GenerateDomainFieldsOperationImplementation
extends GenerateDomainFieldsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenerateDomainFieldsOperation.class);
    private transient String stageName;
    private transient AtomicLong stageItems = new AtomicLong(0L);
    private transient AtomicLong stageTotalItems = new AtomicLong(0L);
    private transient int stageId;
    private transient int stageCount;
    private transient StageType stageType;
    private transient Set<Item> itemsToSearch;
    private transient String effectiveCsvPath;
    private transient BufferedWriter bufferedWriter;

    private String getFieldsToGenerate() {
        ArrayList<String> fields = new ArrayList<String>();
        if (this.fieldDomainsAll) {
            fields.add(this.iu.getString("GenerateDomainFieldsOperation.Fields.DomainsAll"));
        }
        if (this.fieldDomainsFrom) {
            fields.add(this.iu.getString("GenerateDomainFieldsOperation.Fields.DomainsFrom"));
        }
        if (this.fieldDomainsTo) {
            fields.add(this.iu.getString("GenerateDomainFieldsOperation.Fields.DomainsTo"));
        }
        if (this.fieldDomainsCc) {
            fields.add(this.iu.getString("GenerateDomainFieldsOperation.Fields.DomainsCC"));
        }
        if (this.fieldDomainsBcc) {
            fields.add(this.iu.getString("GenerateDomainFieldsOperation.Fields.DomainsBCC"));
        }
        if (this.fieldRecipientsCount) {
            fields.add(this.iu.getString("GenerateDomainFieldsOperation.Fields.RecipientCount"));
        }
        return String.join((CharSequence)"; ", fields);
    }

    private void updateItemMetadata(Item item, Domains domains) {
        if (domains != null) {
            String sortedValuesRepresentation;
            TreeSet<String> sortedValues;
            ItemCustomMetadataMap itemCustomMetadataMap = item.getCustomMetadata();
            if (this.fieldDomainsAll) {
                sortedValues = new TreeSet<String>(domains.allDomains);
                sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDomainFieldsOperation.Fields.AllDomains"), (Object)sortedValuesRepresentation);
            }
            if (this.fieldDomainsTo) {
                sortedValues = new TreeSet<String>(domains.toDomains);
                sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDomainFieldsOperation.Fields.ToDomains"), (Object)sortedValuesRepresentation);
            }
            if (this.fieldDomainsFrom) {
                sortedValues = new TreeSet<String>(domains.fromDomains);
                sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDomainFieldsOperation.Fields.FromDomains"), (Object)sortedValuesRepresentation);
            }
            if (this.fieldDomainsCc) {
                sortedValues = new TreeSet<String>(domains.ccDomains);
                sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDomainFieldsOperation.Fields.CCDomains"), (Object)sortedValuesRepresentation);
            }
            if (this.fieldDomainsBcc) {
                sortedValues = new TreeSet<String>(domains.bccDomains);
                sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDomainFieldsOperation.Fields.BCCDomains"), (Object)sortedValuesRepresentation);
            }
            if (this.fieldRecipientsCount) {
                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDomainFieldsOperation.Fields.RecipientCount"), (Object)domains.recipientsCount);
            }
        }
    }

    @Override
    public void startTriggered() throws Exception {
        this.searchScope = this.executionContext.evalParameters(this.searchScope, this);
        this.separator = this.executionContext.evalParameters(this.separator, this);
        this.executionContext.closeAllTabs();
        this.stageCount = 2;
        this.stageId = 0;
        this.stageItems.set(0L);
        this.stageType = StageType.QUERY;
        this.startTriggerThread = new Thread(() -> {
            try {
                this.addExecutionLog(this.iu.getFormattedString("GenerateDomainFieldsOperation.Log.ScopeQuery", (Object)this.searchScope));
                String itemsToSearchQuery = NuixUtils.addAndQuery(this.searchScope, "has-exclusion:0");
                LOGGER.info("Searching for items in scope: " + itemsToSearchQuery);
                this.itemsToSearch = this.executionContext.nuixCase.searchUnsorted(itemsToSearchQuery);
                LOGGER.info("Got " + this.itemsToSearch.size() + " items");
                this.addExecutionLog(this.iu.getNumeralString("GenerateDomainFieldsOperation.Log.ScopeCount", (long)this.itemsToSearch.size()));
                this.stageName = this.iu.getString("GenerateDomainFieldsOperation.Stage.MappingItemsToDocIDs");
                this.stageType = StageType.QUERY;
                this.stageItems.set(0L);
                this.stageName = this.iu.getString("GenerateDomainFieldsOperation.Stage.BuildingFieldsValues");
                this.stageTotalItems.set(this.itemsToSearch.size());
                this.stageType = StageType.QUERY;
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (this.resultsOutputCsv) {
                    LOGGER.info("Unpacking path: " + this.resultsCsvPath);
                    this.effectiveCsvPath = this.executionContext.evalParameters(this.resultsCsvPath, this);
                    try {
                        File outputFile = new File(this.effectiveCsvPath);
                        if (!outputFile.getParentFile().exists()) {
                            outputFile.getParentFile().mkdirs();
                        }
                        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                        this.bufferedWriter.write("\ufeff");
                        this.effectiveCsvPath = outputFile.getAbsolutePath();
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot create file at default location.", (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    try {
                        this.writeCsvHeader();
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot write data to output file", (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                }
                this.addExecutionLog(this.iu.getFormattedString("GenerateDomainFieldsOperation.Log.Separator", (Object)this.separator));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDomainFieldsOperation.Log.MaxFieldsLength", (Object)this.maxFieldsLength));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDomainFieldsOperation.Log.FieldsToGenerate", (Object)this.getFieldsToGenerate()));
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(this.itemsToSearch, ItemsUtils.getPartitionerChunkSize(1000, this));
                try {
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        while (iterator.hasNext()) {
                            Item itemToSearch = (Item)iterator.next();
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            this.stageItems.incrementAndGet();
                            try {
                                Communication communication = itemToSearch.getCommunication();
                                if (communication == null) continue;
                                Domains domains = new Domains();
                                if (this.fieldDomainsAll) {
                                    ArrayList<Address> allAddresses = new ArrayList<Address>();
                                    allAddresses.addAll(communication.getTo());
                                    allAddresses.addAll(communication.getFrom());
                                    allAddresses.addAll(communication.getCc());
                                    allAddresses.addAll(communication.getBcc());
                                    domains.allDomains = NuixEmailUtils.getDomains(allAddresses);
                                }
                                if (this.fieldDomainsTo) {
                                    domains.toDomains = new HashSet<String>();
                                    domains.toDomains = NuixEmailUtils.getDomains(communication.getTo());
                                }
                                if (this.fieldDomainsFrom) {
                                    domains.fromDomains = new HashSet<String>();
                                    domains.fromDomains = NuixEmailUtils.getDomains(communication.getFrom());
                                }
                                if (this.fieldDomainsCc) {
                                    domains.ccDomains = new HashSet<String>();
                                    domains.ccDomains = NuixEmailUtils.getDomains(communication.getCc());
                                }
                                if (this.fieldDomainsBcc) {
                                    domains.bccDomains = new HashSet<String>();
                                    domains.bccDomains = NuixEmailUtils.getDomains(communication.getBcc());
                                }
                                if (this.fieldRecipientsCount) {
                                    HashSet recipients = new HashSet();
                                    recipients.addAll(communication.getTo());
                                    recipients.addAll(communication.getCc());
                                    recipients.addAll(communication.getBcc());
                                    domains.recipientsCount = recipients.size();
                                }
                                if (this.resultsOutputCustomMetadata) {
                                    this.updateItemMetadata(itemToSearch, domains);
                                }
                                if (!this.resultsOutputCsv) continue;
                                this.writeToCsv(itemToSearch, domains);
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot process item " + itemToSearch.getGuid() + ".", (Throwable)e);
                            }
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                }
                catch (WorkflowExecutionStopRequested e) {
                    this.trackStopped();
                    return;
                }
                catch (Exception e) {
                    LOGGER.warn("Exception thrown while processing items", (Throwable)e);
                }
                ++this.stageId;
                this.stageItems.set(0L);
                this.stageTotalItems.set(this.itemsToSearch.size());
                if (this.resultsOutputCsv) {
                    this.addExecutionLog(this.iu.getFormattedString("GenerateDomainFieldsOperation.Log.OutputCSV", (Object)this.effectiveCsvPath));
                    this.bufferedWriter.close();
                } else if (this.resultsOutputCustomMetadata) {
                    this.addExecutionLog(this.iu.getString("GenerateDomainFieldsOperation.Log.SetAsCustomMetadata"));
                }
                ++this.stageId;
                if (this.resultsOutputCsv) {
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_metadata_export_file}", this.effectiveCsvPath)));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", new File(this.effectiveCsvPath).getParentFile().getAbsolutePath())));
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void writeCsvHeader() throws IOException {
        if (this.originalFieldGuid) {
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDomainFieldsOperation.CSVHeader.ItemGUID")));
        }
        if (this.originalFieldDocIds) {
            if (this.originalFieldGuid) {
                this.bufferedWriter.write(",");
            }
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDomainFieldsOperation.CSVHeader.ItemDocIDs")));
        }
        if (this.fieldDomainsAll) {
            this.bufferedWriter.write(",");
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDomainFieldsOperation.CSVHeader.AllDomains")));
        }
        if (this.fieldDomainsTo) {
            this.bufferedWriter.write(",");
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDomainFieldsOperation.CSVHeader.ToDomains")));
        }
        if (this.fieldDomainsFrom) {
            this.bufferedWriter.write(",");
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDomainFieldsOperation.CSVHeader.FromDomains")));
        }
        if (this.fieldDomainsCc) {
            this.bufferedWriter.write(",");
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDomainFieldsOperation.CSVHeader.CCDomains")));
        }
        if (this.fieldDomainsBcc) {
            this.bufferedWriter.write(",");
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDomainFieldsOperation.CSVHeader.BCCDomains")));
        }
        if (this.fieldRecipientsCount) {
            this.bufferedWriter.write(",");
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDomainFieldsOperation.CSVHeader.RecipientCount")));
        }
    }

    private synchronized void writeToCsv(Item itemToUpdate, Domains guidDomain) throws IOException {
        String itemGuid = itemToUpdate.getGuid();
        Domains domains = guidDomain;
        if (domains != null) {
            TreeSet<String> sortedValues;
            this.bufferedWriter.write("\r\n");
            if (this.originalFieldGuid) {
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)itemGuid));
            }
            if (this.originalFieldDocIds) {
                if (this.originalFieldGuid) {
                    this.bufferedWriter.write(",");
                }
                StringBuilder docIds = new StringBuilder();
                boolean firstDocId = true;
                for (ProductionSetItem productionSetItem : itemToUpdate.getProductionSetItems()) {
                    if (firstDocId) {
                        firstDocId = false;
                    } else {
                        docIds.append(this.separator);
                    }
                    docIds.append(productionSetItem.getDocumentNumber().toString());
                }
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)docIds.toString()));
            }
            if (this.fieldDomainsAll) {
                sortedValues = new TreeSet<String>(domains.allDomains);
                String sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)sortedValuesRepresentation));
            }
            if (this.fieldDomainsTo) {
                sortedValues = new TreeSet<String>(domains.toDomains);
                String sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)sortedValuesRepresentation));
            }
            if (this.fieldDomainsFrom) {
                sortedValues = new TreeSet<String>(domains.fromDomains);
                String sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)sortedValuesRepresentation));
            }
            if (this.fieldDomainsCc) {
                sortedValues = new TreeSet<String>(domains.ccDomains);
                String sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)sortedValuesRepresentation));
            }
            if (this.fieldDomainsBcc) {
                sortedValues = new TreeSet<String>(domains.bccDomains);
                String sortedValuesRepresentation = FormattingUtils.join(sortedValues, (String)this.separator, (int)this.maxFieldsLength);
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)sortedValuesRepresentation));
            }
            if (this.fieldRecipientsCount) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)String.valueOf(domains.recipientsCount)));
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.stageType != null && this.stageType.equals((Object)StageType.BUILD_DICTIONARY) && this.stageTotalItems.get() != 0L) {
            stageProgress = (double)this.stageItems.get() / (double)this.stageTotalItems.get();
        } else if (this.stageTotalItems.get() != 0L) {
            stageProgress = (double)this.stageItems.get() / (double)this.stageTotalItems.get();
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.stageItems.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("GenerateDomainFieldsOperation.Progress.ItemsProcessed", this.stageItems.get());
        }
        return result;
    }

    class Domains {
        Set<String> allDomains;
        Set<String> fromDomains;
        Set<String> toDomains;
        Set<String> ccDomains;
        Set<String> bccDomains;
        int recipientsCount = 0;

        Domains() {
        }
    }

    static enum StageType {
        QUERY,
        BUILD_DICTIONARY;

    }
}

