/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldHelper;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.GenerateDuplicateFieldsOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.generateduplicatefields.DeduplicateBy;
import com.nuix.automate.workflow.core.execution.options.generateduplicatefields.EvaluationMethod;
import com.nuix.automate.workflow.core.execution.options.generateduplicatefields.FieldsInclusiveness;
import com.nuix.automate.workflow.core.execution.options.generateduplicatefields.ResultsOutput;
import com.nuix.automate.workflow.core.execution.options.itemset.DeduplicationMethod;
import java.text.SimpleDateFormat;
import java.util.List;
import org.joda.time.format.DateTimeFormat;

@FormFieldGroups(value={@FormFieldGroup(name="originalFieldsGroup", children={"originalFieldGuid", "originalFieldDocIds"}), @FormFieldGroup(name="duplicateFieldsGroup", children={"fieldCustodians", "fieldItemNames", "fieldItemDatesRow", "fieldPathsRow", "fieldTags", "fieldSubTagsRow", "fieldGuids", "fieldParentGuids", "fieldTopLevelParentGuids", "fieldDocIds", "fieldLowestFamilyDocId", "fieldMetadataProfileRow"}), @FormFieldGroup(name="outputResultsGroup", children={"saveToCsvRow", "resultsOutputCustomMetadata", "appendToPreviousMetadata"})})
@FormFieldRows(value={@FormFieldRow(name="fieldItemDatesRow", children={"fieldItemDates", "fieldItemDatesFormat"}), @FormFieldRow(name="fieldPathsRow", children={"fieldPaths", "omitEvidenceNameFromPaths"}), @FormFieldRow(name="fieldSubTagsRow", children={"fieldSubTags", "fieldSubTagsPrefix"}), @FormFieldRow(name="fieldMetadataProfileRow", children={"fieldMetadataProfile", "fieldMetadataProfileName"}), @FormFieldRow(name="saveToCsvRow", children={"resultsOutputCsv", "resultsCsvPath"})})
@OperationMetadata(alias=OperationAlias.GENERATE_DUPLICATE_FIELDS, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"DEDUPLICATION"})})
@OperationParameters(value={@OperationParameter(label="queryRetrieveCsvFile", parameter="{last_metadata_export_file}"), @OperationParameter(label="lastExportFolder", parameter="{last_export_folder}")})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class GenerateDuplicateFieldsOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenerateDuplicateFieldsOperationImplementation.class);
    @FormField(required=false)
    public String searchScope = "flag:audited";
    @FormField
    public String updateItemsScope = "has-production-set:1";
    @FormField
    public EvaluationMethod evaluationMethod;
    @FormField(visibleOn={@OnField(name="evaluationMethod", value={"MEMORY_INTENSIVE"})})
    public DeduplicateBy deduplicateBy = DeduplicateBy.FAMILY;
    @FormField(visibleOn={@OnField(name="evaluationMethod", value={"MEMORY_INTENSIVE"})})
    public DeduplicationMethod deduplicationMethod = DeduplicationMethod.MD5;
    @FormField
    public FieldsInclusiveness fieldsInclusiveness = FieldsInclusiveness.ALTERNATE;
    @FormField
    public String separator = "; ";
    @FormField(min=1.0)
    public int maxFieldsLength = 10000;
    @FormField
    public boolean originalFieldGuid = true;
    @FormField
    public boolean originalFieldDocIds = true;
    @FormField
    public boolean fieldCustodians = true;
    @FormField
    public boolean fieldItemNames = false;
    @FormField
    public boolean fieldItemDates = false;
    @FormField(enableOn={@OnField(name="fieldItemDates")}, positionLabel=@PositionLabel(left="format"), helpers={@FormFieldHelper(location="#_generate_duplicate_fields")})
    public String fieldItemDatesFormat = new SimpleDateFormat().toLocalizedPattern();
    @FormField
    public boolean fieldPaths = false;
    @FormField(enableOn={@OnField(name="fieldPaths")})
    public boolean omitEvidenceNameFromPaths = false;
    @FormField
    public boolean fieldTags = false;
    @FormField
    public boolean fieldSubTags = false;
    @FormField(enableOn={@OnField(name="fieldSubTags")}, positionLabel=@PositionLabel(left="prefix"))
    @ExcludeFromPrintableOptions
    public String fieldSubTagsPrefix = "";
    @FormField
    public boolean fieldGuids = false;
    @FormField
    public boolean fieldParentGuids = false;
    @FormField
    public boolean fieldTopLevelParentGuids = false;
    @FormField
    public boolean fieldDocIds = false;
    @FormField
    public boolean fieldLowestFamilyDocId = false;
    @FormField
    public boolean fieldMetadataProfile = false;
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.METADATA_PROFILES, enableOn={@OnField(name="fieldMetadataProfile")})
    @ExcludeFromPrintableOptions
    public String fieldMetadataProfileName = "";
    @FormField
    public boolean resultsOutputCsv = true;
    @FormField(enableOn={@OnField(name="resultsOutputCsv")})
    public String resultsCsvPath = "{case_folder}/Export/Duplicate Fields {date_time}.csv";
    @FormField
    public boolean resultsOutputCustomMetadata = false;
    @FormField(enableOn={@OnField(name="resultsOutputCustomMetadata")})
    public boolean appendToPreviousMetadata = false;
    public ResultsOutput resultsOutput = null;

    public boolean getDisplayFieldItemDatesFormat() {
        return this.fieldItemDates;
    }

    public boolean getDisplayOmitEvidenceNameFromPaths() {
        return this.fieldPaths;
    }

    public boolean getDisplayFieldMetadataProfileName() {
        return this.fieldMetadataProfile;
    }

    public GenerateDuplicateFieldsOperation() {
        this.evaluationMethod = EvaluationMethod.MEMORY_INTENSIVE;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("GenerateDuplicateFieldsOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.GENERATE_DUPLICATE_FIELDS;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.originalFieldGuid && !this.originalFieldDocIds) {
            prerequisites.add(this.iu.getString("GenerateDuplicateFieldsOperation.Prerequisites.AtLeastOneOriginalFieldMustBeSelected"));
        }
        if (this.fieldItemDates && this.fieldItemDatesFormat.trim().length() > 0 && !this.fieldItemDatesFormat.startsWith("{")) {
            try {
                DateTimeFormat.forPattern((String)this.fieldItemDatesFormat);
            }
            catch (IllegalArgumentException e) {
                prerequisites.add(this.iu.getString("GenerateDuplicateFieldsOperation.Prerequisites.InvalidDateFormatPattern"));
            }
        }
        if (!this.resultsOutputCsv && !this.resultsOutputCustomMetadata) {
            prerequisites.add(this.iu.getString("GenerateDuplicateFieldsOperation.Prerequisites.NoOutputMethodSelected"));
        }
        if (this.resultsOutputCsv && this.resultsCsvPath.trim().length() == 0) {
            prerequisites.add(this.iu.getString("GenerateDuplicateFieldsOperation.Prerequisites.OutputCSVMustBeSelected"));
        }
        if (this.maxFieldsLength <= 0) {
            prerequisites.add(this.iu.getString("GenerateDuplicateFieldsOperation.Prerequisites.MaxFieldLengthMustBeGreaterThanZero"));
        }
        return prerequisites;
    }
}

