/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.GenerateDuplicateFieldsOperation;
import com.nuix.automate.workflow.core.execution.options.generateduplicatefields.DeduplicateBy;
import com.nuix.automate.workflow.core.execution.options.generateduplicatefields.EvaluationMethod;
import com.nuix.automate.workflow.core.execution.options.generateduplicatefields.FieldsInclusiveness;
import com.nuix.automate.workflow.core.execution.options.itemset.DeduplicationMethod;
import com.nuix.automate.workflow.core.nuix.CustomDeduplicationField;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import nuix.ProductionSetItem;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class GenerateDuplicateFieldsOperationImplementation
extends GenerateDuplicateFieldsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenerateDuplicateFieldsOperation.class);
    private transient String stageName;
    private transient AtomicLong stageItems = new AtomicLong(0L);
    private transient AtomicLong stageTotalItems = new AtomicLong(0L);
    private transient int stageId;
    private transient int stageCount;
    private transient Map<String, DuplicateProperties> duplicatePropertiesMap;
    private transient boolean computeAllFields;
    private transient boolean computeAlternateFields;
    private transient int fieldSubTagsPrefixLength;
    private transient Map<String, String> guidToKey;
    private transient Set<Item> itemsToSearch;
    private transient Set<Item> itemsToUpdate;
    private transient Map<String, Set<String>> guidToDocId;
    private transient boolean isDocIdMapNeeded;
    private transient String effectiveCsvPath;
    private transient AtomicLong effectiveUpdatedItems = new AtomicLong(0L);
    private transient BufferedWriter bufferedWriter;
    private transient AtomicLong itemsWithoutMd5Count = new AtomicLong(0L);
    private transient AtomicLong itemsToUpdateWithoutMd5Count = new AtomicLong(0L);
    private transient MetadataProfile metadataProfile;
    private transient List<String> metadataProperties;
    private transient Set<String> rubyFieldNames;

    private String getFieldsToGenerate() {
        ArrayList<Object> fields = new ArrayList<Object>();
        if (this.fieldCustodians) {
            fields.add("Custodians");
        }
        if (this.fieldItemNames) {
            fields.add("Item Names");
        }
        if (this.fieldItemDates) {
            fields.add("Item Dates " + this.fieldItemDatesFormat);
        }
        if (this.fieldPaths) {
            fields.add(this.omitEvidenceNameFromPaths ? "Paths without Evidence Name" : "Paths");
        }
        if (this.fieldTags) {
            fields.add("Tags");
        }
        if (this.fieldSubTags) {
            fields.add("SubTags " + this.fieldSubTagsPrefix);
        }
        if (this.fieldGuids) {
            fields.add("Guids");
        }
        if (this.fieldParentGuids) {
            fields.add("ParentGuids");
        }
        if (this.fieldTopLevelParentGuids) {
            fields.add("TopLevelParentGuids");
        }
        if (this.fieldDocIds) {
            fields.add("DocIDs");
        }
        if (this.fieldLowestFamilyDocId) {
            fields.add("Lowest Family DocID");
        }
        if (this.fieldMetadataProfile) {
            fields.addAll(this.metadataProperties);
        }
        return String.join((CharSequence)"; ", fields);
    }

    private void runMemoryIntensive() {
        this.stageCount = 4;
        this.stageId = 0;
        this.stageItems.set(0L);
        if (this.resultsOutputCsv && this.resultsOutputCustomMetadata) {
            ++this.stageCount;
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                Set<Item> itemsToBuildFieldValuesOn;
                this.computeAllFields = this.fieldsInclusiveness == FieldsInclusiveness.ALL || this.fieldsInclusiveness == FieldsInclusiveness.ALL_ALTERNATE;
                this.computeAlternateFields = this.fieldsInclusiveness == FieldsInclusiveness.ALTERNATE || this.fieldsInclusiveness == FieldsInclusiveness.ALL_ALTERNATE;
                boolean isDocIdComputationRequired = this.fieldLowestFamilyDocId || this.originalFieldDocIds || this.fieldDocIds;
                this.isDocIdMapNeeded = isDocIdComputationRequired && this.executionContext.nuixVersion.compareTo(new Version("7.4.0")) < 0;
                this.duplicatePropertiesMap = new ConcurrentHashMap<String, DuplicateProperties>();
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.ScopeQuery", (Object)this.searchScope));
                String itemsToSearchQuery = NuixUtils.addAndQuery(this.searchScope, "has-exclusion:0");
                LOGGER.info("Searching for items in scope: " + itemsToSearchQuery);
                this.itemsToSearch = this.executionContext.nuixCase.searchUnsorted(itemsToSearchQuery);
                LOGGER.info("Got " + this.itemsToSearch.size() + " items");
                this.addExecutionLog(this.iu.getNumeralString("GenerateDuplicateFieldsOperation.Log.ScopeCount", (long)this.itemsToSearch.size()));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.UpdateItemsQuery", (Object)this.updateItemsScope));
                String itemsToUpdateQuery = NuixUtils.addAndQuery(this.updateItemsScope, "has-exclusion:0");
                LOGGER.info("Searching for items to update: " + itemsToUpdateQuery);
                this.itemsToUpdate = this.executionContext.nuixCase.searchUnsorted(itemsToUpdateQuery);
                LOGGER.info("Got " + this.itemsToUpdate.size() + " items");
                this.addExecutionLog(this.iu.getNumeralString("GenerateDuplicateFieldsOperation.Log.UpdateItemsCount", (long)this.itemsToUpdate.size()));
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.SearchingForItemsInScope");
                String itemsToUpdateOrSearchQuery = NuixUtils.addAndQuery(NuixUtils.addOrQueryString(this.updateItemsScope, this.searchScope), "has-exclusion:0");
                LOGGER.info("Searching for items to search or update: " + itemsToUpdateOrSearchQuery);
                Set<Item> itemsToUpdateOrSearch = this.executionContext.nuixCase.searchUnsorted(itemsToUpdateOrSearchQuery);
                LOGGER.info("Got " + itemsToUpdateOrSearch.size() + " items");
                this.executionContext.workflowExecution.checkMemoryUsage("Done searching for items in scope");
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.FindDuplicateItems", (Object)this.deduplicateBy));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.FindDuplicatesMethod", (Object)this.deduplicationMethod));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.ResultsInclusiveness", (Object)this.fieldsInclusiveness));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.Separator", (Object)this.separator));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.MaxFieldsLength", (Object)this.maxFieldsLength));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.FieldsToGenerate", (Object)this.getFieldsToGenerate()));
                CustomDeduplicationField customDeduplicationField = CustomDeduplicationField.getFromDeduplicationMethod(this.deduplicationMethod);
                if (customDeduplicationField != null) {
                    ++this.stageCount;
                    if (this.deduplicateBy == DeduplicateBy.FAMILY) {
                        LOGGER.info("Finding top-level items of items to search or update");
                        Set itemsToUpdateOrSearchTopLevel = this.executionContext.nuixUtilities.getItemUtility().findTopLevelItems((Collection)itemsToUpdateOrSearch);
                        LOGGER.info("Got " + itemsToUpdateOrSearchTopLevel.size() + " items");
                        LOGGER.info("Union of of top-level with original search");
                        Set itemsToUpdateOrSearchPlusTopLevel = this.executionContext.nuixUtilities.getItemUtility().union((Collection)itemsToUpdateOrSearch, (Collection)itemsToUpdateOrSearchTopLevel);
                        LOGGER.info("Got " + itemsToUpdateOrSearchPlusTopLevel.size() + " items");
                        LOGGER.info("Building Key dictionary");
                        this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.BuildingDictionary");
                        this.stageTotalItems.set(itemsToUpdateOrSearchPlusTopLevel.size());
                        this.guidToKey = ItemsUtils.guidToKey(itemsToUpdateOrSearchPlusTopLevel, customDeduplicationField, this.stageItems);
                    } else {
                        LOGGER.info("Building Key dictionary");
                        this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.BuildingDictionary");
                        this.stageTotalItems.set(itemsToUpdateOrSearch.size());
                        this.guidToKey = ItemsUtils.guidToKey((Collection<Item>)itemsToUpdateOrSearch, customDeduplicationField, this.stageItems);
                    }
                    ++this.stageId;
                }
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.stageItems.set(0L);
                this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.DiscoveringItemsInScope");
                LOGGER.info("Discovering " + this.itemsToUpdate.size() + " items in scope");
                this.stageTotalItems.set(this.itemsToUpdate.size());
                this.itemsWithoutMd5Count.set(0L);
                this.executionContext.workflowExecution.checkMemoryUsage("Done discovering items in scope");
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(this.itemsToUpdate, ItemsUtils.getPartitionerChunkSize(1000, this));
                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                    if (this.stopRequested) {
                        return;
                    }
                    while (iterator.hasNext()) {
                        Item itemToUpdate = (Item)iterator.next();
                        String deduplicationKey = this.getItemKey(itemToUpdate);
                        if (deduplicationKey != null && deduplicationKey.length() > 0) {
                            if (this.metadataProperties != null) {
                                this.duplicatePropertiesMap.put(deduplicationKey, new DuplicateProperties(this.metadataProperties));
                            } else {
                                this.duplicatePropertiesMap.put(deduplicationKey, new DuplicateProperties());
                            }
                        }
                        this.stageItems.incrementAndGet();
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                this.itemsToUpdateWithoutMd5Count.set(this.itemsWithoutMd5Count.longValue());
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (this.isDocIdMapNeeded) {
                    LOGGER.info("Building guids to DocId mapping for items to update, items searches");
                    this.guidToDocId = ItemsUtils.getItemGuidToDocIdsDictionary(this.executionContext.nuixCase, itemsToUpdateOrSearch);
                    this.addWarning(this.iu.getString("GenerateDuplicateFieldsOperation.Warning.DocIdComputationInNuixVersionsBelowHasHighMemoryUsage"));
                }
                ++this.stageId;
                this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.ComputingDuplicateFields");
                this.stageItems.set(0L);
                if (this.computeAllFields) {
                    LOGGER.info("Building field values on itemsToUpdateOrSearchPlusTopLevel");
                    itemsToBuildFieldValuesOn = itemsToUpdateOrSearch;
                } else {
                    LOGGER.info("Building field values on itemsToSearch");
                    itemsToBuildFieldValuesOn = this.itemsToSearch;
                }
                this.stageTotalItems.set(itemsToBuildFieldValuesOn.size());
                LOGGER.info("Building fields values for " + itemsToBuildFieldValuesOn.size() + " items");
                if (!this.fieldSubTagsPrefix.endsWith("|")) {
                    this.fieldSubTagsPrefix = this.fieldSubTagsPrefix + "|";
                }
                this.fieldSubTagsPrefixLength = this.fieldSubTagsPrefix.length();
                if (this.fieldSubTags && this.fieldSubTagsPrefixLength == 0) {
                    this.fieldSubTags = false;
                    this.fieldTags = true;
                }
                if (this.fieldItemDates) {
                    try {
                        DateTimeFormat.forPattern((String)this.fieldItemDatesFormat);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Warning.InvalidDateFormatDefaulted", (Object)this.fieldItemDatesFormat), e);
                    }
                }
                partitioner = new FixedSizeChunkPartitioner(itemsToBuildFieldValuesOn, ItemsUtils.getPartitionerChunkSize(1000, this));
                try {
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        while (iterator.hasNext()) {
                            block33: {
                                Item itemToSearch = (Item)iterator.next();
                                try {
                                    Item topLevelItem;
                                    String guid;
                                    DateTime itemDate;
                                    String itemName;
                                    String custodian;
                                    DuplicateProperties duplicateProperties;
                                    if (this.deduplicateBy == DeduplicateBy.TOP_LEVEL_ITEM && !itemToSearch.isTopLevel()) continue;
                                    String deduplicationKey = this.getItemKey(itemToSearch);
                                    if (deduplicationKey == null || (duplicateProperties = this.duplicatePropertiesMap.get(deduplicationKey)) == null) break block33;
                                    if (this.fieldCustodians && (custodian = itemToSearch.getCustodian()) != null) {
                                        duplicateProperties.custodians.add(custodian);
                                    }
                                    if (this.fieldItemNames && (itemName = itemToSearch.getName()) != null) {
                                        duplicateProperties.itemNames.add(itemToSearch.getName());
                                    }
                                    if (this.fieldItemDates && (itemDate = itemToSearch.getDate()) != null) {
                                        String formattedDate = this.getFormattedDate(itemDate);
                                        duplicateProperties.itemDates.add(formattedDate);
                                    }
                                    if (this.fieldPaths) {
                                        String path = this.omitEvidenceNameFromPaths ? ItemsUtils.getItemPathWithoutEvidenceName(itemToSearch) : ItemsUtils.getItemPath(itemToSearch);
                                        duplicateProperties.paths.add(path);
                                    }
                                    if (this.fieldTags) {
                                        duplicateProperties.tags.addAll(itemToSearch.getTags());
                                    }
                                    if (this.fieldSubTags) {
                                        for (String tag : itemToSearch.getTags()) {
                                            if (!tag.startsWith(this.fieldSubTagsPrefix)) continue;
                                            duplicateProperties.subTags.add(tag.substring(this.fieldSubTagsPrefixLength));
                                        }
                                    }
                                    if (this.fieldGuids && (guid = itemToSearch.getGuid()) != null) {
                                        duplicateProperties.guids.add(guid);
                                    }
                                    if (this.fieldParentGuids) {
                                        guid = null;
                                        try {
                                            guid = ((Item)itemToSearch.getParent()).getGuid();
                                        }
                                        catch (Exception e) {
                                            LOGGER.info("Cannot get item parent guid " + itemToSearch.getGuid(), (Throwable)e);
                                        }
                                        if (guid != null) {
                                            duplicateProperties.parentGuids.add(guid);
                                        }
                                    }
                                    if (this.fieldTopLevelParentGuids) {
                                        guid = null;
                                        try {
                                            guid = ((Item)itemToSearch.getTopLevelItem().getParent()).getGuid();
                                        }
                                        catch (Exception e) {
                                            LOGGER.info("Cannot get item top-level parent guid " + itemToSearch.getGuid(), (Throwable)e);
                                        }
                                        if (guid != null) {
                                            duplicateProperties.topLevelParentGuids.add(guid);
                                        }
                                    }
                                    if (this.fieldDocIds) {
                                        if (this.isDocIdMapNeeded) {
                                            Set<String> docIds = this.guidToDocId.get(itemToSearch.getGuid());
                                            if (docIds != null) {
                                                duplicateProperties.docIds.addAll((Collection<String>)docIds);
                                            }
                                        } else {
                                            for (ProductionSetItem productionSetItem : itemToSearch.getProductionSetItems()) {
                                                duplicateProperties.docIds.add(productionSetItem.getDocumentNumber().toString());
                                            }
                                        }
                                    }
                                    if (this.fieldLowestFamilyDocId && (topLevelItem = itemToSearch.getTopLevelItem()) != null) {
                                        if (this.isDocIdMapNeeded) {
                                            Set<String> familyDocIds = this.guidToDocId.get(topLevelItem.getGuid());
                                            if (familyDocIds != null) {
                                                duplicateProperties.familyDocIds.addAll(familyDocIds);
                                            }
                                        } else {
                                            for (ProductionSetItem productionSetItem : topLevelItem.getProductionSetItems()) {
                                                duplicateProperties.familyDocIds.add(productionSetItem.getDocumentNumber().toString());
                                            }
                                        }
                                    }
                                    if (!this.fieldMetadataProfile) break block33;
                                    int i = 0;
                                    for (MetadataItem metadataItem : this.metadataProfile.getMetadata()) {
                                        try {
                                            String value = MetadataItemUtils.evaluate(metadataItem, itemToSearch, this.rubyFieldNames);
                                            duplicateProperties.metadataProfile.get(i).add(value);
                                        }
                                        catch (Exception e) {
                                            LOGGER.info("Cannot evaluate metadata " + metadataItem.getLocalisedName() + " for item " + itemToSearch.getGuid(), (Throwable)e);
                                        }
                                        ++i;
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Cannot build fields value for item " + itemToSearch.getGuid(), (Throwable)e);
                                    this.addWarning(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Warning.ErrorProcessingItem", new Object[]{itemToSearch.getGuid(), e.getLocalizedMessage()}));
                                }
                            }
                            this.stageItems.incrementAndGet();
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                }
                catch (Exception e) {
                    LOGGER.warn("Exception thrown while processing items", (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Warning.ErrorProcessingItems", (Object)e.getLocalizedMessage()));
                }
                this.executionContext.workflowExecution.checkMemoryUsage("Done building field values");
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                ++this.stageId;
                this.stageItems.set(0L);
                this.stageTotalItems.set(this.itemsToUpdate.size());
                if (this.resultsOutputCsv) {
                    this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.WritingCSVFile");
                    LOGGER.info("Unpacking path: " + this.resultsCsvPath);
                    this.effectiveCsvPath = this.executionContext.evalParameters(this.resultsCsvPath, this);
                    this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.OutputCSV", (Object)this.effectiveCsvPath));
                    try {
                        File outputFile = new File(this.effectiveCsvPath);
                        if (!outputFile.getParentFile().exists()) {
                            outputFile.getParentFile().mkdirs();
                        }
                        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                        this.bufferedWriter.write("\ufeff");
                        this.effectiveCsvPath = outputFile.getAbsolutePath();
                    }
                    catch (IOException e1) {
                        LOGGER.error("Cannot create file at default location.", (Throwable)e1);
                        this.exception = e1;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    try {
                        this.writeCsvHeader();
                        partitioner = new FixedSizeChunkPartitioner(this.itemsToUpdate, ItemsUtils.getPartitionerChunkSize(1000, this));
                        Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            while (iterator.hasNext()) {
                                Item itemToUpdate = (Item)iterator.next();
                                if (this.stopRequested) {
                                    this.trackStopped();
                                    return;
                                }
                                try {
                                    StringBuilder stringBuilder = this.itemToCsvLine(itemToUpdate);
                                    BufferedWriter bufferedWriter = this.bufferedWriter;
                                    synchronized (bufferedWriter) {
                                        this.stageItems.incrementAndGet();
                                        try {
                                            this.bufferedWriter.append(stringBuilder);
                                        }
                                        catch (IOException e1) {
                                            LOGGER.error("Cannot write data to output file", (Throwable)e1);
                                            this.exception = e1;
                                            this.executionState = ExecutionState.ERROR;
                                            return;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("", (Throwable)e);
                                }
                            }
                        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                        this.bufferedWriter.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot write data to output file", (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    if (this.resultsOutputCustomMetadata) {
                        this.effectiveUpdatedItems.set(0L);
                        this.itemsWithoutMd5Count.set(0L);
                    }
                    ++this.stageId;
                    this.stageItems.set(0L);
                    this.stageTotalItems.set(this.itemsToUpdate.size());
                    this.executionContext.workflowExecution.checkMemoryUsage("Done writing CSV");
                }
                if (this.resultsOutputCustomMetadata) {
                    this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.AssigningFieldValues");
                    this.stageTotalItems.set(this.itemsToUpdate.size());
                    LOGGER.info("Assigning field values to " + this.itemsToUpdate.size() + " items");
                    this.addExecutionLog(this.iu.getString("GenerateDuplicateFieldsOperation.Log.SetAsCustomMetadata"));
                    if (this.appendToPreviousMetadata) {
                        this.addExecutionLog(this.iu.getString("GenerateDuplicateFieldsOperation.Log.AppendMetadataToPreviousValues"));
                    }
                    partitioner = new FixedSizeChunkPartitioner(this.itemsToUpdate, ItemsUtils.getPartitionerChunkSize(1000, this));
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        while (iterator.hasNext()) {
                            Item item = (Item)iterator.next();
                            this.updateItemsCustomMetadataFields(item);
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                    this.executionContext.workflowExecution.checkMemoryUsage("Done assigning metadata");
                }
                this.addExecutionLog(this.iu.getNumeralString("GenerateDuplicateFieldsOperation.Log.UpdateItemsEffectiveSize", this.effectiveUpdatedItems.get()));
                LOGGER.info("Reporting on items without MD5: " + String.valueOf(this.itemsToUpdateWithoutMd5Count));
                if (this.itemsToUpdateWithoutMd5Count.longValue() > 0L) {
                    if (this.deduplicateBy == DeduplicateBy.FAMILY) {
                        this.addWarning(this.iu.getNumeralFormattedString("GenerateDuplicateFieldsOperation.Warning.TopLevelMD5HashValues", this.itemsToUpdateWithoutMd5Count.get(), new Object[]{this.itemsToUpdateWithoutMd5Count.get() == 1L ? "does" : "do", this.itemsWithoutMd5Count.get() == 1L ? "was" : "were"}));
                    } else {
                        this.addWarning(this.iu.getNumeralFormattedString("GenerateDuplicateFieldsOperation.Warning.NotHaveMD5HashValues", this.itemsToUpdateWithoutMd5Count.get(), new Object[]{this.itemsToUpdateWithoutMd5Count.get() == 1L ? "does" : "do", this.itemsWithoutMd5Count.get() == 1L ? "was" : "were"}));
                    }
                }
                if (this.resultsOutputCsv) {
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_metadata_export_file}", this.effectiveCsvPath)));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", new File(this.effectiveCsvPath).getParentFile().getAbsolutePath())));
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void runComputeIntensive() {
        this.stageCount = 1;
        this.stageId = 0;
        this.stageItems.set(0L);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.computeAllFields = this.fieldsInclusiveness == FieldsInclusiveness.ALL || this.fieldsInclusiveness == FieldsInclusiveness.ALL_ALTERNATE;
                this.computeAlternateFields = this.fieldsInclusiveness == FieldsInclusiveness.ALTERNATE || this.fieldsInclusiveness == FieldsInclusiveness.ALL_ALTERNATE;
                boolean isDocIdComputationRequired = this.fieldLowestFamilyDocId || this.originalFieldDocIds || this.fieldDocIds;
                this.duplicatePropertiesMap = new ConcurrentHashMap<String, DuplicateProperties>();
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.ScopeQuery", (Object)this.searchScope));
                String itemsToSearchQuery = NuixUtils.addAndQuery(this.searchScope, "has-exclusion:0");
                LOGGER.info("Searching for items in scope: " + itemsToSearchQuery);
                this.itemsToSearch = this.executionContext.nuixCase.searchUnsorted(itemsToSearchQuery);
                LOGGER.info("Got " + this.itemsToSearch.size() + " items");
                this.addExecutionLog(this.iu.getNumeralString("GenerateDuplicateFieldsOperation.Log.ScopeCount", (long)this.itemsToSearch.size()));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.UpdateItemsQuery", (Object)this.updateItemsScope));
                String itemsToUpdateQuery = NuixUtils.addAndQuery(this.updateItemsScope, "has-exclusion:0");
                LOGGER.info("Searching for items to update: " + itemsToUpdateQuery);
                this.itemsToUpdate = this.executionContext.nuixCase.searchUnsorted(itemsToUpdateQuery);
                LOGGER.info("Got " + this.itemsToUpdate.size() + " items");
                this.addExecutionLog(this.iu.getNumeralString("GenerateDuplicateFieldsOperation.Log.UpdateItemsCount", (long)this.itemsToUpdate.size()));
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.SearchingForItemsInScope");
                String itemsToUpdateOrSearchQuery = NuixUtils.addAndQuery(NuixUtils.addOrQueryString(this.updateItemsScope, this.searchScope), "has-exclusion:0");
                LOGGER.info("Searching for items to search or update: " + itemsToUpdateOrSearchQuery);
                Set itemsToUpdateOrSearch = this.executionContext.nuixCase.searchUnsorted(itemsToUpdateOrSearchQuery);
                LOGGER.info("Got " + itemsToUpdateOrSearch.size() + " items");
                this.executionContext.workflowExecution.checkMemoryUsage("Done searching for items in scope");
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.FindDuplicateItems", (Object)this.deduplicateBy));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.FindDuplicatesMethod", (Object)this.deduplicationMethod));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.ResultsInclusiveness", (Object)this.fieldsInclusiveness));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.Separator", (Object)this.separator));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.MaxFieldsLength", (Object)this.maxFieldsLength));
                this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.FieldsToGenerate", (Object)this.getFieldsToGenerate()));
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.stageItems.set(0L);
                this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.ComputingDuplicateFields");
                LOGGER.info("Discovering " + this.itemsToUpdate.size() + " items in scope");
                this.stageTotalItems.set(this.itemsToUpdate.size());
                this.itemsWithoutMd5Count.set(0L);
                if (!this.fieldSubTagsPrefix.endsWith("|")) {
                    this.fieldSubTagsPrefix = this.fieldSubTagsPrefix + "|";
                }
                this.fieldSubTagsPrefixLength = this.fieldSubTagsPrefix.length();
                if (this.fieldSubTags && this.fieldSubTagsPrefixLength == 0) {
                    this.fieldSubTags = false;
                    this.fieldTags = true;
                }
                if (this.fieldItemDates) {
                    try {
                        DateTimeFormat.forPattern((String)this.fieldItemDatesFormat);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Warning.InvalidDateFormatDefaulted", (Object)this.fieldItemDatesFormat), e);
                    }
                }
                if (this.resultsOutputCsv) {
                    this.stageName = this.iu.getString("GenerateDuplicateFieldsOperation.Stage.WritingCSVFile");
                    LOGGER.info("Unpacking path: " + this.resultsCsvPath);
                    this.effectiveCsvPath = this.executionContext.evalParameters(this.resultsCsvPath, this);
                    this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.OutputCSV", (Object)this.effectiveCsvPath));
                    try {
                        File outputFile = new File(this.effectiveCsvPath);
                        if (!outputFile.getParentFile().exists()) {
                            outputFile.getParentFile().mkdirs();
                        }
                        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                        this.bufferedWriter.write("\ufeff");
                        this.effectiveCsvPath = outputFile.getAbsolutePath();
                    }
                    catch (IOException e1) {
                        LOGGER.error("Cannot create file at default location.", (Throwable)e1);
                        this.exception = e1;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    try {
                        this.writeCsvHeader();
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot write data to output file", (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                }
                AtomicLong itemsWithoutFamily = new AtomicLong(0L);
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(this.itemsToUpdate, ItemsUtils.getPartitionerChunkSize(1000, this));
                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                    if (this.stopRequested) {
                        return;
                    }
                    while (iterator.hasNext()) {
                        if (this.stopRequested) {
                            return;
                        }
                        Item itemToUpdate = (Item)iterator.next();
                        if (!itemToUpdate.isTopLevel()) continue;
                        List duplicateItems = itemToUpdate.getDuplicates();
                        ArrayList<Item> duplicatesAndItem = new ArrayList<Item>(duplicateItems);
                        duplicatesAndItem.add(itemToUpdate);
                        DuplicateProperties duplicateProperties = this.metadataProperties != null ? new DuplicateProperties(this.metadataProperties) : new DuplicateProperties();
                        for (Item itemToSearch : duplicatesAndItem) {
                            if (!itemToSearch.isTopLevel() || !this.itemsToSearch.contains(itemToSearch)) continue;
                            try {
                                Item topLevelSearchItem;
                                String guid;
                                DateTime itemDate;
                                String itemName;
                                String custodian;
                                if (this.fieldCustodians && (custodian = itemToSearch.getCustodian()) != null) {
                                    duplicateProperties.custodians.add(custodian);
                                }
                                if (this.fieldItemNames && (itemName = itemToSearch.getName()) != null) {
                                    duplicateProperties.itemNames.add(itemToSearch.getName());
                                }
                                if (this.fieldItemDates && (itemDate = itemToSearch.getDate()) != null) {
                                    String formattedDate = this.getFormattedDate(itemDate);
                                    duplicateProperties.itemDates.add(formattedDate);
                                }
                                if (this.fieldPaths) {
                                    String path = this.omitEvidenceNameFromPaths ? ItemsUtils.getItemPathWithoutEvidenceName(itemToSearch) : ItemsUtils.getItemPath(itemToSearch);
                                    duplicateProperties.paths.add(path);
                                }
                                if (this.fieldTags) {
                                    duplicateProperties.tags.addAll(itemToSearch.getTags());
                                }
                                if (this.fieldSubTags) {
                                    for (String tag : itemToSearch.getTags()) {
                                        if (!tag.startsWith(this.fieldSubTagsPrefix)) continue;
                                        duplicateProperties.subTags.add(tag.substring(this.fieldSubTagsPrefixLength));
                                    }
                                }
                                if (this.fieldGuids && (guid = itemToSearch.getGuid()) != null) {
                                    duplicateProperties.guids.add(guid);
                                }
                                if (this.fieldParentGuids) {
                                    guid = null;
                                    try {
                                        guid = ((Item)itemToSearch.getParent()).getGuid();
                                    }
                                    catch (Exception e) {
                                        LOGGER.info("Cannot get item parent guid " + itemToSearch.getGuid(), (Throwable)e);
                                    }
                                    if (guid != null) {
                                        duplicateProperties.parentGuids.add(guid);
                                    }
                                }
                                if (this.fieldTopLevelParentGuids) {
                                    guid = null;
                                    try {
                                        guid = ((Item)itemToSearch.getTopLevelItem().getParent()).getGuid();
                                    }
                                    catch (Exception e) {
                                        LOGGER.info("Cannot get item top-level parent guid " + itemToSearch.getGuid(), (Throwable)e);
                                    }
                                    if (guid != null) {
                                        duplicateProperties.topLevelParentGuids.add(guid);
                                    }
                                }
                                if (this.fieldDocIds) {
                                    if (this.isDocIdMapNeeded) {
                                        Set<String> docIds = this.guidToDocId.get(itemToSearch.getGuid());
                                        if (docIds != null) {
                                            duplicateProperties.docIds.addAll((Collection<String>)docIds);
                                        }
                                    } else {
                                        for (ProductionSetItem productionSetItem : itemToSearch.getProductionSetItems()) {
                                            duplicateProperties.docIds.add(productionSetItem.getDocumentNumber().toString());
                                        }
                                    }
                                }
                                if (this.fieldLowestFamilyDocId && (topLevelSearchItem = itemToSearch.getTopLevelItem()) != null) {
                                    if (this.isDocIdMapNeeded) {
                                        Set<String> familyDocIds = this.guidToDocId.get(topLevelSearchItem.getGuid());
                                        if (familyDocIds != null) {
                                            duplicateProperties.familyDocIds.addAll((Collection<String>)familyDocIds);
                                        }
                                    } else {
                                        for (ProductionSetItem productionSetItem : topLevelSearchItem.getProductionSetItems()) {
                                            duplicateProperties.familyDocIds.add(productionSetItem.getDocumentNumber().toString());
                                        }
                                    }
                                }
                                if (!this.fieldMetadataProfile) continue;
                                int i = 0;
                                for (MetadataItem metadataItem : this.metadataProfile.getMetadata()) {
                                    try {
                                        String value = MetadataItemUtils.evaluate(metadataItem, itemToSearch, this.rubyFieldNames);
                                        duplicateProperties.metadataProfile.get(i).add(value);
                                    }
                                    catch (Exception e) {
                                        LOGGER.info("Cannot evaluate metadata " + metadataItem.getLocalisedName() + " for item " + itemToSearch.getGuid(), (Throwable)e);
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot build fields value for item " + itemToSearch.getGuid(), (Throwable)e);
                                this.addWarning(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Warning.ErrorProcessingItem", new Object[]{itemToSearch.getGuid(), e.getLocalizedMessage()}));
                            }
                        }
                        StringBuilder tlProperties = new StringBuilder();
                        if (this.resultsOutputCsv) {
                            try {
                                StringBuilder stringBuilder = new StringBuilder();
                                this.writeGuidAndDocIdToCsvLine(itemToUpdate, stringBuilder);
                                this.writeDuplicateFieldsToCsvLine(itemToUpdate, tlProperties, duplicateProperties);
                                BufferedWriter e = this.bufferedWriter;
                                synchronized (e) {
                                    this.stageItems.incrementAndGet();
                                    try {
                                        this.bufferedWriter.append(stringBuilder);
                                        this.bufferedWriter.append(tlProperties);
                                    }
                                    catch (IOException e1) {
                                        LOGGER.error("Cannot write data to output file", (Throwable)e1);
                                        this.exception = e1;
                                        this.executionState = ExecutionState.ERROR;
                                        return;
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot write item CSV line", (Throwable)e);
                            }
                        }
                        if (this.resultsOutputCustomMetadata) {
                            this.updateItemsCustomMetadataFields(itemToUpdate, itemToUpdate, duplicateProperties);
                        }
                        this.effectiveUpdatedItems.incrementAndGet();
                        for (Item familyItem : itemToUpdate.getDescendants()) {
                            if (!this.itemsToUpdate.contains(familyItem)) continue;
                            this.stageItems.incrementAndGet();
                            if (this.resultsOutputCsv) {
                                try {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    this.writeGuidAndDocIdToCsvLine(familyItem, stringBuilder);
                                    BufferedWriter bufferedWriter = this.bufferedWriter;
                                    synchronized (bufferedWriter) {
                                        try {
                                            this.bufferedWriter.append(stringBuilder);
                                            this.bufferedWriter.append(tlProperties);
                                        }
                                        catch (IOException e1) {
                                            LOGGER.error("Cannot write data to output file", (Throwable)e1);
                                            this.exception = e1;
                                            this.executionState = ExecutionState.ERROR;
                                            return;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Cannot write item CSV line", (Throwable)e);
                                }
                            }
                            if (this.resultsOutputCustomMetadata) {
                                this.updateItemsCustomMetadataFields(familyItem, itemToUpdate, duplicateProperties);
                            }
                            this.effectiveUpdatedItems.incrementAndGet();
                        }
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                if (this.resultsOutputCsv) {
                    try {
                        this.bufferedWriter.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot write data to output file", (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                }
                this.addExecutionLog(this.iu.getNumeralString("GenerateDuplicateFieldsOperation.Log.UpdateItemsEffectiveSize", this.effectiveUpdatedItems.get()));
                LOGGER.info("Reporting on items without families: " + String.valueOf(itemsWithoutFamily));
                if (itemsWithoutFamily.longValue() > 0L) {
                    this.addWarning(this.iu.getNumeralString("GenerateDuplicateFieldsOperation.Warning.ItemsWithoutFamily", itemsWithoutFamily.get()));
                }
                if (this.resultsOutputCsv) {
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_metadata_export_file}", this.effectiveCsvPath)));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", new File(this.effectiveCsvPath).getParentFile().getAbsolutePath())));
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void startTriggered() throws Exception {
        this.searchScope = this.executionContext.evalParameters(this.searchScope, this);
        this.updateItemsScope = this.executionContext.evalParameters(this.updateItemsScope, this);
        this.fieldItemDatesFormat = this.executionContext.evalParameters(this.fieldItemDatesFormat, this);
        this.fieldSubTagsPrefix = this.executionContext.evalParameters(this.fieldSubTagsPrefix, this);
        this.separator = this.executionContext.evalParameters(this.separator, this);
        if (this.fieldMetadataProfile) {
            this.metadataProfile = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.fieldMetadataProfileName);
            if (this.metadataProfile == null) {
                this.exception = new Exception(this.iu.getFormattedString("MetadataExportOperation.Warning.CannotFindMetadataProfile", (Object)this.metadataProfile));
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.metadataProperties = new ArrayList<String>();
            this.rubyFieldNames = new TreeSet<String>();
            for (MetadataItem metadataItem : this.metadataProfile.getMetadata()) {
                this.metadataProperties.add(metadataItem.getLocalisedName());
                if (!MetadataItemUtils.isRubyScript(metadataItem)) continue;
                this.rubyFieldNames.add(metadataItem.getName());
                LOGGER.info("Field " + metadataItem.getName() + " is scripted Ruby field");
            }
            if (this.rubyFieldNames.size() > 0) {
                this.addWarning(this.iu.getFormattedString("MetadataExportOperation.Warning.RubyFields", (Object)String.join((CharSequence)", ", this.rubyFieldNames)));
            }
        }
        this.executionContext.closeAllTabs();
        this.addExecutionLog(this.iu.getFormattedString("GenerateDuplicateFieldsOperation.Log.EvaluationMethod", (Object)this.evaluationMethod));
        if (this.evaluationMethod.equals((Object)EvaluationMethod.COMPUTE_INTENSIVE)) {
            this.runComputeIntensive();
        } else {
            this.runMemoryIntensive();
        }
    }

    private String getItemKey(Item item) {
        if (this.deduplicationMethod == DeduplicationMethod.MD5) {
            if (this.deduplicateBy == DeduplicateBy.FAMILY) {
                String itemKey;
                String topLevelKey;
                Item topLevelItem = item.getTopLevelItem();
                if (topLevelItem == null) {
                    topLevelItem = item;
                }
                if ((topLevelKey = topLevelItem.getDigests().getMd5()) == null || topLevelKey.length() == 0) {
                    topLevelKey = topLevelItem.getGuid();
                    this.itemsWithoutMd5Count.incrementAndGet();
                }
                if (!topLevelItem.equals(item)) {
                    StringBuilder nameInsideFamily = new StringBuilder(item.getName());
                    Item familyPointer = item;
                    nameInsideFamily.append("/").append(item.getName());
                    String itemMd5 = item.getDigests().getMd5();
                    if (itemMd5 != null) {
                        nameInsideFamily.append("-").append(itemMd5);
                    }
                    familyPointer = (Item)familyPointer.getParent();
                    while (!topLevelItem.equals(familyPointer)) {
                        nameInsideFamily.append("/").append(familyPointer.getName());
                        String familyPointerMd5 = familyPointer.getDigests().getMd5();
                        if (familyPointerMd5 != null) {
                            nameInsideFamily.append("-").append(familyPointerMd5);
                        }
                        familyPointer = (Item)familyPointer.getParent();
                    }
                    itemKey = nameInsideFamily.toString();
                } else {
                    itemKey = "";
                }
                return topLevelKey + "-" + itemKey;
            }
            if (this.deduplicateBy == DeduplicateBy.INDIVIDUAL) {
                String key = item.getDigests().getMd5();
                if (key == null || key.length() == 0) {
                    key = item.getGuid();
                    this.itemsWithoutMd5Count.incrementAndGet();
                }
                return key;
            }
            if (this.deduplicateBy == DeduplicateBy.TOP_LEVEL_ITEM) {
                String key;
                Item topLevelItem = item.getTopLevelItem();
                if (topLevelItem == null) {
                    topLevelItem = item;
                }
                if ((key = topLevelItem.getDigests().getMd5()) == null || key.length() == 0) {
                    key = topLevelItem.getGuid();
                    this.itemsWithoutMd5Count.incrementAndGet();
                }
                return key;
            }
        } else if (this.deduplicationMethod == DeduplicationMethod.MD5_PER_CUSTODIAN) {
            if (this.deduplicateBy == DeduplicateBy.FAMILY) {
                String itemKey;
                Object topLevelKey;
                String md5;
                String custodian;
                Item topLevelItem = item.getTopLevelItem();
                if (topLevelItem == null) {
                    topLevelItem = item;
                }
                if ((custodian = topLevelItem.getCustodian()) == null) {
                    custodian = "";
                }
                if ((md5 = topLevelItem.getDigests().getMd5()) == null || md5.length() == 0) {
                    topLevelKey = topLevelItem.getGuid();
                    this.itemsWithoutMd5Count.incrementAndGet();
                } else {
                    topLevelKey = custodian + md5;
                }
                if (!topLevelItem.equals(item)) {
                    Object nameInsideFamily = item.getName();
                    Item familyPointer = item;
                    while (!topLevelItem.equals(familyPointer)) {
                        familyPointer = (Item)familyPointer.getParent();
                        nameInsideFamily = (String)nameInsideFamily + "/" + familyPointer.getName();
                    }
                    itemKey = nameInsideFamily;
                } else {
                    itemKey = "";
                }
                return (String)topLevelKey + "-" + itemKey;
            }
            if (this.deduplicateBy == DeduplicateBy.INDIVIDUAL) {
                Object key;
                String md5;
                String custodian = item.getCustodian();
                if (custodian == null) {
                    custodian = "";
                }
                if ((md5 = item.getDigests().getMd5()) == null || md5.length() == 0) {
                    key = item.getGuid();
                    this.itemsWithoutMd5Count.incrementAndGet();
                } else {
                    key = custodian + md5;
                }
                return key;
            }
            if (this.deduplicateBy == DeduplicateBy.TOP_LEVEL_ITEM) {
                Object key;
                String md5;
                String custodian;
                Item topLevelItem = item.getTopLevelItem();
                if (topLevelItem == null) {
                    topLevelItem = item;
                }
                if ((custodian = topLevelItem.getCustodian()) == null) {
                    custodian = "";
                }
                if ((md5 = topLevelItem.getDigests().getMd5()) == null || md5.length() == 0) {
                    key = topLevelItem.getGuid();
                    this.itemsWithoutMd5Count.incrementAndGet();
                } else {
                    key = custodian + md5;
                }
                return key;
            }
        } else if (this.deduplicationMethod == DeduplicationMethod.MESSAGE_ID || this.deduplicationMethod == DeduplicationMethod.MESSAGE_ID_MD5 || this.deduplicationMethod == DeduplicationMethod.MESSAGE_ID_MD5_CUSTODIAN || this.deduplicationMethod == DeduplicationMethod.MAPI_SEARCH_KEY) {
            if (this.deduplicateBy == DeduplicateBy.FAMILY) {
                String itemKey;
                String topLevelKey;
                Item topLevelItem = item.getTopLevelItem();
                if (topLevelItem == null) {
                    topLevelItem = item;
                }
                if ((topLevelKey = this.guidToKey.get(topLevelItem.getGuid())) == null || topLevelKey.length() == 0) {
                    return null;
                }
                if (!topLevelItem.equals(item)) {
                    StringBuilder nameInsideFamily = new StringBuilder(item.getName());
                    for (Item familyPointer = (Item)item.getParent(); familyPointer != null && !topLevelItem.equals(familyPointer); familyPointer = (Item)familyPointer.getParent()) {
                        nameInsideFamily.append("/").append(familyPointer.getName());
                    }
                    itemKey = nameInsideFamily.toString();
                } else {
                    itemKey = topLevelKey;
                }
                if (itemKey == null) {
                    itemKey = item.getName();
                }
                if (itemKey.length() == 0) {
                    return null;
                }
                if (!itemKey.equals(topLevelKey)) {
                    return topLevelKey + "-" + itemKey;
                }
                return itemKey;
            }
            if (this.deduplicateBy == DeduplicateBy.INDIVIDUAL) {
                return this.guidToKey.get(item.getGuid());
            }
            if (this.deduplicateBy == DeduplicateBy.TOP_LEVEL_ITEM) {
                Item topLevelItem = item.getTopLevelItem();
                if (topLevelItem == null) {
                    topLevelItem = item;
                }
                return this.guidToKey.get(topLevelItem.getGuid());
            }
        }
        return null;
    }

    private void writeCsvHeader() throws IOException {
        if (this.originalFieldGuid) {
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.ItemGUID")));
        }
        if (this.originalFieldDocIds) {
            if (this.originalFieldGuid) {
                this.bufferedWriter.write(",");
            }
            this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.ItemDocIDs")));
        }
        if (this.fieldCustodians) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllCustodians")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateCustodians")));
            }
        }
        if (this.fieldItemNames) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllItemNames")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateItemNames")));
            }
        }
        if (this.fieldItemDates) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllItemDates")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateItemDates")));
            }
        }
        if (this.fieldPaths) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllPaths")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternatePaths")));
            }
        }
        if (this.fieldTags) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllTags")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateTags")));
            }
        }
        if (this.fieldSubTags) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AllSubTags", (Object)this.fieldSubTagsPrefix)));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateSubTags", (Object)this.fieldSubTagsPrefix)));
            }
        }
        if (this.fieldGuids) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllGUIDs")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateGUIDs")));
            }
        }
        if (this.fieldParentGuids) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllParentGUIDs")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateParentGUIDs")));
            }
        }
        if (this.fieldTopLevelParentGuids) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllTopLevelParentGUIDs")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateTopLevelParentGUIDs")));
            }
        }
        if (this.fieldDocIds) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllDocIDs")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateDocIDs")));
            }
        }
        if (this.fieldLowestFamilyDocId) {
            if (this.computeAllFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllLowestFamilyDocID")));
            }
            if (this.computeAlternateFields) {
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateLowestFamilyDocID")));
            }
        }
        if (this.fieldMetadataProfile) {
            for (MetadataItem metadataItem : this.metadataProfile.getMetadata()) {
                if (this.computeAllFields) {
                    this.bufferedWriter.write(",");
                    this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AllField", (Object)metadataItem.getLocalisedName())));
                }
                if (!this.computeAlternateFields) continue;
                this.bufferedWriter.write(",");
                this.bufferedWriter.write(FormattingUtils.encodeForCsv((String)this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateField", (Object)metadataItem.getLocalisedName())));
            }
        }
    }

    private StringBuilder itemToCsvLine(Item itemToUpdate) {
        StringBuilder stringBuilder = new StringBuilder();
        String deduplicationKey = this.getItemKey(itemToUpdate);
        if (deduplicationKey != null && deduplicationKey.length() > 0) {
            Item topLevelItem;
            String itemGuid = itemToUpdate.getGuid();
            this.effectiveUpdatedItems.incrementAndGet();
            stringBuilder.append("\r\n");
            if (this.originalFieldGuid) {
                stringBuilder.append(FormattingUtils.encodeForCsv((String)itemGuid));
            }
            if (this.originalFieldDocIds) {
                if (this.originalFieldGuid) {
                    stringBuilder.append(",");
                }
                StringBuilder docIds = new StringBuilder();
                Set<Object> docIdSet = new HashSet();
                boolean firstDocId = true;
                if (this.isDocIdMapNeeded) {
                    Set<String> docIdsFromDictionary = this.guidToDocId.get(itemToUpdate.getGuid());
                    if (docIdsFromDictionary != null) {
                        docIdSet = docIdsFromDictionary;
                    }
                } else {
                    for (ProductionSetItem productionSetItem : itemToUpdate.getProductionSetItems()) {
                        docIdSet.add(productionSetItem.getDocumentNumber().toString());
                    }
                }
                for (String string : docIdSet) {
                    if (firstDocId) {
                        firstDocId = false;
                    } else {
                        docIds.append(this.separator);
                    }
                    docIds.append(string);
                }
                stringBuilder.append(FormattingUtils.encodeForCsv((String)docIds.toString()));
            }
            if (this.deduplicateBy == DeduplicateBy.TOP_LEVEL_ITEM && !itemToUpdate.isTopLevel() && (topLevelItem = itemToUpdate.getTopLevelItem()) != null) {
                itemToUpdate = topLevelItem;
            }
            DuplicateProperties duplicateProperties = this.duplicatePropertiesMap.get(deduplicationKey);
            this.writeDuplicateFieldsToCsvLine(itemToUpdate, stringBuilder, duplicateProperties);
        }
        return stringBuilder;
    }

    private void writeGuidAndDocIdToCsvLine(Item itemToUpdate, StringBuilder stringBuilder) {
        stringBuilder.append("\r\n");
        if (this.originalFieldGuid) {
            stringBuilder.append(FormattingUtils.encodeForCsv((String)itemToUpdate.getGuid()));
        }
        if (this.originalFieldDocIds) {
            if (this.originalFieldGuid) {
                stringBuilder.append(",");
            }
            StringBuilder docIds = new StringBuilder();
            HashSet<String> docIdSet = new HashSet<String>();
            boolean firstDocId = true;
            for (ProductionSetItem productionSetItem : itemToUpdate.getProductionSetItems()) {
                docIdSet.add(productionSetItem.getDocumentNumber().toString());
            }
            for (String docId : docIdSet) {
                if (firstDocId) {
                    firstDocId = false;
                } else {
                    docIds.append(this.separator);
                }
                docIds.append(docId);
            }
            stringBuilder.append(FormattingUtils.encodeForCsv((String)docIds.toString()));
        }
    }

    private void writeDuplicateFieldsToCsvLine(Item itemToUpdate, StringBuilder stringBuilder, DuplicateProperties duplicateProperties) {
        block48: {
            String lowestDuplicateFamilyDocId;
            block50: {
                block49: {
                    String lowestFamilyDocId;
                    TreeSet sortedItemFamilyDocIds;
                    Set<String> itemDocIdsFromDictionary;
                    String guids;
                    String guid;
                    String guids2;
                    TreeSet<String> sortedDuplicateGuids;
                    if (this.fieldCustodians) {
                        TreeSet<String> sortedDuplicateCustodians = new TreeSet<String>(duplicateProperties.custodians);
                        if (this.computeAllFields) {
                            String custodians = FormattingUtils.join(sortedDuplicateCustodians, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)custodians));
                        }
                        if (this.computeAlternateFields) {
                            String custodian = itemToUpdate.getCustodian();
                            String custodians = FormattingUtils.joinExcept(sortedDuplicateCustodians, (String)this.separator, (String)custodian, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)custodians));
                        }
                    }
                    if (this.fieldItemNames) {
                        TreeSet<String> sortedDuplicateItemNames = new TreeSet<String>(duplicateProperties.itemNames);
                        if (this.computeAllFields) {
                            String itemNames = FormattingUtils.join(sortedDuplicateItemNames, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)itemNames));
                        }
                        if (this.computeAlternateFields) {
                            String itemName = itemToUpdate.getName();
                            String itemNames = FormattingUtils.joinExcept(sortedDuplicateItemNames, (String)this.separator, (String)itemName, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)itemNames));
                        }
                    }
                    if (this.fieldItemDates) {
                        TreeSet<String> sortedDuplicateItemDates = new TreeSet<String>(duplicateProperties.itemDates);
                        if (this.computeAllFields) {
                            String itemDates = FormattingUtils.join(sortedDuplicateItemDates, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)itemDates));
                        }
                        if (this.computeAlternateFields) {
                            String itemDate = this.getFormattedDate(itemToUpdate.getDate());
                            String itemDates = FormattingUtils.joinExcept(sortedDuplicateItemDates, (String)this.separator, (String)itemDate, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)itemDates));
                        }
                    }
                    if (this.fieldPaths) {
                        TreeSet<String> sortedDuplicatePaths = new TreeSet<String>(duplicateProperties.paths);
                        if (this.computeAllFields) {
                            String paths = FormattingUtils.join(sortedDuplicatePaths, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)paths));
                        }
                        if (this.computeAlternateFields) {
                            String path = this.omitEvidenceNameFromPaths ? ItemsUtils.getItemPathWithoutEvidenceName(itemToUpdate) : ItemsUtils.getItemPath(itemToUpdate);
                            String paths = FormattingUtils.joinExcept(sortedDuplicatePaths, (String)this.separator, (String)path, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)paths));
                        }
                    }
                    if (this.fieldTags) {
                        String tags;
                        TreeSet<String> sortedDuplicateTags = new TreeSet<String>(duplicateProperties.tags);
                        if (this.computeAllFields) {
                            tags = FormattingUtils.join(sortedDuplicateTags, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)tags));
                        }
                        if (this.computeAlternateFields) {
                            tags = FormattingUtils.joinExcept(sortedDuplicateTags, (String)this.separator, (Set)itemToUpdate.getTags(), (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)tags));
                        }
                    }
                    if (this.fieldSubTags) {
                        TreeSet<String> sortedDuplicateSubTags = new TreeSet<String>(duplicateProperties.subTags);
                        if (this.computeAllFields) {
                            String subTags = FormattingUtils.join(sortedDuplicateSubTags, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)subTags));
                        }
                        if (this.computeAlternateFields) {
                            HashSet<String> itemSubTags = new HashSet<String>();
                            for (String tag : itemToUpdate.getTags()) {
                                if (!tag.startsWith(this.fieldSubTagsPrefix)) continue;
                                itemSubTags.add(tag.substring(this.fieldSubTagsPrefixLength));
                            }
                            String subTags = FormattingUtils.joinExcept(sortedDuplicateSubTags, (String)this.separator, itemSubTags, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)subTags));
                        }
                    }
                    if (this.fieldGuids) {
                        sortedDuplicateGuids = new TreeSet<String>(duplicateProperties.guids);
                        if (this.computeAllFields) {
                            guids2 = FormattingUtils.join(sortedDuplicateGuids, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)guids2));
                        }
                        if (this.computeAlternateFields) {
                            guid = itemToUpdate.getGuid();
                            guids = FormattingUtils.joinExcept(sortedDuplicateGuids, (String)this.separator, (String)guid, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)guids));
                        }
                    }
                    if (this.fieldParentGuids) {
                        sortedDuplicateGuids = new TreeSet<String>(duplicateProperties.parentGuids);
                        if (this.computeAllFields) {
                            guids2 = FormattingUtils.join(sortedDuplicateGuids, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)guids2));
                        }
                        if (this.computeAlternateFields) {
                            guid = "";
                            try {
                                guid = ((Item)itemToUpdate.getParent()).getGuid();
                            }
                            catch (Exception e) {
                                LOGGER.info("Cannot get item parent guid " + itemToUpdate.getGuid(), (Throwable)e);
                            }
                            guids = FormattingUtils.joinExcept(sortedDuplicateGuids, (String)this.separator, (String)guid, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)guids));
                        }
                    }
                    if (this.fieldTopLevelParentGuids) {
                        sortedDuplicateGuids = new TreeSet<String>(duplicateProperties.topLevelParentGuids);
                        if (this.computeAllFields) {
                            guids2 = FormattingUtils.join(sortedDuplicateGuids, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)guids2));
                        }
                        if (this.computeAlternateFields) {
                            guid = "";
                            try {
                                guid = ((Item)itemToUpdate.getTopLevelItem().getParent()).getGuid();
                            }
                            catch (Exception e) {
                                LOGGER.info("Cannot get item top-level parent guid " + itemToUpdate.getGuid(), (Throwable)e);
                            }
                            guids = FormattingUtils.joinExcept(sortedDuplicateGuids, (String)this.separator, (String)guid, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)guids));
                        }
                    }
                    if (this.fieldDocIds) {
                        TreeSet<String> sortedDuplicateDocIds = new TreeSet<String>(duplicateProperties.docIds);
                        if (this.computeAllFields) {
                            String docIds = FormattingUtils.join(sortedDuplicateDocIds, (String)this.separator, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)docIds));
                        }
                        if (this.computeAlternateFields) {
                            Object itemDocIds = new HashSet();
                            if (this.isDocIdMapNeeded) {
                                itemDocIdsFromDictionary = this.guidToDocId.get(itemToUpdate.getGuid());
                                if (itemDocIdsFromDictionary != null) {
                                    itemDocIds = itemDocIdsFromDictionary;
                                }
                            } else {
                                for (ProductionSetItem productionSetItem : itemToUpdate.getProductionSetItems()) {
                                    itemDocIds.add(productionSetItem.getDocumentNumber().toString());
                                }
                            }
                            String docIds = FormattingUtils.joinExcept(sortedDuplicateDocIds, (String)this.separator, (Set)itemDocIds, (int)this.maxFieldsLength);
                            stringBuilder.append(",");
                            stringBuilder.append(FormattingUtils.encodeForCsv((String)docIds));
                        }
                    }
                    if (!this.fieldLowestFamilyDocId) break block48;
                    TreeSet<String> sortedDuplicateFamilyDocIds = new TreeSet<String>(duplicateProperties.familyDocIds);
                    lowestDuplicateFamilyDocId = "";
                    if (!sortedDuplicateFamilyDocIds.isEmpty()) {
                        lowestDuplicateFamilyDocId = sortedDuplicateFamilyDocIds.first();
                    }
                    if (this.computeAllFields) {
                        stringBuilder.append(",");
                        stringBuilder.append(FormattingUtils.encodeForCsv((String)lowestDuplicateFamilyDocId));
                    }
                    if (!this.computeAlternateFields) break block48;
                    if (!this.isDocIdMapNeeded) break block49;
                    itemDocIdsFromDictionary = this.guidToDocId.get(itemToUpdate.getGuid());
                    if (itemDocIdsFromDictionary == null || (sortedItemFamilyDocIds = new TreeSet(itemDocIdsFromDictionary)).isEmpty() || !(lowestFamilyDocId = (String)sortedItemFamilyDocIds.first()).equals(lowestDuplicateFamilyDocId)) break block50;
                    lowestDuplicateFamilyDocId = "";
                    break block50;
                }
                for (ProductionSetItem productionSetItem : itemToUpdate.getProductionSetItems()) {
                    if (!productionSetItem.getDocumentNumber().toString().equals(lowestDuplicateFamilyDocId)) continue;
                    lowestDuplicateFamilyDocId = "";
                    break;
                }
            }
            stringBuilder.append(",");
            stringBuilder.append(FormattingUtils.encodeForCsv((String)lowestDuplicateFamilyDocId));
        }
        if (this.fieldMetadataProfile) {
            int i = 0;
            for (MetadataItem metadataItem : this.metadataProfile.getMetadata()) {
                TreeSet sortedFieldValues = new TreeSet(duplicateProperties.metadataProfile.get(i));
                if (this.computeAllFields) {
                    String values = FormattingUtils.join(sortedFieldValues, (String)this.separator, (int)this.maxFieldsLength);
                    stringBuilder.append(",");
                    stringBuilder.append(FormattingUtils.encodeForCsv((String)values));
                }
                if (this.computeAlternateFields) {
                    String value = "";
                    try {
                        value = MetadataItemUtils.evaluate(metadataItem, itemToUpdate, this.rubyFieldNames);
                    }
                    catch (Exception e) {
                        LOGGER.info("Cannot evaluate metadata " + metadataItem.getLocalisedName() + " for item " + itemToUpdate.getGuid(), (Throwable)e);
                    }
                    String values = FormattingUtils.joinExcept(sortedFieldValues, (String)this.separator, (String)value, (int)this.maxFieldsLength);
                    stringBuilder.append(",");
                    stringBuilder.append(FormattingUtils.encodeForCsv((String)values));
                }
                ++i;
            }
        }
    }

    private void updateItemCustomMetadataMap(ItemCustomMetadataMap itemCustomMetadataMap, String fieldName, Set<String> additionalValues) {
        this.updateItemCustomMetadataMap(itemCustomMetadataMap, fieldName, additionalValues, new HashSet<String>());
    }

    private void updateItemCustomMetadataMap(ItemCustomMetadataMap itemCustomMetadataMap, String fieldName, Set<String> additionalValues, String except) {
        HashSet<String> exceptSet = new HashSet<String>();
        exceptSet.add(except);
        this.updateItemCustomMetadataMap(itemCustomMetadataMap, fieldName, additionalValues, exceptSet);
    }

    private void updateItemCustomMetadataMap(ItemCustomMetadataMap itemCustomMetadataMap, String fieldName, Set<String> additionalValues, Set<String> except) {
        String result;
        TreeSet<String> previousValues = new TreeSet<String>();
        if (itemCustomMetadataMap.containsKey((Object)fieldName)) {
            String previousValuesString = (String)itemCustomMetadataMap.get((Object)fieldName);
            String[] splits = previousValuesString.split(this.separator);
            previousValues.addAll(Arrays.asList(splits));
        }
        previousValues.addAll(additionalValues);
        if (except != null) {
            result = FormattingUtils.joinExcept(previousValues, (String)this.separator, except, (int)this.maxFieldsLength);
            itemCustomMetadataMap.put((Object)fieldName, (Object)result);
        } else {
            result = FormattingUtils.join(previousValues, (String)this.separator, (int)this.maxFieldsLength);
            itemCustomMetadataMap.put((Object)fieldName, (Object)result);
        }
    }

    private void updateItemsCustomMetadataFields(Item itemToUpdate, Item itemToCompareAlternatesAgainst, DuplicateProperties duplicateProperties) {
        ItemCustomMetadataMap itemCustomMetadataMap;
        block101: {
            TreeSet<String> s;
            String lowestDuplicateFamilyDocId;
            block103: {
                block102: {
                    String lowestFamilyDocId;
                    TreeSet sortedItemFamilyDocIds;
                    Set<String> itemDocIdsFromDictionary;
                    String guids;
                    String guid;
                    String guids2;
                    TreeSet<String> sortedDuplicateGuids;
                    itemCustomMetadataMap = itemToUpdate.getCustomMetadata();
                    if (this.fieldCustodians) {
                        TreeSet<String> sortedDuplicateCustodians = new TreeSet<String>(duplicateProperties.custodians);
                        if (this.computeAllFields) {
                            String custodians = FormattingUtils.join(sortedDuplicateCustodians, (String)this.separator, (int)this.maxFieldsLength);
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllCustodians"), sortedDuplicateCustodians);
                            } else {
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllCustodians"), (Object)custodians);
                            }
                        }
                        if (this.computeAlternateFields) {
                            String custodian = itemToCompareAlternatesAgainst.getCustodian();
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateCustodians"), sortedDuplicateCustodians, custodian);
                            } else {
                                String custodians = FormattingUtils.joinExcept(sortedDuplicateCustodians, (String)this.separator, (String)custodian, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateCustodians"), (Object)custodians);
                            }
                        }
                    }
                    if (this.fieldItemNames) {
                        TreeSet<String> sortedDuplicateItemNames = new TreeSet<String>(duplicateProperties.itemNames);
                        if (this.computeAllFields) {
                            String itemNames = FormattingUtils.join(sortedDuplicateItemNames, (String)this.separator, (int)this.maxFieldsLength);
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllItemNames"), sortedDuplicateItemNames);
                            } else {
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllItemNames"), (Object)itemNames);
                            }
                        }
                        if (this.computeAlternateFields) {
                            String itemName = itemToCompareAlternatesAgainst.getName();
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateItemNames"), sortedDuplicateItemNames, itemName);
                            } else {
                                String itemNames = FormattingUtils.joinExcept(sortedDuplicateItemNames, (String)this.separator, (String)itemName, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateItemNames"), (Object)itemNames);
                            }
                        }
                    }
                    if (this.fieldItemDates) {
                        TreeSet<String> sortedDuplicateItemDates = new TreeSet<String>(duplicateProperties.itemDates);
                        if (this.computeAllFields) {
                            String csvHeader = this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllItemDates");
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, csvHeader, sortedDuplicateItemDates);
                            } else {
                                String itemDates = FormattingUtils.join(sortedDuplicateItemDates, (String)this.separator, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)csvHeader, (Object)itemDates);
                            }
                        }
                        if (this.computeAlternateFields) {
                            String itemDate = this.getFormattedDate(itemToCompareAlternatesAgainst.getDate());
                            String csvHeader = this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateItemDates");
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, csvHeader, sortedDuplicateItemDates, itemDate);
                            } else {
                                String itemDates = FormattingUtils.joinExcept(sortedDuplicateItemDates, (String)this.separator, (String)itemDate, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)csvHeader, (Object)itemDates);
                            }
                        }
                    }
                    if (this.fieldPaths) {
                        TreeSet<String> sortedDuplicatePaths = new TreeSet<String>(duplicateProperties.paths);
                        if (this.computeAllFields) {
                            String paths = FormattingUtils.join(sortedDuplicatePaths, (String)this.separator, (int)this.maxFieldsLength);
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllPaths"), sortedDuplicatePaths);
                            } else {
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllPaths"), (Object)paths);
                            }
                        }
                        if (this.computeAlternateFields) {
                            String path;
                            String string = path = this.omitEvidenceNameFromPaths ? ItemsUtils.getItemPathWithoutEvidenceName(itemToCompareAlternatesAgainst) : ItemsUtils.getItemPath(itemToCompareAlternatesAgainst);
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternatePaths"), sortedDuplicatePaths, path);
                            } else {
                                String paths = FormattingUtils.joinExcept(sortedDuplicatePaths, (String)this.separator, (String)path, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternatePaths"), (Object)paths);
                            }
                        }
                    }
                    if (this.fieldTags) {
                        String tags;
                        TreeSet<String> sortedDuplicateTags = new TreeSet<String>(duplicateProperties.tags);
                        if (this.computeAllFields) {
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllTags"), sortedDuplicateTags);
                            } else {
                                tags = FormattingUtils.join(sortedDuplicateTags, (String)this.separator, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllTags"), (Object)tags);
                            }
                        }
                        if (this.computeAlternateFields) {
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateTags"), sortedDuplicateTags, itemToCompareAlternatesAgainst.getTags());
                            } else {
                                tags = FormattingUtils.joinExcept(sortedDuplicateTags, (String)this.separator, (Set)itemToCompareAlternatesAgainst.getTags(), (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateTags"), (Object)tags);
                            }
                        }
                    }
                    if (this.fieldSubTags) {
                        TreeSet<String> sortedDuplicateSubTags = new TreeSet<String>(duplicateProperties.subTags);
                        if (this.computeAllFields) {
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllSubTagsAppend"), sortedDuplicateSubTags);
                            } else {
                                String subTags = FormattingUtils.join(sortedDuplicateSubTags, (String)this.separator, (int)this.maxFieldsLength);
                                Object assignableFieldSubTagsPrefix = this.fieldSubTagsPrefix;
                                if (((String)assignableFieldSubTagsPrefix).endsWith("|")) {
                                    assignableFieldSubTagsPrefix = StringUtils.chop((String)assignableFieldSubTagsPrefix);
                                }
                                assignableFieldSubTagsPrefix = ((String)assignableFieldSubTagsPrefix).replace('|', '_');
                                itemCustomMetadataMap.put((Object)this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AllSubTagsAppendTagPrefix", assignableFieldSubTagsPrefix), (Object)subTags);
                            }
                        }
                        if (this.computeAlternateFields) {
                            HashSet<String> itemSubTags = new HashSet<String>();
                            for (String tag : itemToCompareAlternatesAgainst.getTags()) {
                                if (!tag.startsWith(this.fieldSubTagsPrefix)) continue;
                                itemSubTags.add(tag.substring(this.fieldSubTagsPrefixLength));
                            }
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateSubTagsAppend"), sortedDuplicateSubTags, itemSubTags);
                            } else {
                                String subTags = FormattingUtils.joinExcept(sortedDuplicateSubTags, (String)this.separator, itemSubTags, (int)this.maxFieldsLength);
                                String assignableFieldSubTagsPrefix = this.fieldSubTagsPrefix;
                                if (assignableFieldSubTagsPrefix.endsWith("|")) {
                                    assignableFieldSubTagsPrefix = StringUtils.chop((String)assignableFieldSubTagsPrefix);
                                }
                                assignableFieldSubTagsPrefix = assignableFieldSubTagsPrefix.replace('|', '_');
                                itemCustomMetadataMap.put((Object)this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateSubTagsAppendTagPrefix", (Object)assignableFieldSubTagsPrefix), (Object)subTags);
                            }
                        }
                    }
                    if (this.fieldGuids) {
                        sortedDuplicateGuids = new TreeSet<String>(duplicateProperties.guids);
                        if (this.computeAllFields) {
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllGUIDs"), sortedDuplicateGuids);
                            } else {
                                guids2 = FormattingUtils.join(sortedDuplicateGuids, (String)this.separator, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllGUIDs"), (Object)guids2);
                            }
                        }
                        if (this.computeAlternateFields) {
                            guid = itemToCompareAlternatesAgainst.getGuid();
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateGUIDs"), sortedDuplicateGuids, guid);
                            } else {
                                guids = FormattingUtils.joinExcept(sortedDuplicateGuids, (String)this.separator, (String)guid, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateGUIDs"), (Object)guids);
                            }
                        }
                    }
                    if (this.fieldParentGuids) {
                        sortedDuplicateGuids = new TreeSet<String>(duplicateProperties.parentGuids);
                        if (this.computeAllFields) {
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllParentGUIDs"), sortedDuplicateGuids);
                            } else {
                                guids2 = FormattingUtils.join(sortedDuplicateGuids, (String)this.separator, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllParentGUIDs"), (Object)guids2);
                            }
                        }
                        if (this.computeAlternateFields) {
                            guid = "";
                            try {
                                guid = ((Item)itemToCompareAlternatesAgainst.getParent()).getGuid();
                            }
                            catch (Exception e) {
                                LOGGER.info("Cannot get item parent guid " + itemToCompareAlternatesAgainst.getGuid(), (Throwable)e);
                            }
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateParentGUIDs"), sortedDuplicateGuids, guid);
                            } else {
                                guids = FormattingUtils.joinExcept(sortedDuplicateGuids, (String)this.separator, (String)guid, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateParentGUIDs"), (Object)guids);
                            }
                        }
                    }
                    if (this.fieldTopLevelParentGuids) {
                        sortedDuplicateGuids = new TreeSet<String>(duplicateProperties.topLevelParentGuids);
                        if (this.computeAllFields) {
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllTopLevelParentGUIDs"), sortedDuplicateGuids);
                            } else {
                                guids2 = FormattingUtils.join(sortedDuplicateGuids, (String)this.separator, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllTopLevelParentGUIDs"), (Object)guids2);
                            }
                        }
                        if (this.computeAlternateFields) {
                            guid = "";
                            try {
                                guid = ((Item)itemToCompareAlternatesAgainst.getTopLevelItem().getParent()).getGuid();
                            }
                            catch (Exception e) {
                                LOGGER.info("Cannot get item top-level parent guid " + itemToCompareAlternatesAgainst.getGuid(), (Throwable)e);
                            }
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateTopLevelParentGUIDs"), sortedDuplicateGuids, guid);
                            } else {
                                guids = FormattingUtils.joinExcept(sortedDuplicateGuids, (String)this.separator, (String)guid, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateTopLevelParentGUIDs"), (Object)guids);
                            }
                        }
                    }
                    if (this.fieldDocIds) {
                        TreeSet<String> sortedDuplicateDocIds = new TreeSet<String>(duplicateProperties.docIds);
                        if (this.computeAllFields) {
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllDocIDs"), sortedDuplicateDocIds);
                            } else {
                                String docIds = FormattingUtils.join(sortedDuplicateDocIds, (String)this.separator, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllDocIDs"), (Object)docIds);
                            }
                        }
                        if (this.computeAlternateFields) {
                            Object itemDocIds = new HashSet();
                            if (this.isDocIdMapNeeded) {
                                itemDocIdsFromDictionary = this.guidToDocId.get(itemToCompareAlternatesAgainst.getGuid());
                                if (itemDocIdsFromDictionary != null) {
                                    itemDocIds = itemDocIdsFromDictionary;
                                }
                            } else {
                                for (ProductionSetItem productionSetItem : itemToCompareAlternatesAgainst.getProductionSetItems()) {
                                    itemDocIds.add(productionSetItem.getDocumentNumber().toString());
                                }
                            }
                            if (this.appendToPreviousMetadata) {
                                this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateDocID"), sortedDuplicateDocIds, (Set<String>)itemDocIds);
                            } else {
                                String docIds = FormattingUtils.joinExcept(sortedDuplicateDocIds, (String)this.separator, (Set)itemDocIds, (int)this.maxFieldsLength);
                                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateDocIDs"), (Object)docIds);
                            }
                        }
                    }
                    if (!this.fieldLowestFamilyDocId) break block101;
                    TreeSet<String> sortedDuplicateFamilyDocIds = new TreeSet<String>(duplicateProperties.familyDocIds);
                    lowestDuplicateFamilyDocId = "";
                    if (sortedDuplicateFamilyDocIds.size() > 0) {
                        lowestDuplicateFamilyDocId = sortedDuplicateFamilyDocIds.first();
                    }
                    if (this.computeAllFields) {
                        if (this.appendToPreviousMetadata) {
                            s = new TreeSet<String>();
                            s.add(lowestDuplicateFamilyDocId);
                            this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllLowestFamilyDocID"), s);
                        } else {
                            itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AllLowestFamilyDocID"), (Object)lowestDuplicateFamilyDocId);
                        }
                    }
                    if (!this.computeAlternateFields) break block101;
                    if (!this.isDocIdMapNeeded) break block102;
                    itemDocIdsFromDictionary = this.guidToDocId.get(itemToCompareAlternatesAgainst.getGuid());
                    if (itemDocIdsFromDictionary == null || (sortedItemFamilyDocIds = new TreeSet(itemDocIdsFromDictionary)).isEmpty() || !(lowestFamilyDocId = (String)sortedItemFamilyDocIds.first()).equals(lowestDuplicateFamilyDocId)) break block103;
                    lowestDuplicateFamilyDocId = "";
                    break block103;
                }
                for (ProductionSetItem productionSetItem : itemToCompareAlternatesAgainst.getProductionSetItems()) {
                    if (!productionSetItem.getDocumentNumber().toString().equals(lowestDuplicateFamilyDocId)) continue;
                    lowestDuplicateFamilyDocId = "";
                    break;
                }
            }
            if (duplicateProperties.familyDocIds.size() > 1) {
                if (this.appendToPreviousMetadata) {
                    s = new TreeSet();
                    s.add(lowestDuplicateFamilyDocId);
                    this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateLowestFamilyDocID"), s);
                } else {
                    itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateLowestFamilyDocID"), (Object)lowestDuplicateFamilyDocId);
                }
            } else if (!this.appendToPreviousMetadata) {
                itemCustomMetadataMap.put((Object)this.iu.getString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateLowestFamilyDocID"), (Object)"");
            }
        }
        if (this.fieldMetadataProfile) {
            int i = 0;
            for (MetadataItem metadataItem : this.metadataProfile.getMetadata()) {
                TreeSet<String> sortedDuplicateValues = new TreeSet<String>((Collection)duplicateProperties.metadataProfile.get(i));
                if (this.computeAllFields) {
                    if (this.appendToPreviousMetadata) {
                        this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AllField", (Object)metadataItem.getLocalisedName()), sortedDuplicateValues);
                    } else {
                        String values = FormattingUtils.join(sortedDuplicateValues, (String)this.separator, (int)this.maxFieldsLength);
                        itemCustomMetadataMap.put((Object)this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AllField", (Object)metadataItem.getLocalisedName()), (Object)values);
                    }
                }
                if (this.computeAlternateFields) {
                    String value = "";
                    try {
                        value = MetadataItemUtils.evaluate(metadataItem, itemToCompareAlternatesAgainst, this.rubyFieldNames);
                    }
                    catch (Exception e) {
                        LOGGER.info("Cannot evaluate metadata " + metadataItem.getLocalisedName() + " for item " + itemToCompareAlternatesAgainst.getGuid(), (Throwable)e);
                    }
                    if (this.appendToPreviousMetadata) {
                        this.updateItemCustomMetadataMap(itemCustomMetadataMap, this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateField", (Object)metadataItem.getLocalisedName()), sortedDuplicateValues, value);
                    } else {
                        String values = FormattingUtils.joinExcept(sortedDuplicateValues, (String)this.separator, (String)value, (int)this.maxFieldsLength);
                        itemCustomMetadataMap.put((Object)this.iu.getFormattedString("GenerateDuplicateFieldsOperation.CSVHeader.AlternateField", (Object)metadataItem.getLocalisedName()), (Object)values);
                    }
                }
                ++i;
            }
        }
    }

    private void updateItemsCustomMetadataFields(Item itemToUpdate) {
        this.stageItems.incrementAndGet();
        try {
            String deduplicationKey = this.getItemKey(itemToUpdate);
            if (deduplicationKey != null && deduplicationKey.length() > 0) {
                this.effectiveUpdatedItems.incrementAndGet();
                DuplicateProperties duplicateProperties = this.duplicatePropertiesMap.get(deduplicationKey);
                this.updateItemsCustomMetadataFields(itemToUpdate, itemToUpdate, duplicateProperties);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot update metadata.", (Throwable)e);
        }
    }

    private String getFormattedDate(DateTime dateTime) {
        return DateTimeFormat.forPattern((String)this.fieldItemDatesFormat).print((ReadableInstant)dateTime);
    }

    @Override
    public void stopTriggered() {
        ItemsUtils.stopBackgroundTask();
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.stageTotalItems.get() != 0L) {
            stageProgress = (double)this.stageItems.get() / (double)this.stageTotalItems.get();
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.stageItems.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("GenerateDuplicateFieldsOperation.Progress.ItemsProcessed", this.stageItems.get());
        }
        return result;
    }

    class DuplicateProperties {
        Set<String> custodians = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> itemNames = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> itemDates = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> paths = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> tags = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> subTags = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> guids = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> parentGuids = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> topLevelParentGuids = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> docIds = Collections.newSetFromMap(new ConcurrentHashMap());
        Set<String> familyDocIds = Collections.newSetFromMap(new ConcurrentHashMap());
        List<Set<String>> metadataProfile = new ArrayList<Set<String>>();

        public DuplicateProperties() {
        }

        public DuplicateProperties(List<String> metadataProperties) {
            for (String metadataProperty : metadataProperties) {
                this.metadataProfile.add(Collections.newSetFromMap(new ConcurrentHashMap()));
            }
        }
    }
}

