/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.GeneratePrintedImagesOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import nuix.BatchExporter;
import nuix.BulkAnnotater;
import nuix.ExportProcessingJob;
import nuix.Item;
import nuix.ItemEventInfo;
import nuix.ParallelProcessingConfigurable;
import nuix.ProcessingJob;
import nuix.ProductionSet;
import nuix.profile.ImagingProfile;
import org.apache.commons.io.FileUtils;

public class GeneratePrintedImagesOperationImplementation
extends GeneratePrintedImagesOperation
implements RemoteWorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GeneratePrintedImagesOperation.class);
    private transient ExportProcessingJob exportProcessingJob;
    private transient String exportFolder;
    private transient long itemsInScopeCount;
    private transient long itemsUpdatedCount;
    private transient Map<String, Integer> stageNameToId;
    private transient List<Item> itemsInScope;
    private transient boolean isPaused;
    private transient String tempTag;
    private transient double partStartPercentage;
    private transient double partSizePercentage;
    private transient int workPart;
    private transient Set<Item> failedItems;
    private transient Set<Item> itemsToUntag;
    private transient Integer workerMemory = null;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);

    public List<Item> getItemsInScope() {
        if (this.itemsInScope != null) {
            return this.itemsInScope;
        }
        return new ArrayList<Item>();
    }

    @Override
    public void startTriggered() throws Exception {
        this.tempTag = "Automate|System|Run|PrintedImages|" + String.valueOf(UUID.randomUUID());
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.addExecutionLog(this.iu.getFormattedString("GeneratePrintedImagesOperation.Log.ScopeQuery", (Object)this.scope));
        this.imagingProfile = this.executionContext.evalParameters(this.imagingProfile, this);
        this.failedItems = Collections.newSetFromMap(new ConcurrentHashMap());
        this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_failed_items_tag_name}", this.failedItemTagName)));
        try {
            this.executionContext.workflowLocalWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{local_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerCountFromParameter", new Object[]{"{local_worker_count}", this.executionContext.workflowLocalWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowLocalWorkersMemoryMb = Integer.parseInt(this.executionContext.evalParameters("{local_worker_memory}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerMemoryFromParameter", new Object[]{"{local_worker_memory}", this.executionContext.workflowLocalWorkersMemoryMb}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowBrokerWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{broker_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingBrokerWorkerCountFromParameter", new Object[]{"{broker_worker_count}", this.executionContext.workflowBrokerWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.jobBrokerPort = Integer.parseInt(this.executionContext.evalParameters("{job_worker_broker_port}", this));
            this.executionContext.jobBrokerIp = this.executionContext.evalParameters("{job_worker_broker_ip}", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executionContext.workflowLocalWorkersTempFolder = this.executionContext.evalParameters(this.executionContext.workflowLocalWorkersTempFolder, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.itemsInScopeCount = this.executionContext.nuixCase.count(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("GeneratePrintedImagesOperation.Log.ScopeCount", this.itemsInScopeCount));
                if (this.itemsInScopeCount == 0L) {
                    this.addWarning(this.iu.getFormattedString("GeneratePrintedImagesOperation.Warning.NoItemsFoundInScope", (Object)this.scope));
                    LOGGER.warn("No items were found in scope " + this.scope);
                }
                String effectiveScope = this.scope;
                if (!this.regenerateStoredImages) {
                    effectiveScope = NuixUtils.addAndQuery(this.scope, "NOT has-stored:printed-image");
                }
                this.itemsInScope = this.executionContext.nuixCase.search(effectiveScope);
                LOGGER.info("Tagging " + this.itemsInScopeCount + " items with tag " + this.tempTag);
                this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, this.itemsInScope);
                this.itemsUpdatedCount = this.itemsInScope.size();
                LOGGER.info("Effective scope: " + effectiveScope);
                this.addExecutionLog(this.iu.getNumeralString("GeneratePrintedImagesOperation.Log.EffectiveCount", this.itemsUpdatedCount));
                if (this.regenerateStoredImages) {
                    this.addExecutionLog(this.iu.getString("GeneratePrintedImagesOperation.Log.RegenerateStoredImages"));
                }
                if (this.imagingProfile.length() > 0) {
                    this.addExecutionLog(this.iu.getFormattedString("GeneratePrintedImagesOperation.Log.ImagingProfile", (Object)this.imagingProfile));
                }
                if (this.itemsInScope.size() > 0) {
                    if (this.splitWork.booleanValue() && this.itemsInScopeCount > (long)this.splitWorkAt) {
                        this.addExecutionLog(this.iu.getNumeralString("General.Log.SplitWorkAt", (long)this.splitWorkAt));
                        LOGGER.info("Performing work in parts");
                        int addedForWork = 0;
                        this.workPart = 0;
                        while (addedForWork < this.itemsInScope.size()) {
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            ArrayList<Item> partItems = new ArrayList<Item>();
                            this.partStartPercentage = (double)addedForWork / (double)this.itemsInScope.size();
                            LOGGER.info("Exported in parts: " + addedForWork + " of " + this.itemsInScope.size());
                            ++this.workPart;
                            int nextItemId = Math.min(addedForWork + this.splitWorkAt, this.itemsInScope.size());
                            partItems.addAll(this.itemsInScope.subList(addedForWork, nextItemId));
                            LOGGER.info("Preparing work on part from " + addedForWork + " to " + (nextItemId - 1));
                            addedForWork = nextItemId;
                            LOGGER.info("Added to part: " + addedForWork);
                            double trancheEndPercentage = (double)addedForWork / (double)this.itemsInScope.size();
                            this.partSizePercentage = trancheEndPercentage - this.partStartPercentage;
                            LOGGER.info("Starting work on part " + this.workPart);
                            this.addExecutionLog(this.iu.getNumeralFormattedString("General.Log.WorkPart", (long)partItems.size(), (Object)this.workPart));
                            this.runItems(partItems, this.workPart);
                        }
                        LOGGER.info("Exported in parts: " + addedForWork + " of " + this.itemsInScope.size());
                    } else {
                        this.runItems(this.itemsInScope, 0);
                    }
                }
                this.handleFailedItems();
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void runItems(List<Item> partItemsInScope, int partId) throws Exception {
        this.exportFolder = this.executionContext.workflowLocalWorkersTempFolder = this.executionContext.evalParameters(this.executionContext.workflowLocalWorkersTempFolder, this);
        if (this.exportFolder == null || this.exportFolder.trim().length() == 0) {
            LOGGER.info("Using case temp folder inside case");
            this.exportFolder = String.valueOf(this.executionContext.nuixCase.getLocation()) + "/temp";
        } else {
            LOGGER.info("Using worker temp folder from last configuration operation");
        }
        this.exportFolder = this.exportFolder + "/print-store";
        BatchExporter batchExporter = this.executionContext.nuixUtilities.createBatchExporter(this.exportFolder);
        ArrayList<String> stageNames = new ArrayList<String>();
        stageNames.add("work_queue");
        HashMap<String, Object> productOptions = new HashMap<String, Object>();
        productOptions.put("naming", "guid");
        productOptions.put("regenerateStored", this.regenerateStoredImages);
        batchExporter.addProduct("pdf", productOptions);
        stageNames.add("native");
        stageNames.add("pdf");
        stageNames.add("markup");
        stageNames.add("stamping");
        stageNames.add("file_naming");
        stageNames.add("create_production_set");
        stageNames.add("cleanup");
        this.stageNameToId = new HashMap<String, Integer>();
        int id = 0;
        for (String stageName : stageNames) {
            this.stageNameToId.put(stageName, id);
            ++id;
        }
        ConfigurationParser configurationParser = new ConfigurationParser();
        batchExporter.setParallelProcessingSettings(configurationParser.getParallelProcessingLegalExportSettings());
        batchExporter.whenItemEventOccurs(this::itemProcessed);
        NuixWorkerUtils.setWorkerSettings(this.executionContext, this, (ParallelProcessingConfigurable)batchExporter, partId <= 1);
        this.workerMemory = NuixWorkerUtils.getProcessorWorkerMemory((ParallelProcessingConfigurable)batchExporter);
        ImagingProfile imagingProfileObject = NuixUtils.getImagingProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.imagingProfile);
        if (imagingProfileObject == null) {
            throw new IOException(this.iu.getFormattedString("GeneratePrintedImagesOperation.Exception.CannotSetImagingProfile", (Object)this.imagingProfile));
        }
        batchExporter.setImagingProfileObject(imagingProfileObject);
        this.exportProcessingJob = batchExporter.exportItemsAsync(partItemsInScope);
        String processingJobGuid = this.exportProcessingJob.getJobGuid().replace("-", "");
        LOGGER.info("Job Guid: " + processingJobGuid);
        NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.exportProcessingJob, this.addedWorkerCount);
        NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.exportProcessingJob);
        if (this.executionState == ExecutionState.STOPPING) {
            this.trackStopped();
        }
        try {
            LOGGER.info("Deleting temporary folder " + this.exportFolder);
            FileUtils.deleteDirectory((File)new File(this.exportFolder));
        }
        catch (IOException e) {
            LOGGER.warn("Cannot delete temporary folder.", (Throwable)e);
        }
        try {
            File exportFile = new File(this.exportFolder);
            String productionSetName = "Export to " + exportFile.getName();
            for (ProductionSet productionSet : this.executionContext.nuixCase.getProductionSets()) {
                if (!productionSet.getName().equals(productionSetName)) continue;
                LOGGER.info("Deleting Production Set " + productionSet.getGuid() + " - " + productionSet.getName());
                productionSet.delete();
                break;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot delete production set.", (Throwable)e);
        }
    }

    @Override
    public void stopTriggered() {
        if (this.exportProcessingJob != null) {
            try {
                this.exportProcessingJob.abort();
            }
            catch (Exception e) {
                LOGGER.error("Cannot stop job.", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void updateState() {
        if (this.exportProcessingJob != null) {
            if (!this.isPaused && this.exportProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.iu.getFormattedString("GeneratePrintedImagesOperation.Warning.PausedMessage", new Object[]{this.getOperationName(), "temporarily halted due to insufficient free disk space."}), false);
            }
            if (this.isPaused && !this.exportProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.iu.getFormattedString("GeneratePrintedImagesOperation.Warning.PausedMessage", new Object[]{this.getOperationName(), "temporarily halted due to insufficient free disk space."}), true);
            }
        }
    }

    private void handleFailedItems() throws IOException {
        LOGGER.info("Handling failed items");
        if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
            this.addWarning(this.iu.getNumeralString("GeneratePrintedImagesOperation.Warning.FailedGeneratingPrintedImages", (long)this.failedItems.size()));
        }
        if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
            LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
            this.addExecutionLog(this.iu.getNumeralFormattedString("OcrOperation.Log.TaggedFailedItem", (long)this.failedItems.size(), (Object)this.failedItemTagName));
        }
        if (this.tagFailedItems.booleanValue() && this.untagSuccessfulItems.booleanValue()) {
            String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", "tag:\"" + this.tempTag + "\"");
            LOGGER.info("Searching: " + query);
            Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
            this.itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
            if (this.itemsToUntag.size() > 0) {
                LOGGER.info("Untagging " + this.itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                bulkAnnotater.removeTag(this.failedItemTagName, this.itemsToUntag);
                this.addExecutionLog(this.iu.getNumeralFormattedString("OcrOperation.Log.UntaggedFailedItem", (long)this.itemsToUntag.size(), (Object)this.failedItemTagName));
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete;
        block8: {
            percentageComplete = 0.0;
            if (this.exportProcessingJob != null) {
                try {
                    int stageCount = this.stageNameToId.size();
                    int currentStage = 0;
                    String exportStage = this.exportProcessingJob.getCurrentStage().toLowerCase();
                    if (this.stageNameToId.containsKey(exportStage)) {
                        currentStage = this.stageNameToId.get(exportStage);
                    }
                    long itemsProcessed = this.exportProcessingJob.getCurrentStageExportedItemsCount();
                    long itemsCount = this.exportProcessingJob.getTotalItemCount();
                    double stagePercentageComplete = 0.0;
                    if (itemsCount > 0L) {
                        stagePercentageComplete = (double)itemsProcessed / (double)itemsCount;
                    }
                    percentageComplete = (stagePercentageComplete + (double)currentStage) / (double)stageCount;
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block8;
                    LOGGER.debug("Cannot get progress.", (Throwable)e);
                }
            }
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        if (this.partSizePercentage > 0.0) {
            percentageComplete = percentageComplete * this.partSizePercentage + this.partStartPercentage;
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.exportProcessingJob != null) {
            if (this.workPart > 0) {
                result = (String)result + " / " + this.iu.getFormattedString("General.Progress.Part", (Object)this.workPart);
            }
            try {
                String exportStage;
                try {
                    exportStage = this.exportProcessingJob.getCurrentStage().equalsIgnoreCase("create_production_set") || this.exportProcessingJob.getCurrentStage().equalsIgnoreCase("cleanup") ? this.iu.getString("GeneratePrintedImagesOperation.Progress.CleaningUp") : FormattingUtils.stageToString((String)this.exportProcessingJob.getCurrentStage().toLowerCase());
                }
                catch (Exception e) {
                    exportStage = this.iu.getString("GeneratePrintedImagesOperation.Progress.Discovering");
                }
                if (((String)result).length() > 0) {
                    result = (String)result + " / ";
                }
                result = (String)result + exportStage;
                result = (String)result + this.iu.getNumeralString("GeneratePrintedImagesOperation.Progress.ItemsProcessed", this.exportProcessingJob.getCurrentStageExportedItemsCount());
            }
            catch (Exception exportStage) {}
        } else {
            String exportStage = this.iu.getString("GeneratePrintedImagesOperation.Progress.Initializing");
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + exportStage;
        }
        return result;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return "tag:\"" + this.tempTag + "\"";
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            LOGGER.info("Searching for tag:" + this.tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + this.tempTag + "\"");
            if (taggedItems.size() > 0) {
                LOGGER.info("Removing tag " + this.tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(this.tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + this.tempTag);
            this.executionContext.nuixCase.deleteTag(this.tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + this.tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.exportProcessingJob != null) {
            return this.exportProcessingJob.getJobGuid();
        }
        return null;
    }

    public void itemProcessed(ItemEventInfo itemEventInfo) {
        Item processedItem = itemEventInfo.getItem();
        String mimeType = "unknown";
        String pathName = "N/A";
        if (processedItem != null) {
            pathName = String.join((CharSequence)"/", processedItem.getPathNames());
            mimeType = processedItem.getType().getName();
        }
        String stage = itemEventInfo.getStage() == null ? "exported" : itemEventInfo.getStage();
        String translatedStage = this.iu.getString("MimeType.Stage." + stage);
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.ExportedStage", new Object[]{translatedStage, pathName}));
        this.trackItemProcessedFailed(mimeType, stage, itemEventInfo.getFailure() != null);
        if (this.tagFailedItems.booleanValue() && itemEventInfo.getFailure() != null) {
            this.failedItems.add(itemEventInfo.getItem());
        }
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        return prerequisites;
    }
}

