/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GraphService;
import com.nuix.automate.utils.models.api.thirdparty.GraphUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.GraphConfigureConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.utils.memgraph.MemgraphClient;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class GraphConfigureConnectionOperationImplementation
extends GraphConfigureConnectionOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigureRelativityConnectionOperation.class);
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                Path userDataDirProfilePath;
                String userDataDirPath;
                ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), GraphService.class.getSimpleName(), ParameterType.GRAPH_SERVICE);
                this.stageName = "";
                String username = null;
                String password = null;
                this.graphServiceId = this.executionContext.evalParameters(this.graphServiceId, this);
                this.playbookFile = this.executionContext.evalParameters(this.playbookFile, this).trim();
                if (Files.exists(Paths.get(this.playbookFile, new String[0]), new LinkOption[0])) {
                    LOGGER.info("Using explicitly playbook file: " + this.playbookFile);
                } else {
                    String playbookName = this.playbookFile;
                    if (this.executionContext.userDataDirPath != null && !this.executionContext.userDataDirPath.isEmpty()) {
                        this.playbookFile = Paths.get(this.executionContext.userDataDirPath, "Playbooks", playbookName + ".yml").toString();
                    }
                    if (!this.playbookFile.equals(playbookName)) {
                        LOGGER.info("Resolved playbook " + playbookName + " to file " + this.playbookFile);
                    } else {
                        throw new IllegalStateException(this.iu.getFormattedString("GraphConnectionOperation.Exception.CannotResolvePlaybook", (Object)playbookName));
                    }
                }
                if (this.thirdPartyServices == null || this.thirdPartyServices.get(this.graphServiceId) == null) {
                    throw new IllegalStateException(this.iu.getFormattedString("GraphConnectionOperation.Exception.MissingService", (Object)this.graphServiceId));
                }
                GraphService graphService = (GraphService)this.thirdPartyServices.get(this.graphServiceId);
                GraphUserCredential userCredential = (GraphUserCredential)graphService.getUserCredential();
                if (graphService.getAuthenticationMethod().equals((Object)ThirdPartyAuthenticationMethod.USERNAME_PASSWORD)) {
                    if (userCredential == null) {
                        throw new IllegalStateException(this.iu.getString("GraphPromoteOperation.Exception.MissingCredentials"));
                    }
                    username = userCredential.getUsername();
                    password = userCredential.getPassword();
                }
                String url = graphService.getUrl();
                GraphUserCredential graphUserCredential = null;
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_graph_service_id}", this.graphServiceId)));
                File userDataPlaybookFile = new File(this.playbookFile);
                if (!userDataPlaybookFile.exists() && (userDataDirPath = this.executionContext.userDataDirPath) != null && Files.exists(userDataDirProfilePath = FileUtils.safeResolveParent((String)userDataDirPath, (String[])new String[]{"Playbooks", this.playbookFile + ".yml"}), new LinkOption[0]) && Files.isRegularFile(userDataDirProfilePath, new LinkOption[0])) {
                    this.playbookFile = userDataDirProfilePath.toAbsolutePath().toString();
                }
                if (!Files.exists(Paths.get(this.playbookFile, new String[0]), new LinkOption[0])) {
                    throw new IOException(this.iu.getFormattedString("GraphConnectionOperation.Exception.PlaybookFileDoesNotExist", (Object)this.playbookFile));
                }
                this.executionContext.workflowExecution.log(this.iu.getFormattedString("GraphConnectionOperation.Log.PlaybookFile", (Object)this.playbookFile));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_memgraph_playbook_file}", this.playbookFile)));
                this.executionContext.workflowExecution.log(this.iu.getFormattedString("GraphConnectionOperation.Log.TransactionSize", (Object)this.transactionSize));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_memgraph_transaction_size}", "" + this.transactionSize)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_memgraph_url}", url)));
                if (username != null) {
                    graphUserCredential = new GraphUserCredential();
                    graphUserCredential.setUsername(username);
                    graphUserCredential.setPassword(password);
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_memgraph_username}", username)));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_memgraph_password}", password)));
                }
                try (MemgraphClient memgraphClient = new MemgraphClient(url);){
                    memgraphClient.test(graphUserCredential);
                    this.executionContext.workflowExecution.log(this.iu.getFormattedString("GraphConnectionOperation.Log.Connected", (Object)graphService.getName()));
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

