/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.GraphConfigureConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.MetadataExportOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.List;

@OperationMetadata(alias=OperationAlias.GRAPH_PROMOTE, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE", "GRAPH"}), @OperationTag(name="Category", value={"EXPORT"})})
@OperationLicenseModule(module=ModuleType.KNOWLEDGE_GRAPH)
public class GraphPromoteOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MetadataExportOperationImplementation.class);
    @FormField
    public boolean promoteItems = true;
    @FormField(required=false, enableOn={@OnField(name="promoteItems")})
    public String scope = "has-exclusion:0";
    @FormField
    public boolean promoteCase = true;

    @Override
    public String getOperationName() {
        return this.iu.getString("GraphPromoteOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.GRAPH_PROMOTE;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigure = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof GraphConfigureConnectionOperation) {
                detectedConfigure = true;
                break;
            }
            if (o == this) break;
        }
        if (!detectedConfigure) {
            prerequisites.add(this.iu.getString("GraphPromoteOperation.Prerequisites.MissingConfigureOperation"));
        }
        if ((activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED) && this.executionContext.nuixVersion.compareTo(new Version("100.6.0")) < 0) {
            prerequisites.add(this.iu.getString("GraphPromoteOperation.Prerequisites.UpdateNuixVersion"));
        }
        return prerequisites;
    }
}

